/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.List;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CreateServletTemplateModel {
    IDataModel dataModel = null;
    public static final String INIT = "init";
    public static final String TO_STRING = "toString";
    public static final String GET_SERVLET_INFO = "getServletInfo";
    public static final String DO_POST = "doPost";
    public static final String DO_PUT = "doPut";
    public static final String DO_DELETE = "doDelete";
    public static final String DESTROY = "destroy";
    public static final String DO_GET = "doGet";
    public static final int NAME = 0;
    public static final int VALUE = 1;
    public static final int DESCRIPTION = 2;

    public CreateServletTemplateModel(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public String getServletClassName() {
        return this.getProperty("NewJavaClassDataModel.CLASS_NAME");
    }

    public String getJavaPackageName() {
        return this.getProperty("NewJavaClassDataModel.JAVA_PACKAGE");
    }

    public String getQualifiedJavaClassName() {
        return String.valueOf(this.getJavaPackageName()) + "." + this.getServletClassName();
    }

    public String getSuperclassName() {
        return this.getProperty("NewJavaClassDataModel.SUPERCLASS");
    }

    public String getServletName() {
        return this.getProperty("NewJavaClassDataModel.CLASS_NAME");
    }

    public boolean isPublic() {
        return this.dataModel.getBooleanProperty("NewJavaClassDataModel.MODIFIER_PUBLIC");
    }

    public boolean isFinal() {
        return this.dataModel.getBooleanProperty("NewJavaClassDataModel.MODIFIER_FINAL");
    }

    public boolean isAbstract() {
        return this.dataModel.getBooleanProperty("NewJavaClassDataModel.MODIFIER_ABSTRACT");
    }

    protected String getProperty(String propertyName) {
        return this.dataModel.getStringProperty(propertyName);
    }

    public boolean shouldGenInit() {
        return this.implementImplementedMethod(INIT);
    }

    public boolean shouldGenToString() {
        return this.implementImplementedMethod(TO_STRING);
    }

    public boolean shouldGenGetServletInfo() {
        return this.implementImplementedMethod(GET_SERVLET_INFO);
    }

    public boolean shouldGenDoPost() {
        return this.implementImplementedMethod(DO_POST);
    }

    public boolean shouldGenDoPut() {
        return this.implementImplementedMethod(DO_PUT);
    }

    public boolean shouldGenDoDelete() {
        return this.implementImplementedMethod(DO_DELETE);
    }

    public boolean shouldGenDestroy() {
        return this.implementImplementedMethod(DESTROY);
    }

    public boolean shouldGenDoGet() {
        return this.implementImplementedMethod(DO_GET);
    }

    public List getInitParams() {
        return (List)this.dataModel.getProperty("NewServletClassDataModel.INIT_PARAM");
    }

    public String getInitParam(int index, int type) {
        List params = this.getInitParams();
        if (index < params.size()) {
            String[] stringArray = (String[])params.get(index);
            return stringArray[type];
        }
        return null;
    }

    public List getServletMappings() {
        return (List)this.dataModel.getProperty("NewServletClassDataModel.URL_MAPPINGS");
    }

    public String getServletMapping(int index) {
        List mappings = this.getServletMappings();
        if (index < mappings.size()) {
            String[] map = (String[])mappings.get(index);
            return map[0];
        }
        return null;
    }

    public String getServletDescription() {
        return this.dataModel.getStringProperty("NewServletClassDataModel.DESCRIPTION");
    }

    public List getInterfaces() {
        return (List)this.dataModel.getProperty("NewJavaClassDataModel.INTERFACES");
    }

    protected boolean implementImplementedMethod(String methodName) {
        if (this.dataModel.getBooleanProperty("NewJavaClassDataModel.ABSTRACT_METHODS")) {
            if (methodName.equals(INIT)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.INIT");
            }
            if (methodName.equals(TO_STRING)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.TO_STRING");
            }
            if (methodName.equals(GET_SERVLET_INFO)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.GET_SERVLET_INFO");
            }
            if (methodName.equals(DO_POST)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_POST");
            }
            if (methodName.equals(DO_PUT)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_PUT");
            }
            if (methodName.equals(DO_DELETE)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_DELETE");
            }
            if (methodName.equals(DESTROY)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DESTROY");
            }
            if (methodName.equals(DO_GET)) {
                return this.dataModel.getBooleanProperty("NewServletClassDataModel.DO_GET");
            }
        }
        return false;
    }
}

