/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;

public class NewProjectCreationWizard
extends BasicNewResourceWizard
implements INewWizard,
IExecutableExtension {
    protected WizardNewProjectCreationPage projectPage;
    protected IConfigurationElement configurationElement;
    protected IProject newProject;
    protected String defaultProjectName = "";

    public NewProjectCreationWizard() {
        this.setDefaultPageImageDescriptor(RubyPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setWindowTitle(RubyUIMessages.getString("NewProjectCreationWizard.windowTitle"));
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation(this.getProjectCreationRunnable());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (Exception exception) {
            RubyPlugin.log(exception);
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    protected IRunnableWithProgress getProjectCreationRunnable() {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                int n = 10;
                iProgressMonitor.beginTask(RubyUIMessages.getString("NewProjectCreationWizard.projectCreationMessage"), n);
                IWorkspace iWorkspace = RubyPlugin.getWorkspace();
                NewProjectCreationWizard.this.newProject = NewProjectCreationWizard.this.projectPage.getProjectHandle();
                IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(NewProjectCreationWizard.this.newProject.getName());
                IPath iPath = Platform.getLocation();
                IPath iPath2 = NewProjectCreationWizard.this.projectPage.getLocationPath();
                if (!iPath.equals((Object)iPath2)) {
                    iPath = iPath2;
                    iProjectDescription.setLocation(iPath);
                }
                try {
                    try {
                        if (!NewProjectCreationWizard.this.newProject.exists()) {
                            NewProjectCreationWizard.this.newProject.create(iProjectDescription, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            --n;
                        }
                        if (!NewProjectCreationWizard.this.newProject.isOpen()) {
                            NewProjectCreationWizard.this.newProject.open((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            --n;
                        }
                        RubyCore.addRubyNature((IProject)NewProjectCreationWizard.this.newProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n));
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                }
                iProgressMonitor.done();
            }
        };
    }

    public void addPages() {
        super.addPages();
        this.projectPage = new WizardNewProjectCreationPage(RubyUIMessages.getString("WizardNewProjectCreationPage.pageName"));
        this.projectPage.setTitle(RubyUIMessages.getString("WizardNewProjectCreationPage.pageTitle"));
        this.projectPage.setDescription(RubyUIMessages.getString("WizardNewProjectCreationPage.pageDescription"));
        this.projectPage.setInitialProjectName(this.getDefaultProjectName());
        this.projectPage.setImageDescriptor(RubyPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.addPage((IWizardPage)this.projectPage);
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        this.configurationElement = iConfigurationElement;
    }

    public String getDefaultProjectName() {
        return this.defaultProjectName;
    }

    public void setDefaultProjectName(String string) {
        this.defaultProjectName = string;
    }
}

