/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.comment;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.core.ToolFactory;
import org.rubypeople.rdt.core.formatter.CodeFormatter;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class CommentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private int fLastDocumentHash;
    private int fLastHeaderHash;
    private int fLastMainTokenEnd = -1;
    private int fLastDocumentsHeaderEnd;

    public void format() {
        super.format();
        IDocument iDocument = (IDocument)this.fDocuments.removeFirst();
        TypedPosition typedPosition = (TypedPosition)this.fPartitions.removeFirst();
        if (iDocument == null || typedPosition == null) {
            return;
        }
        Map map = this.getPreferences();
        boolean bl = Boolean.toString(true).equals(map.get("org.rubypeople.rdt.core.formatter.comment.format_header"));
        int n = this.computeHeaderEnd(iDocument);
        if (bl || typedPosition.offset >= n) {
            TextEdit textEdit = null;
            try {
                int n2 = iDocument.getLineOffset(iDocument.getLineOfOffset(typedPosition.getOffset()));
                int n3 = typedPosition.getOffset() - n2;
                int n4 = n3 + typedPosition.getLength();
                String string = iDocument.get(n2, n4);
                CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)map);
                int n5 = this.inferIndentationLevel(string.substring(0, n3), CommentFormattingStrategy.getTabSize(map));
                textEdit = codeFormatter.format(CommentFormattingStrategy.getKindForPartitionType(typedPosition.getType()), string, n3, typedPosition.getLength(), n5, TextUtilities.getDefaultLineDelimiter((IDocument)iDocument));
                if (textEdit != null) {
                    textEdit.moveTree(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                RubyPlugin.log(badLocationException);
            }
            try {
                if (textEdit != null) {
                    textEdit.apply(iDocument);
                }
            }
            catch (MalformedTreeException malformedTreeException) {
                RubyPlugin.log(malformedTreeException);
            }
            catch (BadLocationException badLocationException) {
                RubyPlugin.log(badLocationException);
            }
        }
    }

    public void formatterStarts(IFormattingContext iFormattingContext) {
        super.formatterStarts(iFormattingContext);
        this.fPartitions.addLast(iFormattingContext.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(iFormattingContext.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        this.fPartitions.clear();
        this.fDocuments.clear();
        super.formatterStops();
    }

    private static int getKindForPartitionType(String string) {
        if ("__ruby_singleline_comment".equals(string)) {
            return 16;
        }
        if ("__ruby_multiline_comment".equals(string)) {
            return 32;
        }
        if ("__ruby_rdoc".equals(string)) {
            return 64;
        }
        return 0;
    }

    private int inferIndentationLevel(String string, int n) {
        StringBuffer stringBuffer = CommentFormattingStrategy.expandTabs(string, n);
        int n2 = stringBuffer.length();
        if (n == 0) {
            return n2;
        }
        int n3 = 1;
        int n4 = n2 / (n * n3);
        if (n2 % (n * n3) > 0) {
            ++n4;
        }
        return n4;
    }

    private static StringBuffer expandTabs(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c == '\t') {
                while (n4 < n) {
                    stringBuffer.append(' ');
                    ++n4;
                }
                n4 = 0;
            } else {
                stringBuffer.append(c);
                if (++n4 >= n) {
                    n4 = 0;
                }
            }
            ++n2;
        }
        return stringBuffer;
    }

    private static int getTabSize(Map map) {
        if (map.containsKey("org.rubypeople.rdt.core.formatter.tabulation.size")) {
            try {
                return Integer.parseInt((String)map.get("org.rubypeople.rdt.core.formatter.tabulation.size"));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 4;
    }

    private int computeHeaderEnd(IDocument iDocument) {
        if (iDocument == null) {
            return -1;
        }
        try {
            if (this.fLastMainTokenEnd >= 0 && iDocument.hashCode() == this.fLastDocumentHash && this.fLastMainTokenEnd < iDocument.getLength() && iDocument.get(0, this.fLastMainTokenEnd).hashCode() == this.fLastHeaderHash) {
                return this.fLastDocumentsHeaderEnd;
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }
}

