/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.symbols.ISymbolTypes;
import org.rubypeople.rdt.internal.core.symbols.SearchResult;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.search.RubySearchResult;

public class RubySearchQuery
implements ISearchQuery,
ISymbolTypes {
    private String fSearchString;
    private RubySearchResult fResult;
    private int fSymbolType;

    public RubySearchQuery(String string, int n) {
        this.fSearchString = string;
        this.fSymbolType = n;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return this.toString();
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new RubySearchResult(this);
        }
        return this.fResult;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        Set set = RubyCore.getPlugin().getSymbolFinder().find(this.fSearchString, this.fSymbolType);
        MultiStatus multiStatus = set.iterator();
        while (multiStatus.hasNext()) {
            SearchResult searchResult = (SearchResult)multiStatus.next();
            int n = searchResult.getLocation().getPosition().getStartOffset();
            int n2 = searchResult.getLocation().getPosition().getEndOffset() - n;
            this.fResult.addMatch(new Match((Object)searchResult, 2, n, n2));
        }
        multiStatus = new MultiStatus("org.eclipse.search", 0, "Alright", null);
        return multiStatus;
    }

    public String toString() {
        String[] stringArray = new String[2];
        switch (this.fSymbolType) {
            case 1: {
                stringArray[0] = RubyUIMessages.getString("RubySearch.SearchForMethodSymbol");
                break;
            }
            case 0: {
                stringArray[0] = RubyUIMessages.getString("RubySearch.SearchForClassSymbol");
                break;
            }
        }
        stringArray[1] = this.fSearchString;
        return RubyUIMessages.getFormattedString("RubySearch.ResultLabel", stringArray);
    }
}

