/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class FindFinalizeInvocations
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"ffi.debug");
    private BugReporter bugReporter;
    boolean sawSuperFinalize;

    public FindFinalizeInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("FFI: visiting " + this.getFullyQualifiedMethodName());
        }
        if (this.getMethodName().equals("finalize") && this.getMethodSig().equals("()V") && (obj.getAccessFlags() & 1) != 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "FI_PUBLIC_SHOULD_BE_PROTECTED", 2).addClassAndMethod((PreorderVisitor)this));
        }
    }

    public void visit(Code obj) {
        this.sawSuperFinalize = false;
        super.visit(obj);
        if (!this.getMethodName().equals("finalize") || !this.getMethodSig().equals("()V")) {
            return;
        }
        String overridesFinalizeIn = Lookup.findSuperImplementor((String)this.getDottedClassName(), (String)"finalize", (String)"()V", (BugReporter)this.bugReporter);
        boolean superHasNoFinalizer = overridesFinalizeIn.equals("java.lang.Object");
        if (obj.getCode().length == 1) {
            if (superHasNoFinalizer) {
                if (!this.getMethod().isFinal()) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "FI_EMPTY", 2).addClassAndMethod((PreorderVisitor)this));
                }
            } else {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "FI_NULLIFY_SUPER", 2).addClassAndMethod((PreorderVisitor)this).addClass(overridesFinalizeIn));
            }
        } else if (obj.getCode().length == 5 && this.sawSuperFinalize) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "FI_USELESS", 2).addClassAndMethod((PreorderVisitor)this));
        } else if (!this.sawSuperFinalize && !superHasNoFinalizer) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "FI_MISSING_SUPER_CALL", 2).addClassAndMethod((PreorderVisitor)this).addClass(overridesFinalizeIn));
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && this.getNameConstantOperand().equals("finalize")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "FI_EXPLICIT_INVOCATION", this.getMethodName().equals("finalize") && this.getMethodSig().equals("()V") ? 1 : 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).describe("METHOD_CALLED").addSourceLine((BytecodeScanningDetector)this, this.getPC()));
        }
        if (seen == 183 && this.getNameConstantOperand().equals("finalize")) {
            this.sawSuperFinalize = true;
        }
    }
}

