/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ConditionCheck;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ImportDeclarationComparator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDoPrivilegedBlockResolution
extends BugResolution {
    private static final String DO_PRIVILEGED_METHOD_NAME = "doPrivileged";
    private boolean updateImports = true;
    private boolean staticImport = false;
    private Comparator<ImportDeclaration> importComparator = new ImportDeclarationComparator<ImportDeclaration>();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$CreateDoPrivilegedBlockResolution;
    static /* synthetic */ Class class$java$security$PrivilegedAction;
    static /* synthetic */ Class class$java$security$AccessController;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public CreateDoPrivilegedBlockResolution() {
    }

    public CreateDoPrivilegedBlockResolution(boolean updateImports) {
        this();
        this.setUpdateImports(updateImports);
    }

    public CreateDoPrivilegedBlockResolution(boolean updateImports, boolean staticImport) {
        this(updateImports);
        this.setStaticImport(staticImport);
    }

    public boolean isUpdateImports() {
        return this.updateImports;
    }

    public void setUpdateImports(boolean updateImports) {
        this.updateImports = updateImports;
    }

    public boolean isStaticImport() {
        return this.staticImport;
    }

    public void setStaticImport(boolean staticImport) {
        this.staticImport = staticImport;
    }

    public Comparator<ImportDeclaration> getImportComparator() {
        return this.importComparator;
    }

    public void setImportComparator(Comparator<ImportDeclaration> importComparator) {
        ConditionCheck.checkForNull(importComparator, "import comparator");
        this.importComparator = importComparator;
    }

    @Override
    protected boolean resolveBindings() {
        return true;
    }

    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && workingUnit == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bug == null) {
            throw new AssertionError();
        }
        ClassInstanceCreation classLoaderCreation = this.findClassLoaderCreation(ASTUtil.getASTNode(workingUnit, bug.getPrimarySourceLineAnnotation()));
        if (classLoaderCreation == null) {
            throw new BugResolutionException("No matching class loader creation found at the specified source line.");
        }
        this.updateVariableReferences(rewrite, classLoaderCreation);
        rewrite.replace((ASTNode)classLoaderCreation, (ASTNode)this.createDoPrivilegedInvocation(rewrite, classLoaderCreation), null);
        this.updateImportDeclarations(rewrite, workingUnit);
    }

    protected void updateVariableReferences(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        Set<String> variableReferences;
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classLoaderCreation == null) {
            throw new AssertionError();
        }
        MethodDeclaration method = this.findMethodDeclaration((ASTNode)classLoaderCreation);
        if (method != null && !(variableReferences = this.findVariableReferences(classLoaderCreation.arguments())).isEmpty()) {
            this.updateMethodParams(rewrite, variableReferences, method.parameters());
            this.updateLocalVariableDeclarations(rewrite, variableReferences, method.getBody());
        }
    }

    protected void updateMethodParams(ASTRewrite rewrite, Set<String> variables, List<SingleVariableDeclaration> params) {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && variables == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && params == null) {
            throw new AssertionError();
        }
        for (SingleVariableDeclaration param : params) {
            if (!variables.contains(param.getName().getFullyQualifiedName())) continue;
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)param, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            listRewrite.insertLast((ASTNode)rewrite.getAST().newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
        }
    }

    protected void updateLocalVariableDeclarations(final ASTRewrite rewrite, final Set<String> variables, Block block) {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && block == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && variables == null) {
            throw new AssertionError();
        }
        final AST ast = rewrite.getAST();
        block.accept(new ASTVisitor(){

            public boolean visit(VariableDeclarationFragment fragment) {
                ASTNode parent;
                if (variables.contains(fragment.getName().getFullyQualifiedName()) && (parent = fragment.getParent()) instanceof VariableDeclarationStatement) {
                    ListRewrite listRewrite = rewrite.getListRewrite(parent, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                    listRewrite.insertLast((ASTNode)ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), null);
                }
                return true;
            }
        });
    }

    protected void updateImportDeclarations(ASTRewrite rewrite, CompilationUnit compilationUnit) {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && compilationUnit == null) {
            throw new AssertionError();
        }
        if (this.isUpdateImports()) {
            AST ast = rewrite.getAST();
            TreeSet<ImportDeclaration> imports = new TreeSet<ImportDeclaration>(this.importComparator);
            imports.add(this.createImportDeclaration(ast, class$java$security$PrivilegedAction == null ? (class$java$security$PrivilegedAction = CreateDoPrivilegedBlockResolution.class$("java.security.PrivilegedAction")) : class$java$security$PrivilegedAction));
            if (!this.isStaticImport()) {
                imports.add(this.createImportDeclaration(ast, class$java$security$AccessController == null ? (class$java$security$AccessController = CreateDoPrivilegedBlockResolution.class$("java.security.AccessController")) : class$java$security$AccessController));
            } else {
                imports.add(this.createImportDeclaration(ast, class$java$security$AccessController == null ? (class$java$security$AccessController = CreateDoPrivilegedBlockResolution.class$("java.security.AccessController")) : class$java$security$AccessController, DO_PRIVILEGED_METHOD_NAME));
            }
            ASTUtil.addImports(rewrite, compilationUnit, imports);
        }
    }

    protected ImportDeclaration createImportDeclaration(AST ast, Class<?> importClass) {
        if (!$assertionsDisabled && ast == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && importClass == null) {
            throw new AssertionError();
        }
        return this.createImportDeclaration(ast, importClass.getName(), false);
    }

    protected ImportDeclaration createImportDeclaration(AST ast, Class<?> importClass, String javaElementName) {
        if (!$assertionsDisabled && ast == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && importClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && javaElementName == null) {
            throw new AssertionError();
        }
        return this.createImportDeclaration(ast, new StringBuffer().append(importClass.getName()).append(".").append(javaElementName).toString(), true);
    }

    private ImportDeclaration createImportDeclaration(AST ast, String name, boolean isStatic) {
        ImportDeclaration importDeclaration = ast.newImportDeclaration();
        importDeclaration.setName(ast.newName(name));
        importDeclaration.setStatic(isStatic);
        return importDeclaration;
    }

    protected MethodInvocation createDoPrivilegedInvocation(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        MethodInvocation doPrivilegedInvocation = ast.newMethodInvocation();
        ClassInstanceCreation privilegedActionCreation = this.createPrivilegedActionCreation(rewrite, classLoaderCreation);
        List arguments = doPrivilegedInvocation.arguments();
        if (!this.isStaticImport()) {
            Object accessControllerName = this.isUpdateImports() ? ast.newSimpleName(TigerSubstitutes.getSimpleName((Class)(class$java$security$AccessController == null ? (class$java$security$AccessController = CreateDoPrivilegedBlockResolution.class$("java.security.AccessController")) : class$java$security$AccessController))) : ast.newName((class$java$security$AccessController == null ? (class$java$security$AccessController = CreateDoPrivilegedBlockResolution.class$("java.security.AccessController")) : class$java$security$AccessController).getName());
            doPrivilegedInvocation.setExpression((Expression)accessControllerName);
        }
        doPrivilegedInvocation.setName(ast.newSimpleName(DO_PRIVILEGED_METHOD_NAME));
        arguments.add(privilegedActionCreation);
        return doPrivilegedInvocation;
    }

    private ClassInstanceCreation createPrivilegedActionCreation(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        ClassInstanceCreation privilegedActionCreation = ast.newClassInstanceCreation();
        ParameterizedType privilegedActionType = this.createPrivilegedActionType(rewrite, classLoaderCreation);
        AnonymousClassDeclaration anonymousClassDeclaration = this.createAnonymousClassDeclaration(rewrite, classLoaderCreation);
        privilegedActionCreation.setType((Type)privilegedActionType);
        privilegedActionCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
        return privilegedActionCreation;
    }

    private ParameterizedType createPrivilegedActionType(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        Object privilegedActionName = this.isUpdateImports() ? ast.newSimpleName(TigerSubstitutes.getSimpleName((Class)(class$java$security$PrivilegedAction == null ? (class$java$security$PrivilegedAction = CreateDoPrivilegedBlockResolution.class$("java.security.PrivilegedAction")) : class$java$security$PrivilegedAction))) : ast.newName((class$java$security$PrivilegedAction == null ? (class$java$security$PrivilegedAction = CreateDoPrivilegedBlockResolution.class$("java.security.PrivilegedAction")) : class$java$security$PrivilegedAction).getName());
        SimpleType rawPrivilegedActionType = ast.newSimpleType((Name)privilegedActionName);
        ParameterizedType privilegedActionType = ast.newParameterizedType((Type)rawPrivilegedActionType);
        Type typeArgument = (Type)rewrite.createCopyTarget((ASTNode)classLoaderCreation.getType());
        List typeArguments = privilegedActionType.typeArguments();
        typeArguments.add(typeArgument);
        return privilegedActionType;
    }

    private AnonymousClassDeclaration createAnonymousClassDeclaration(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        AnonymousClassDeclaration anonymousClassDeclaration = ast.newAnonymousClassDeclaration();
        MethodDeclaration runMethodDeclaration = this.createRunMethodDeclaration(rewrite, classLoaderCreation);
        List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
        bodyDeclarations.add(runMethodDeclaration);
        return anonymousClassDeclaration;
    }

    private MethodDeclaration createRunMethodDeclaration(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        SimpleName methodName = ast.newSimpleName("run");
        Type returnType = (Type)rewrite.createCopyTarget((ASTNode)classLoaderCreation.getType());
        Block methodBody = this.createRunMethodBody(rewrite, classLoaderCreation);
        List modifiers = methodDeclaration.modifiers();
        modifiers.add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        methodDeclaration.setName(methodName);
        methodDeclaration.setReturnType2(returnType);
        methodDeclaration.setBody(methodBody);
        return methodDeclaration;
    }

    private Block createRunMethodBody(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        Block methodBody = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        List statements = methodBody.statements();
        statements.add(returnStatement);
        returnStatement.setExpression((Expression)((ClassInstanceCreation)rewrite.createCopyTarget((ASTNode)classLoaderCreation)));
        return methodBody;
    }

    @CheckForNull
    private ClassInstanceCreation findClassLoaderCreation(ASTNode node) {
        ClassLoaderCreationFinder finder = new ClassLoaderCreationFinder();
        node.accept((ASTVisitor)finder);
        return finder.getClassLoaderCreation();
    }

    @CheckForNull
    private MethodDeclaration findMethodDeclaration(ASTNode node) {
        if (node == null || node instanceof MethodDeclaration) {
            return (MethodDeclaration)node;
        }
        return this.findMethodDeclaration(node.getParent());
    }

    private Set<String> findVariableReferences(List<Expression> arguments) {
        final HashSet<String> refs = new HashSet<String>();
        for (Expression argument : arguments) {
            argument.accept(new ASTVisitor(){

                public boolean visit(SimpleName node) {
                    if (!(node.getParent() instanceof Type)) {
                        refs.add(node.getFullyQualifiedName());
                    }
                    return true;
                }
            });
        }
        return refs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$CreateDoPrivilegedBlockResolution == null ? (class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$CreateDoPrivilegedBlockResolution = CreateDoPrivilegedBlockResolution.class$("edu.umd.cs.findbugs.plugin.eclipse.quickfix.CreateDoPrivilegedBlockResolution")) : class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$CreateDoPrivilegedBlockResolution).desiredAssertionStatus();
    }

    protected static class ClassLoaderCreationFinder
    extends ASTVisitor {
        private ClassInstanceCreation classLoaderCreation = null;

        protected ClassLoaderCreationFinder() {
        }

        public boolean visit(ClassInstanceCreation node) {
            if (this.classLoaderCreation == null) {
                if (!this.isClassLoaderCreation(node)) {
                    return true;
                }
                this.classLoaderCreation = node;
            }
            return false;
        }

        public ClassInstanceCreation getClassLoaderCreation() {
            return this.classLoaderCreation;
        }

        private boolean isClassLoaderCreation(ClassInstanceCreation classLoaderCreation) {
            return this.isClassLoader(classLoaderCreation.getType());
        }

        private boolean isClassLoader(Type type) {
            return this.isClassLoader(type.resolveBinding());
        }

        private boolean isClassLoader(ITypeBinding typeBinding) {
            if (typeBinding.getQualifiedName().equals((class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CreateDoPrivilegedBlockResolution.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName())) {
                return true;
            }
            ITypeBinding superclass = typeBinding.getSuperclass();
            return superclass != null && this.isClassLoader(superclass);
        }
    }
}

