/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class ModelConverter {
    protected GenModel genModel;
    protected List ePackages;
    protected Map ePackageToInfoMap;
    protected List referencedGenPackages;
    protected Map referencedGenPackageToInfoMap;
    protected ResourceSet externalGenModelResourceSet;
    protected List externalGenModelList;
    protected ReferencedEPackageFilter referencedEPackageFilter;
    protected ReferencedEPackageFilter referencedEPackageFilterToConvert;

    public void dispose() {
        this.clearEPackagesCollections();
        if (this.referencedGenPackages != null) {
            this.referencedGenPackages.clear();
            this.referencedGenPackages = null;
        }
        if (this.referencedGenPackageToInfoMap != null) {
            this.referencedGenPackageToInfoMap.clear();
            this.referencedGenPackageToInfoMap = null;
        }
        this.genModel = null;
        this.referencedEPackageFilter = null;
        this.referencedEPackageFilterToConvert = null;
    }

    public abstract String getID();

    protected String getConverterGenAnnotationSource() {
        return "http://www.eclipse.org/emf/2002/GenModel" + this.getID();
    }

    public GenModel getGenModel() {
        return this.genModel;
    }

    public List getEPackages() {
        if (this.ePackages == null) {
            this.ePackages = this.createEPackagesList();
        }
        return this.ePackages;
    }

    protected List createEPackagesList() {
        return new ConverterUtil.EPackageList();
    }

    public List getReferencedGenPackages() {
        if (this.referencedGenPackages == null) {
            this.referencedGenPackages = this.createReferencedGenPackagesList();
        }
        return this.referencedGenPackages;
    }

    protected List createReferencedGenPackagesList() {
        return new ConverterUtil.GenPackageList();
    }

    public void clearEPackagesCollections() {
        if (this.ePackages != null) {
            this.ePackages.clear();
            this.ePackages = null;
        }
        if (this.ePackageToInfoMap != null) {
            this.ePackageToInfoMap.clear();
            this.ePackageToInfoMap = null;
        }
        if (this.externalGenModelList != null) {
            this.externalGenModelList.clear();
            this.externalGenModelList = null;
        }
    }

    public ResourceSet createResourceSet() {
        return ConverterUtil.createResourceSet();
    }

    protected Map getEPackageToInfoMap() {
        if (this.ePackageToInfoMap == null) {
            this.ePackageToInfoMap = new HashMap();
        }
        return this.ePackageToInfoMap;
    }

    public EPackageConvertInfo getEPackageConvertInfo(EPackage ePackage) {
        EPackageConvertInfo ePackageInfo = (EPackageConvertInfo)this.getEPackageToInfoMap().get(ePackage);
        if (ePackageInfo == null) {
            ePackageInfo = this.createEPackageInfo(ePackage);
            this.getEPackageToInfoMap().put(ePackage, ePackageInfo);
        }
        return ePackageInfo;
    }

    public void clearEPackageConvertInfoCache() {
        this.getEPackageToInfoMap().clear();
    }

    protected EPackageConvertInfo createEPackageInfo(EPackage ePackage) {
        return new EPackageConvertInfo();
    }

    protected Map getReferencedGenPackageToInfoMap() {
        if (this.referencedGenPackageToInfoMap == null) {
            this.referencedGenPackageToInfoMap = new HashMap();
        }
        return this.referencedGenPackageToInfoMap;
    }

    public ReferencedGenPackageConvertInfo getReferenceGenPackageConvertInfo(GenPackage genPackage) {
        ReferencedGenPackageConvertInfo genPackageConvertInfo = (ReferencedGenPackageConvertInfo)this.getReferencedGenPackageToInfoMap().get(genPackage);
        if (genPackageConvertInfo == null) {
            genPackageConvertInfo = this.createGenPackageConvertInfo(genPackage);
            this.getReferencedGenPackageToInfoMap().put(genPackage, genPackageConvertInfo);
        }
        return genPackageConvertInfo;
    }

    public void clearReferenceGenPackageConvertInfoCache() {
        this.getReferencedGenPackageToInfoMap().clear();
    }

    protected ReferencedGenPackageConvertInfo createGenPackageConvertInfo(GenPackage genPackage) {
        return new ReferencedGenPackageConvertInfo();
    }

    public List filterReferencedEPackages(Collection ePackages, List referencedGenPackages) {
        if (this.referencedEPackageFilter == null) {
            this.referencedEPackageFilter = this.createReferencedEPackageFilter();
        }
        return this.referencedEPackageFilter.filterReferencedEPackages(ePackages, referencedGenPackages);
    }

    protected ReferencedEPackageFilter createReferencedEPackageFilter() {
        return new ReferencedEPackageFilter();
    }

    protected List computeEPackagesToConvert() {
        ConverterUtil.EPackageList ePackages = new ConverterUtil.EPackageList();
        Iterator i = this.getEPackages().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            if (!this.canConvert(ePackage)) continue;
            ePackages.add(ePackage);
        }
        return this.filterReferencedEPackagesToConvert((Collection)((Object)ePackages), null);
    }

    protected List filterReferencedEPackagesToConvert(Collection ePackages, List referencedGenPackages) {
        if (this.referencedEPackageFilterToConvert == null) {
            this.referencedEPackageFilterToConvert = this.createReferencedEPackageFilterToConvert();
        }
        return this.referencedEPackageFilterToConvert.filterReferencedEPackages(ePackages, referencedGenPackages);
    }

    protected List computeValidReferencedGenPackages() {
        if (this.referencedEPackageFilterToConvert == null) {
            this.referencedEPackageFilterToConvert = this.createReferencedEPackageFilterToConvert();
        }
        return this.referencedEPackageFilterToConvert.computeValidReferencedGenPackages();
    }

    protected ReferencedEPackageFilter createReferencedEPackageFilterToConvert() {
        return new ReferencedEPackageFilter();
    }

    protected boolean canConvert(EPackage ePackage) {
        return this.getEPackageConvertInfo(ePackage).isConvert();
    }

    public EPackage getReferredEPackage(GenPackage genPackage) {
        String nsURI = genPackage.getEcorePackage().getNsURI();
        if (nsURI != null) {
            Iterator j = this.getEPackages().iterator();
            while (j.hasNext()) {
                EPackage ePackage = (EPackage)j.next();
                if (!nsURI.equals(ePackage.getNsURI())) continue;
                return ePackage;
            }
        }
        return null;
    }

    public List getExternalGenModels() {
        if (this.externalGenModelList == null) {
            this.externalGenModelList = new UniqueEList.FastCompare();
            if (this.externalGenModelResourceSet == null) {
                this.externalGenModelResourceSet = this.createExternalGenModelResourceSet();
            }
            Map ePackageToGenModelMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
            EcoreUtil.ContentTreeIterator i = new EcoreUtil.ContentTreeIterator(this.getEPackages()){

                protected Iterator getEObjectChildren(EObject eObject) {
                    return ((EPackage)eObject).getESubpackages().iterator();
                }
            };
            while (i.hasNext()) {
                EPackage ePackage = (EPackage)i.next();
                URI genModelURI = (URI)ePackageToGenModelMap.get(ePackage.getNsURI());
                if (genModelURI == null) continue;
                try {
                    Resource genModelResource = this.externalGenModelResourceSet.getResource(genModelURI, false);
                    if (genModelResource == null) {
                        genModelResource = this.externalGenModelResourceSet.getResource(genModelURI, true);
                        this.externalGenModelList.add(genModelResource.getContents().get(0));
                    }
                }
                catch (Exception exception) {
                    ConverterPlugin.INSTANCE.log(exception);
                }
                i.prune();
            }
        }
        return this.externalGenModelList;
    }

    protected ResourceSet createExternalGenModelResourceSet() {
        return this.createResourceSet();
    }

    protected Map getGenmodelSaveOptions() {
        return Collections.EMPTY_MAP;
    }

    public void makeEPackageConvertDataUnique() {
        if (!this.getEPackageToInfoMap().isEmpty()) {
            HashMap<String, Integer> dataToCounter = new HashMap<String, Integer>();
            List ePackages = this.filterReferencedEPackages(this.getEPackageToInfoMap().keySet(), null);
            if (!ePackages.isEmpty()) {
                ArrayList<EPackageConvertInfo> packageInfos = new ArrayList<EPackageConvertInfo>(ePackages.size());
                Iterator i = ePackages.iterator();
                while (i.hasNext()) {
                    EPackage ePackage = (EPackage)i.next();
                    if (ePackage.getESuperPackage() != null && ePackages.contains(ePackage.getESuperPackage())) continue;
                    EPackageConvertInfo packageInfo = (EPackageConvertInfo)this.getEPackageToInfoMap().get(ePackage);
                    if (packageInfo.isConvert()) {
                        packageInfos.add(0, packageInfo);
                    } else {
                        packageInfos.add(packageInfo);
                    }
                    String data = packageInfo.getConvertData();
                    if (data == null) continue;
                    dataToCounter.put(data, null);
                }
                i = packageInfos.iterator();
                while (i.hasNext()) {
                    EPackageConvertInfo packageInfo = (EPackageConvertInfo)i.next();
                    String data = packageInfo.getConvertData();
                    if (data == null) continue;
                    Integer counterObject = (Integer)dataToCounter.get(data);
                    if (counterObject != null) {
                        int counter = counterObject;
                        int index = data.lastIndexOf(".");
                        StringBuffer newValue = null;
                        while (dataToCounter.containsKey((newValue = new StringBuffer(data).insert(index, counter++)).toString())) {
                        }
                        packageInfo.setConvertData(newValue.toString());
                        counterObject = new Integer(counter);
                        dataToCounter.put(newValue.toString(), new Integer(1));
                    } else {
                        counterObject = new Integer(1);
                    }
                    dataToCounter.put(data, counterObject);
                }
            }
        }
    }

    public static class EPackageConvertInfo {
        protected boolean convert = false;
        protected String convertData;

        public boolean isConvert() {
            return this.convert;
        }

        public void setConvert(boolean convert) {
            this.convert = convert;
        }

        public String getConvertData() {
            return this.convertData;
        }

        public void setConvertData(String convertData) {
            this.convertData = convertData;
        }
    }

    public static class ReferencedGenPackageConvertInfo {
        protected boolean validReference = true;

        public boolean isValidReference() {
            return this.validReference;
        }

        public void setValidReference(boolean validReference) {
            this.validReference = validReference;
        }
    }

    protected class ReferencedEPackageFilter {
        protected ReferencedEPackageFilter() {
        }

        public List computeValidReferencedGenPackages() {
            ConverterUtil.GenPackageList genPackages = new ConverterUtil.GenPackageList();
            Iterator i = ModelConverter.this.getReferencedGenPackages().iterator();
            while (i.hasNext()) {
                GenPackage genPackage = (GenPackage)i.next();
                EPackage ePackage = this.getReferredEPackage(genPackage);
                if (ePackage == null) continue;
                genPackages.add(genPackage);
            }
            return genPackages;
        }

        public List filterReferencedEPackages(Collection ePackages, List referencedGenPackages) {
            if (referencedGenPackages == null) {
                referencedGenPackages = ModelConverter.this.getReferencedGenPackages();
            }
            if (ePackages.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if (referencedGenPackages.isEmpty()) {
                return new ArrayList(ePackages);
            }
            ConverterUtil.EPackageList filteredEPackages = new ConverterUtil.EPackageList(ePackages);
            Iterator i = referencedGenPackages.iterator();
            while (i.hasNext()) {
                GenPackage genPackage = (GenPackage)i.next();
                EPackage ePackage = this.getReferredEPackage(genPackage);
                if (ePackage == null) continue;
                filteredEPackages.remove(ePackage);
            }
            return filteredEPackages;
        }

        protected EPackage getReferredEPackage(GenPackage genPackage) {
            return this.isValidReference(genPackage) ? ModelConverter.this.getReferredEPackage(genPackage) : null;
        }

        protected boolean isValidReference(GenPackage genPackage) {
            return ModelConverter.this.getReferenceGenPackageConvertInfo(genPackage).isValidReference();
        }
    }
}

