/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.journal;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Adler32;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.disk.journal.FileAppender;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.journal.ReplicationTarget;
import org.apache.activemq.store.kahadb.disk.util.DataByteArrayOutputStream;
import org.apache.activemq.store.kahadb.disk.util.LinkedNodeList;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.RecoverableRandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetedDataFileAppender
implements FileAppender {
    private static final Logger LOG = LoggerFactory.getLogger(TargetedDataFileAppender.class);
    private final Journal journal;
    private final DataFile target;
    private final Map<Journal.WriteKey, Journal.WriteCommand> inflightWrites;
    private final int maxWriteBatchSize;
    private boolean closed;
    private boolean preallocate;
    private WriteBatch nextWriteBatch;
    private int statIdx = 0;
    private int[] stats = new int[maxStat];

    public TargetedDataFileAppender(Journal journal, DataFile target) {
        this.journal = journal;
        this.target = target;
        this.inflightWrites = this.journal.getInflightWrites();
        this.maxWriteBatchSize = this.journal.getWriteBatchSize();
    }

    @Override
    public Location storeItem(ByteSequence data, byte type, boolean sync) throws IOException {
        this.checkClosed();
        int size = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        Journal.WriteCommand write = new Journal.WriteCommand(location, data, sync);
        this.enqueueWrite(write);
        if (sync) {
            this.writePendingBatch();
        }
        return location;
    }

    @Override
    public Location storeItem(ByteSequence data, byte type, Runnable onComplete) throws IOException {
        this.checkClosed();
        int size = data.getLength() + 5;
        Location location = new Location();
        location.setSize(size);
        location.setType(type);
        Journal.WriteCommand write = new Journal.WriteCommand(location, data, onComplete);
        this.enqueueWrite(write);
        return location;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.nextWriteBatch != null) {
                LOG.debug("Close of targeted appender flushing last batch.");
                this.writePendingBatch();
            }
            this.closed = true;
        }
    }

    public boolean isPreallocate() {
        return this.preallocate;
    }

    public void setPreallocate(boolean preallocate) {
        this.preallocate = preallocate;
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("The appender is clsoed");
        }
    }

    private WriteBatch enqueueWrite(Journal.WriteCommand write) throws IOException {
        while (true) {
            if (this.nextWriteBatch == null) {
                this.nextWriteBatch = new WriteBatch(this.target, this.target.getLength(), write);
                break;
            }
            if (this.nextWriteBatch.canAppend(write)) {
                this.nextWriteBatch.append(write);
                break;
            }
            this.writePendingBatch();
            this.nextWriteBatch = null;
        }
        if (!write.sync) {
            this.inflightWrites.put(new Journal.WriteKey(write.location), write);
        }
        return this.nextWriteBatch;
    }

    private void writePendingBatch() throws IOException {
        DataFile dataFile = this.nextWriteBatch.dataFile;
        try (RecoverableRandomAccessFile file = dataFile.openRandomAccessFile();
             DataByteArrayOutputStream buff = new DataByteArrayOutputStream(this.maxWriteBatchSize);){
            if (file.length() == 0L && this.isPreallocate()) {
                this.journal.preallocateEntireJournalDataFile(file);
            }
            buff.reset();
            buff.writeInt(Journal.BATCH_CONTROL_RECORD_SIZE);
            buff.writeByte(2);
            buff.write(Journal.BATCH_CONTROL_RECORD_MAGIC);
            buff.writeInt(0);
            buff.writeLong(0L);
            for (Journal.WriteCommand write = this.nextWriteBatch.writes.getHead(); write != null; write = (Journal.WriteCommand)write.getNext()) {
                buff.writeInt(write.location.getSize());
                buff.writeByte(write.location.getType());
                buff.write(write.data.getData(), write.data.getOffset(), write.data.getLength());
            }
            buff.writeInt(0);
            buff.writeByte(0);
            ByteSequence sequence = buff.toByteSequence();
            buff.reset();
            buff.skip(5 + Journal.BATCH_CONTROL_RECORD_MAGIC.length);
            buff.writeInt(sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE - 5);
            if (this.journal.isChecksum()) {
                Adler32 checksum = new Adler32();
                checksum.update(sequence.getData(), sequence.getOffset() + Journal.BATCH_CONTROL_RECORD_SIZE, sequence.getLength() - Journal.BATCH_CONTROL_RECORD_SIZE - 5);
                buff.writeLong(checksum.getValue());
            }
            file.seek(this.nextWriteBatch.offset);
            if (maxStat > 0) {
                if (this.statIdx < maxStat) {
                    this.stats[this.statIdx++] = sequence.getLength();
                } else {
                    long all = 0L;
                    while (this.statIdx > 0) {
                        all += (long)this.stats[--this.statIdx];
                    }
                    LOG.trace("Ave writeSize: {}", (Object)(all / (long)maxStat));
                }
            }
            file.write(sequence.getData(), sequence.getOffset(), sequence.getLength());
            ReplicationTarget replicationTarget = this.journal.getReplicationTarget();
            if (replicationTarget != null) {
                replicationTarget.replicate(this.nextWriteBatch.writes.getHead().location, sequence, true);
            }
            file.sync();
            this.signalDone(this.nextWriteBatch);
        }
        catch (IOException e) {
            LOG.info("Journal failed while writing at: {}", (Object)this.nextWriteBatch.offset);
            throw e;
        }
    }

    private void signalDone(WriteBatch writeBatch) {
        for (Journal.WriteCommand write = writeBatch.writes.getHead(); write != null; write = (Journal.WriteCommand)write.getNext()) {
            if (!write.sync) {
                this.inflightWrites.remove(new Journal.WriteKey(write.location));
            }
            if (write.onComplete == null) continue;
            try {
                write.onComplete.run();
                continue;
            }
            catch (Throwable e) {
                LOG.info("Add exception was raised while executing the run command for onComplete", e);
            }
        }
    }

    public class WriteBatch {
        protected final int offset;
        public final DataFile dataFile;
        public final LinkedNodeList<Journal.WriteCommand> writes = new LinkedNodeList();
        public int size = Journal.BATCH_CONTROL_RECORD_SIZE;
        public AtomicReference<IOException> exception = new AtomicReference();

        public WriteBatch(DataFile dataFile, int offset) {
            this.dataFile = dataFile;
            this.offset = offset;
            this.dataFile.incrementLength(Journal.BATCH_CONTROL_RECORD_SIZE);
            this.size = Journal.BATCH_CONTROL_RECORD_SIZE;
            TargetedDataFileAppender.this.journal.addToTotalLength(Journal.BATCH_CONTROL_RECORD_SIZE);
        }

        public WriteBatch(DataFile dataFile, int offset, Journal.WriteCommand write) throws IOException {
            this(dataFile, offset);
            this.append(write);
        }

        public boolean canAppend(Journal.WriteCommand write) {
            int newSize = this.size + write.location.getSize();
            return newSize < TargetedDataFileAppender.this.maxWriteBatchSize;
        }

        public void append(Journal.WriteCommand write) throws IOException {
            this.writes.addLast(write);
            write.location.setDataFileId(this.dataFile.getDataFileId());
            write.location.setOffset(this.offset + this.size);
            int s = write.location.getSize();
            this.size += s;
            this.dataFile.incrementLength(s);
            TargetedDataFileAppender.this.journal.addToTotalLength(s);
        }
    }
}

