/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.xml;

public class XMLUtils {
    private static final String[] _chars;

    public static String xmlEncode(String original) {
        if (original == null) {
            return null;
        }
        char[] chars = original.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < _chars.length) {
                sb.append(_chars[c]);
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                int j = i + 1;
                if (j >= len || !Character.isLowSurrogate(chars[j])) continue;
                sb.append("&#x").append(Integer.toHexString(Character.toCodePoint(c, chars[j]))).append(';');
                i = j;
                continue;
            }
            if (Character.isLowSurrogate(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String xmlEncodeRaw(String s) {
        if (s == null) {
            return null;
        }
        char[] chars = s.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c < _chars.length) {
                sb.append(_chars[c]);
                continue;
            }
            if (Character.isHighSurrogate(c)) {
                int j = i + 1;
                if (j >= len || !Character.isLowSurrogate(chars[j])) continue;
                sb.append("&#x").append(Integer.toHexString(Character.toCodePoint(c, chars[j]))).append(';');
                i = j;
                continue;
            }
            if (Character.isLowSurrogate(c)) continue;
            sb.append("&#x").append(Integer.toHexString(c)).append(';');
        }
        return sb.toString();
    }

    public static String htmlEncode(String s) {
        return XMLUtils.xmlEncodeRaw(s);
    }

    public static String xmlDecode(String s) throws IllegalArgumentException {
        if (s == null) {
            return s;
        }
        int idxS = s.indexOf(38);
        if (idxS < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int prev = 0;
        while (idxS != -1) {
            int idxE = s.indexOf(59, idxS);
            if (idxE < 0) {
                throw new IllegalArgumentException("missing ';' in: " + s.substring(idxS));
            }
            sb.append(s.substring(prev, idxS));
            int idx = idxS + 1;
            int size = idxE - idxS - 1;
            if (size < 2) {
                throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
            }
            char c = s.charAt(idx);
            char c_1 = s.charAt(idx + 1);
            switch (c) {
                case 'l': {
                    if (size != 2) {
                        throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                    }
                    if (c_1 == 't') {
                        sb.append('<');
                        break;
                    }
                    throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                }
                case 'g': {
                    if (size != 2) {
                        throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                    }
                    if (c_1 == 't') {
                        sb.append('>');
                        break;
                    }
                    throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                }
                case 'q': {
                    if (size != 4) {
                        throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                    }
                    if (c_1 != 'u' || s.charAt(idx + 2) != 'o' || s.charAt(idx + 3) != 't') {
                        throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                    }
                    sb.append('\"');
                    break;
                }
                case 'a': {
                    if (size == 3) {
                        if (c_1 != 'm' || s.charAt(idx + 2) != 'p') {
                            throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                        }
                        sb.append('&');
                        break;
                    }
                    if (size == 4) {
                        if (c_1 != 'p' || s.charAt(idx + 2) != 'o' || s.charAt(idx + 3) != 's') {
                            throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                        }
                        sb.append('\'');
                        break;
                    }
                    throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                }
                case '#': {
                    int codePoint;
                    try {
                        codePoint = c_1 == 'x' ? Integer.parseInt(s.substring(idx + 2, idxE), 16) : Integer.parseInt(s.substring(idx + 1, idxE));
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                    }
                    if (codePoint < 0) {
                        throw new IllegalArgumentException("invalid character codepoint: " + s.substring(idxS, idxE + 1));
                    }
                    if (codePoint < 65536) {
                        sb.append((char)codePoint);
                        break;
                    }
                    sb.append(Character.toChars(codePoint));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid escape tag: " + s.substring(idxS, idxE + 1));
                }
            }
            prev = idxE + 1;
            idxS = s.indexOf("&", prev);
        }
        if (prev < s.length()) {
            sb.append(s.substring(prev));
        }
        return sb.toString();
    }

    public static String xmlDecodeSafely(String str) {
        int idxS = str.indexOf("&");
        if (idxS < 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        int prev = 0;
        while (idxS != -1) {
            int idxE;
            if (prev < idxS) {
                sb.append(str.substring(prev, idxS));
                prev = idxS;
            }
            if ((idxE = str.indexOf(";", idxS)) < 0) break;
            int idx = idxS + 1;
            int size = idxE - idxS - 1;
            if (size < 2) {
                sb.append(str.substring(idxS, idxE + 1));
            } else {
                char c = str.charAt(idx);
                switch (c) {
                    case 'l': {
                        if (XMLUtils.xmlDecodeLT(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case 'g': {
                        if (XMLUtils.xmlDecodeGT(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case 'q': {
                        if (XMLUtils.xmlDecodeQUOT(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case 'a': {
                        if (XMLUtils.xmlDecodeAMPAPOS(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case 'n': {
                        if (XMLUtils.xmlDecodeNBSP(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case '#': {
                        if (XMLUtils.xmlDecodeNumber(str, idx, sb, idxE)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    default: {
                        sb.append("&");
                        idxE = idxS;
                    }
                }
            }
            prev = idxE + 1;
            idxS = str.indexOf("&", prev);
        }
        if (prev < str.length()) {
            sb.append(str.substring(prev));
        }
        return sb.toString();
    }

    private static boolean xmlDecodeLT(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c_1 = str.charAt(idx + 1);
        if (size != 2 || c_1 != 't') {
            isRecognized = false;
        } else {
            sb.append('<');
        }
        return isRecognized;
    }

    private static boolean xmlDecodeGT(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c_1 = str.charAt(idx + 1);
        if (size != 2 || c_1 != 't') {
            isRecognized = false;
        } else {
            sb.append('>');
        }
        return isRecognized;
    }

    private static boolean xmlDecodeQUOT(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c_1 = str.charAt(idx + 1);
        if (size != 4 || c_1 != 'u' || str.charAt(idx + 2) != 'o' || str.charAt(idx + 3) != 't') {
            isRecognized = false;
        } else {
            sb.append('\"');
        }
        return isRecognized;
    }

    private static boolean xmlDecodeAMPAPOS(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c_1 = str.charAt(idx + 1);
        if (size == 3 && c_1 == 'm' && str.charAt(idx + 2) == 'p') {
            sb.append('&');
        } else if (size == 4 && c_1 == 'p' && str.charAt(idx + 2) == 'o' && str.charAt(idx + 3) == 's') {
            sb.append('\'');
        } else {
            isRecognized = false;
        }
        return isRecognized;
    }

    private static boolean xmlDecodeNBSP(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c_1 = str.charAt(idx + 1);
        if (size != 4 || c_1 != 'b' || str.charAt(idx + 2) != 's' || str.charAt(idx + 3) != 'p') {
            isRecognized = false;
        } else {
            sb.append(' ');
        }
        return isRecognized;
    }

    private static boolean xmlDecodeNumber(String str, int idx, StringBuilder sb, int idxE) {
        boolean isRecognized = true;
        try {
            char c = '\u0000';
            char c_1 = str.charAt(idx + 1);
            c = c_1 == 'x' ? (char)Integer.parseInt(str.substring(idx + 2, idxE), 16) : (char)Integer.parseInt(str.substring(idx + 1, idxE));
            sb.append(c);
        }
        catch (NumberFormatException ex) {
            isRecognized = false;
        }
        return isRecognized;
    }

    private XMLUtils() {
    }

    static {
        int i;
        _chars = new String[128];
        for (i = 32; i < _chars.length; ++i) {
            XMLUtils._chars[i] = String.valueOf((char)i);
        }
        for (i = 0; i < 32; ++i) {
            XMLUtils._chars[i] = " ";
        }
        XMLUtils._chars[9] = "\t";
        XMLUtils._chars[10] = "\n";
        XMLUtils._chars[13] = "\r";
        XMLUtils._chars[60] = "&lt;";
        XMLUtils._chars[62] = "&gt;";
        XMLUtils._chars[38] = "&amp;";
        XMLUtils._chars[34] = "&quot;";
    }
}

