/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.owasp.jbrofuzz.version.ImageCreator;

public final class AboutBox
extends JDialog
implements KeyListener {
    private static final long serialVersionUID = 2826027958413054181L;
    private static final int SIZE_X = 450;
    private static final int SIZE_Y = 300;
    private final transient JTabbedPane tabbedPane;

    public AboutBox(JFrame parent, Tab selectedTab) {
        super(parent, " JBroFuzz - About ", true);
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.setFont(new Font("SansSerif", 0, 12));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)this.createAbout(), " About ");
        this.tabbedPane.add((Component)this.createLicense(), " License ");
        this.tabbedPane.add((Component)this.createDisclaimer(), " Disclaimer ");
        this.tabbedPane.add((Component)this.createAcknowledgements(), " Acknowledgements ");
        this.tabbedPane.add((Component)this.createCode(), " Code ");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.setTab(selectedTab);
        JButton ok = new JButton("  OK  ");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 15, 15));
        buttonPanel.add(ok);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AboutBox.this.dispose();
                    }
                });
            }
        });
        ok.addKeyListener(this);
        this.tabbedPane.addKeyListener(this);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setLocation(parent.getLocation().x + (parent.getWidth() - 450) / 2, parent.getLocation().y + (parent.getHeight() - 300) / 2);
        this.setSize(450, 300);
        this.setMinimumSize(new Dimension(450, 300));
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void keyTyped(KeyEvent kEvent) {
    }

    @Override
    public void keyPressed(KeyEvent kEvent) {
        if (kEvent.getKeyCode() == 27) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent kEvent) {
    }

    private JComponent createCode() {
        JEditorPane code;
        JLabel codeLabel = new JLabel(ImageCreator.IMG_OWASP);
        codeLabel.setLocation(20, 45);
        codeLabel.setSize(100, 100);
        URL codeURL = ClassLoader.getSystemClassLoader().getResource("LICENSE/CODE.txt");
        try {
            code = new JEditorPane(codeURL);
        }
        catch (IOException eAbout) {
            code = new JEditorPane();
            code.setText("Code information cannot be found!");
        }
        code.setEditable(false);
        code.addKeyListener(this);
        JScrollPane codeScroll = new JScrollPane(code);
        codeScroll.setVerticalScrollBarPolicy(20);
        codeScroll.setHorizontalScrollBarPolicy(30);
        codeScroll.setLocation(140, 5);
        codeScroll.setSize(290, 185);
        JPanel codePanel = new JPanel();
        codePanel.setLayout(null);
        codePanel.add(codeLabel);
        codePanel.add(codeScroll);
        return codePanel;
    }

    private JComponent createAcknowledgements() {
        JEditorPane acknowledgements;
        URL acknowledgementsURL = ClassLoader.getSystemClassLoader().getResource("LICENSE/ACKNOWLEDGEMENTS.txt");
        try {
            acknowledgements = new JEditorPane(acknowledgementsURL);
        }
        catch (IOException e) {
            acknowledgements = new JEditorPane();
            acknowledgements.setText("Acknoledgements file cannot be found");
        }
        acknowledgements.setEditable(false);
        acknowledgements.addKeyListener(this);
        JScrollPane ackScrollPane = new JScrollPane(acknowledgements);
        ackScrollPane.setVerticalScrollBarPolicy(20);
        ackScrollPane.setHorizontalScrollBarPolicy(30);
        return ackScrollPane;
    }

    private JComponent createDisclaimer() {
        JEditorPane disclaimer;
        JLabel disclaimerLabel = new JLabel(ImageCreator.IMG_OWASP);
        disclaimerLabel.setLocation(20, 45);
        disclaimerLabel.setSize(100, 100);
        URL disclaimerURL = ClassLoader.getSystemClassLoader().getResource("LICENSE/DISCLAIMER.txt");
        try {
            disclaimer = new JEditorPane(disclaimerURL);
        }
        catch (IOException eAbout) {
            disclaimer = new JEditorPane();
            disclaimer.setText("About information cannot be found!");
        }
        disclaimer.setEditable(false);
        disclaimer.addKeyListener(this);
        JScrollPane disclaimerScroll = new JScrollPane(disclaimer);
        disclaimerScroll.setVerticalScrollBarPolicy(20);
        disclaimerScroll.setHorizontalScrollBarPolicy(30);
        disclaimerScroll.setLocation(140, 5);
        disclaimerScroll.setSize(290, 185);
        JPanel disclaimerPanel = new JPanel();
        disclaimerPanel.setLayout(null);
        disclaimerPanel.add(disclaimerLabel);
        disclaimerPanel.add(disclaimerScroll);
        return disclaimerPanel;
    }

    private JComponent createLicense() {
        JEditorPane license;
        URL licenseURL = ClassLoader.getSystemClassLoader().getResource("LICENSE/gpl-license.txt");
        try {
            license = new JEditorPane(licenseURL);
        }
        catch (IOException e) {
            license = new JEditorPane();
            license.setText("GPL Licence file cannot be found!");
        }
        license.setEditable(false);
        license.addKeyListener(this);
        JScrollPane lcsScrollPane = new JScrollPane(license);
        lcsScrollPane.setVerticalScrollBarPolicy(20);
        lcsScrollPane.setHorizontalScrollBarPolicy(30);
        return lcsScrollPane;
    }

    private JComponent createAbout() {
        JEditorPane about;
        JLabel aboutLabel = new JLabel(ImageCreator.IMG_OWASP);
        aboutLabel.setLocation(20, 45);
        aboutLabel.setSize(100, 100);
        URL aboutURL = ClassLoader.getSystemClassLoader().getResource("LICENSE/ABOUT.txt");
        try {
            about = new JEditorPane(aboutURL);
        }
        catch (IOException eAbout) {
            about = new JEditorPane();
            about.setText("About information cannot be found!");
        }
        about.setEditable(false);
        about.addKeyListener(this);
        JScrollPane aboutScroll = new JScrollPane(about);
        aboutScroll.setVerticalScrollBarPolicy(20);
        aboutScroll.setHorizontalScrollBarPolicy(30);
        aboutScroll.setLocation(140, 5);
        aboutScroll.setSize(290, 185);
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(null);
        aboutPanel.add(aboutLabel);
        aboutPanel.add(aboutScroll);
        return aboutPanel;
    }

    private void setTab(Tab myTab) {
        switch (myTab) {
            case ABOUT: {
                this.tabbedPane.setSelectedIndex(0);
                break;
            }
            case LICENSE: {
                this.tabbedPane.setSelectedIndex(1);
                break;
            }
            case DISCLAIMER: {
                this.tabbedPane.setSelectedIndex(2);
                break;
            }
            case ACKNOWLEDGEMENTS: {
                this.tabbedPane.setSelectedIndex(3);
                break;
            }
            case CODE: {
                this.tabbedPane.setSelectedIndex(4);
                break;
            }
            default: {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    public static enum Tab {
        ABOUT,
        LICENSE,
        DISCLAIMER,
        ACKNOWLEDGEMENTS,
        CODE;

    }
}

