/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.params.ExtensionParams;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.ParamsTableModel;
import org.zaproxy.zap.extension.params.SiteParameters;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.view.ScanPanel;

public class ParamsPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "params";
    private ExtensionParams extension = null;
    private JPanel panelCommand = null;
    private JToolBar panelToolbar = null;
    private JScrollPane jScrollPane = null;
    private String currentSite = null;
    private JComboBox<String> siteSelect = null;
    private SortedComboBoxModel<String> siteModel = new SortedComboBoxModel();
    private JXTable paramsTable = null;
    private ParamsTableModel paramsModel = new ParamsTableModel();

    public ParamsPanel(ExtensionParams extensionParams) {
        this.extension = extensionParams;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(474, 251);
        this.setName(Constant.messages.getString("params.panel.title"));
        this.setIcon(new ImageIcon(ParamsPanel.class.getResource("/resource/icon/16/179.png")));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("params.panel.mnemonic"));
        this.add((Component)this.getPanelCommand(), this.getPanelCommand().getName());
    }

    private JPanel getPanelCommand() {
        if (this.panelCommand == null) {
            this.panelCommand = new JPanel();
            this.panelCommand.setLayout(new GridBagLayout());
            this.panelCommand.setName("Params");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 18;
            this.panelCommand.add((Component)this.getPanelToolbar(), gridBagConstraints);
            this.panelCommand.add((Component)this.getJScrollPane(), gridBagConstraints2);
        }
        return this.panelCommand;
    }

    private JToolBar getPanelToolbar() {
        if (this.panelToolbar == null) {
            this.panelToolbar = new JToolBar();
            this.panelToolbar.setLayout(new GridBagLayout());
            this.panelToolbar.setEnabled(true);
            this.panelToolbar.setFloatable(false);
            this.panelToolbar.setRollover(true);
            this.panelToolbar.setPreferredSize(new Dimension(800, 30));
            this.panelToolbar.setName("ParamsToolbar");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.fill = 2;
            JLabel jLabel = new JLabel();
            this.panelToolbar.add((Component)new JLabel(Constant.messages.getString("params.toolbar.site.label")), gridBagConstraints2);
            this.panelToolbar.add(this.getSiteSelect(), gridBagConstraints3);
            this.panelToolbar.add((Component)jLabel, gridBagConstraints4);
        }
        return this.panelToolbar;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)this.getParamsTable());
        }
        return this.jScrollPane;
    }

    private void setParamsTableColumnSizes() {
        this.paramsTable.getColumnModel().getColumn(0).setMinWidth(50);
        this.paramsTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.paramsTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.paramsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.paramsTable.getColumnModel().getColumn(2).setMinWidth(50);
        this.paramsTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.paramsTable.getColumnModel().getColumn(3).setMinWidth(50);
        this.paramsTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.paramsTable.getColumnModel().getColumn(4).setMinWidth(50);
        this.paramsTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        this.paramsTable.getColumnModel().getColumn(5).setMinWidth(50);
        this.paramsTable.getColumnModel().getColumn(5).setPreferredWidth(200);
    }

    protected JXTable getParamsTable() {
        if (this.paramsTable == null) {
            this.paramsTable = new JXTable((TableModel)this.paramsModel);
            this.paramsTable.setColumnSelectionAllowed(false);
            this.paramsTable.setCellSelectionEnabled(false);
            this.paramsTable.setRowSelectionAllowed(true);
            this.paramsTable.setAutoCreateRowSorter(true);
            this.paramsTable.setColumnControlVisible(true);
            this.setParamsTableColumnSizes();
            this.paramsTable.setName(PANEL_NAME);
            this.paramsTable.setDoubleBuffered(true);
            this.paramsTable.setSelectionMode(0);
            this.paramsTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.showPopupMenuIfTriggered(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.showPopupMenuIfTriggered(mouseEvent);
                }

                private void showPopupMenuIfTriggered(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        int n = ParamsPanel.this.paramsTable.rowAtPoint(mouseEvent.getPoint());
                        if (n < 0 || !ParamsPanel.this.paramsTable.getSelectionModel().isSelectedIndex(n)) {
                            ParamsPanel.this.paramsTable.getSelectionModel().clearSelection();
                            if (n >= 0) {
                                ParamsPanel.this.paramsTable.getSelectionModel().setSelectionInterval(n, n);
                            }
                        }
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.paramsTable;
    }

    private JComboBox<String> getSiteSelect() {
        if (this.siteSelect == null) {
            this.siteSelect = new JComboBox<String>(this.siteModel);
            this.siteSelect.addItem(Constant.messages.getString("params.toolbar.site.select"));
            this.siteSelect.setSelectedIndex(0);
            this.siteSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)ParamsPanel.this.siteSelect.getSelectedItem();
                    if (string != null && ParamsPanel.this.siteSelect.getSelectedIndex() > 0) {
                        ParamsPanel.this.siteSelected(string);
                    }
                }
            });
        }
        return this.siteSelect;
    }

    public void addSite(String string) {
        if (this.siteModel.getIndexOf(string = ScanPanel.cleanSiteName(string, true)) < 0) {
            this.siteModel.addElement(string);
            if (this.siteModel.getSize() == 2 && this.currentSite == null) {
                this.getSiteSelect().setSelectedIndex(1);
                this.siteSelected(string);
            }
        }
    }

    private void siteSelected(String string) {
        if (!(string = ScanPanel.cleanSiteName(string, true)).equals(this.currentSite)) {
            this.siteModel.setSelectedItem(string);
            this.paramsModel = this.extension.getSiteParameters(string).getModel();
            this.getParamsTable().setModel((TableModel)this.paramsModel);
            this.setParamsTableColumnSizes();
            this.currentSite = string;
        }
    }

    public void nodeSelected(SiteNode siteNode) {
        if (siteNode != null) {
            this.siteSelected(ScanPanel.cleanSiteName(siteNode, true));
        }
    }

    public void reset() {
        this.currentSite = null;
        this.siteModel.removeAllElements();
        this.siteSelect.addItem(Constant.messages.getString("params.toolbar.site.select"));
        this.siteSelect.setSelectedIndex(0);
        this.paramsModel.removeAllElements();
        this.paramsModel.fireTableDataChanged();
        this.paramsTable.setModel((TableModel)this.paramsModel);
    }

    public String getCurrentSite() {
        return this.currentSite;
    }

    protected HtmlParameterStats getSelectedParam() {
        int n = this.getParamsTable().getSelectedRow();
        if (n == -1) {
            return null;
        }
        String string = (String)this.getParamsTable().getValueAt(n, 0);
        String string2 = (String)this.getParamsTable().getValueAt(n, 1);
        SiteParameters siteParameters = this.extension.getSiteParameters(this.currentSite);
        if (siteParameters != null) {
            return siteParameters.getParam(HtmlParameter.Type.valueOf(string.toLowerCase()), string2);
        }
        return null;
    }
}

