/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight;

import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;

public abstract class AutoDetectSyntaxHttpPanelTextArea
extends HttpPanelSyntaxHighlightTextArea {
    private static final long serialVersionUID = 293746373028878338L;
    private static final String AUTO_DETECT = "autodetect";
    private boolean isAutoDetectSyntax = true;

    @Override
    public void setMessage(Message message) {
        super.setMessage(message);
        if (this.isAutoDetectSyntax) {
            this.detectAndSetSyntax();
        }
    }

    public boolean isAutoDetectSyntax() {
        return this.isAutoDetectSyntax;
    }

    public void setAutoDetectSyntax(boolean bl) {
        this.isAutoDetectSyntax = bl;
        if (this.isAutoDetectSyntax) {
            this.detectAndSetSyntax();
        }
    }

    private void detectAndSetSyntax() {
        Message message = this.getMessage();
        if (message instanceof HttpMessage) {
            String string = this.detectSyntax((HttpMessage)message);
            this.setSyntaxEditingStyle(string);
        }
    }

    protected abstract String detectSyntax(HttpMessage var1);

    @Override
    public void loadConfiguration(String string, FileConfiguration fileConfiguration) {
        super.loadConfiguration(string, fileConfiguration);
        this.setAutoDetectSyntax(fileConfiguration.getBoolean(string + "syntax." + AUTO_DETECT, this.isAutoDetectSyntax));
    }

    @Override
    public void saveConfiguration(String string, FileConfiguration fileConfiguration) {
        super.saveConfiguration(string, fileConfiguration);
        fileConfiguration.setProperty(string + "syntax." + AUTO_DETECT, (Object)this.isAutoDetectSyntax);
    }
}

