/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.security.InvalidParameterException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.ThreadPool;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.script.ScriptCollection;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;

public class Scanner
implements Runnable {
    private static Logger log = Logger.getLogger(Scanner.class);
    private static DecimalFormat decimalFormat = new DecimalFormat("###0.###");
    private Vector<ScannerListener> listenerList = new Vector();
    private Vector<ScannerHook> hookList = new Vector();
    private ScannerParam scannerParam = null;
    private ConnectionParam connectionParam = null;
    private ScanPolicy scanPolicy;
    private boolean isStop = false;
    private ThreadPool pool = null;
    private Target target = null;
    private long startTimeMillis = 0L;
    private List<Pattern> excludeUrls = null;
    private boolean justScanInScope = false;
    private boolean scanChildren = true;
    private User user = null;
    private TechSet techSet = null;
    private Set<ScriptCollection> scriptCollections = new HashSet<ScriptCollection>();
    private int id;
    private boolean pause = false;
    private List<HostProcess> hostProcesses = new ArrayList<HostProcess>();

    public Scanner(ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy) {
        this.connectionParam = connectionParam;
        this.scannerParam = scannerParam;
        this.scanPolicy = scanPolicy;
        this.pool = new ThreadPool(scannerParam.getHostPerScan());
        Control.getSingleton().getExtensionLoader().hookScannerHook(this);
    }

    public void start(SiteNode siteNode) {
        this.start(new Target(siteNode));
    }

    public void start(Target target) {
        this.isStop = false;
        log.info((Object)"scanner started");
        this.startTimeMillis = System.currentTimeMillis();
        this.target = target;
        Thread thread = new Thread(this);
        thread.setPriority(3);
        thread.start();
    }

    public void stop() {
        log.info((Object)"scanner stopped");
        this.isStop = true;
    }

    public void addScannerListener(ScannerListener scannerListener) {
        this.listenerList.add(scannerListener);
    }

    public void removeScannerListener(ScannerListener scannerListener) {
        this.listenerList.remove(scannerListener);
    }

    public void addScannerHook(ScannerHook scannerHook) {
        this.hookList.add(scannerHook);
    }

    public void removerScannerHook(ScannerHook scannerHook) {
        this.hookList.remove(scannerHook);
    }

    protected Vector<ScannerHook> getScannerHooks() {
        return this.hookList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.scan(this.target);
            this.pool.waitAllThreadComplete(0);
        }
        catch (Exception exception) {
            log.error((Object)"An error occurred while active scanning:", (Throwable)exception);
        }
        finally {
            this.notifyScannerComplete();
        }
    }

    public void scan(Target target) {
        block14: {
            Thread thread;
            block15: {
                block13: {
                    thread = null;
                    this.setScanChildren(target.isRecurse());
                    this.setJustScanInScope(target.isInScopeOnly());
                    if (target.getStartNodes() == null) break block13;
                    HostProcess hostProcess = null;
                    List<StructuralNode> list = target.getStartNodes();
                    if (list.size() == 1 && list.get(0).isRoot()) {
                        Iterator<StructuralNode> iterator = list.get(0).getChildIterator();
                        while (iterator.hasNext()) {
                            StructuralNode structuralNode = iterator.next();
                            String string = this.getHostAndPort(structuralNode);
                            hostProcess = new HostProcess(string, this, this.scannerParam, this.connectionParam, this.scanPolicy);
                            hostProcess.setStartNode(structuralNode);
                            hostProcess.setUser(this.user);
                            hostProcess.setTechSet(this.techSet);
                            this.hostProcesses.add(hostProcess);
                            do {
                                if ((thread = this.pool.getFreeThreadAndRun(hostProcess)) != null) continue;
                                Util.sleep(500);
                            } while (thread == null && !this.isStop());
                            if (thread == null) continue;
                            this.notifyHostNewScan(string, hostProcess);
                        }
                    } else {
                        HashMap<String, HostProcess> hashMap = new HashMap<String, HostProcess>();
                        for (StructuralNode object : list) {
                            String string = this.getHostAndPort(object);
                            hostProcess = (HostProcess)hashMap.get(string);
                            if (hostProcess == null) {
                                hostProcess = new HostProcess(string, this, this.scannerParam, this.connectionParam, this.scanPolicy);
                                hostProcess.setStartNode(object);
                                hostProcess.setUser(this.user);
                                hostProcess.setTechSet(this.techSet);
                                hashMap.put(string, hostProcess);
                                continue;
                            }
                            hostProcess.addStartNode(object);
                        }
                        for (Map.Entry string : hashMap.entrySet()) {
                            this.hostProcesses.add((HostProcess)string.getValue());
                            thread = this.pool.getFreeThreadAndRun((Runnable)string.getValue());
                            this.notifyHostNewScan((String)string.getKey(), (HostProcess)string.getValue());
                        }
                    }
                    break block14;
                }
                if (target.getContext() == null) break block15;
                if (Constant.isLowMemoryOptionSet()) {
                    throw new InvalidParameterException("Not yet supported for the low memory option :(");
                }
                List<SiteNode> list = target.getContext().getTopNodesInContextFromSiteTree();
                for (SiteNode siteNode : list) {
                    HostProcess hostProcess = null;
                    String string = this.getHostAndPort(siteNode);
                    hostProcess = new HostProcess(string, this, this.scannerParam, this.connectionParam, this.scanPolicy);
                    hostProcess.setStartNode(new StructuralSiteNode(siteNode));
                    hostProcess.setUser(this.user);
                    hostProcess.setTechSet(this.techSet);
                    this.hostProcesses.add(hostProcess);
                    do {
                        if ((thread = this.pool.getFreeThreadAndRun(hostProcess)) != null) continue;
                        Util.sleep(500);
                    } while (thread == null && !this.isStop());
                    if (thread == null) continue;
                    this.notifyHostNewScan(string, hostProcess);
                }
                break block14;
            }
            if (!target.isInScopeOnly()) break block14;
            if (Constant.isLowMemoryOptionSet()) {
                throw new InvalidParameterException("Not yet supported for the low memory option :(");
            }
            this.justScanInScope = true;
            List<SiteNode> list = Model.getSingleton().getSession().getTopNodesInScopeFromSiteTree();
            for (SiteNode siteNode : list) {
                HostProcess hostProcess = null;
                String string = this.getHostAndPort(siteNode);
                hostProcess = new HostProcess(string, this, this.scannerParam, this.connectionParam, this.scanPolicy);
                hostProcess.setStartNode(new StructuralSiteNode(siteNode));
                hostProcess.setUser(this.user);
                hostProcess.setTechSet(this.techSet);
                this.hostProcesses.add(hostProcess);
                do {
                    if ((thread = this.pool.getFreeThreadAndRun(hostProcess)) != null) continue;
                    Util.sleep(500);
                } while (thread == null && !this.isStop());
                if (thread == null) continue;
                this.notifyHostNewScan(string, hostProcess);
            }
        }
    }

    public boolean isStop() {
        return this.isStop;
    }

    private String getHostAndPort(SiteNode siteNode) {
        String string = "";
        SiteNode siteNode2 = null;
        if (siteNode == null || siteNode.isRoot()) {
            string = "";
        } else {
            SiteNode siteNode3 = siteNode;
            siteNode2 = siteNode.getParent();
            while (!siteNode2.isRoot()) {
                siteNode3 = siteNode2;
                siteNode2 = siteNode3.getParent();
            }
            string = siteNode3.getNodeName();
        }
        return string;
    }

    private String getHostAndPort(StructuralNode structuralNode) {
        String string;
        int n;
        String string2 = "";
        string2 = structuralNode == null || structuralNode.isRoot() ? "" : ((n = (string = structuralNode.getName()).indexOf("/", string.indexOf("//") + 2)) > 0 ? string.substring(0, n) : string);
        return string2;
    }

    void notifyHostComplete(String string) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = this.listenerList.get(i);
            scannerListener.hostComplete(this.id, string);
        }
    }

    void notifyHostProgress(String string, String string2, int n) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = this.listenerList.get(i);
            scannerListener.hostProgress(this.id, string, string2, n);
        }
    }

    void notifyScannerComplete() {
        Object object;
        int n;
        long l = System.currentTimeMillis() - this.startTimeMillis;
        String string = decimalFormat.format((double)l / 1000.0) + "s";
        log.info((Object)("scanner completed in " + string));
        this.isStop = true;
        for (n = 0; n < this.listenerList.size(); ++n) {
            object = this.listenerList.get(n);
            object.scannerComplete(this.id);
        }
        for (n = 0; n < this.hookList.size(); ++n) {
            try {
                object = this.hookList.get(n);
                object.scannerComplete();
                continue;
            }
            catch (Exception exception) {
                log.info((Object)("An exception occurred while notifying a ScannerHook about scanner completion: " + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    void notifyAlertFound(Alert alert) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = this.listenerList.get(i);
            scannerListener.alertFound(alert);
        }
    }

    void notifyHostNewScan(String string, HostProcess hostProcess) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = this.listenerList.get(i);
            scannerListener.hostNewScan(this.id, string, hostProcess);
        }
    }

    public void pause() {
        this.pause = true;
    }

    public void resume() {
        this.pause = false;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public void notifyNewMessage(HttpMessage httpMessage) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = this.listenerList.get(i);
            scannerListener.notifyNewMessage(httpMessage);
        }
    }

    public void setExcludeList(List<String> list) {
        if (list != null) {
            this.excludeUrls = new ArrayList<Pattern>(list.size());
            for (String string : list) {
                Pattern pattern = Pattern.compile(string, 2);
                this.excludeUrls.add(pattern);
            }
        } else {
            this.excludeUrls = new ArrayList<Pattern>(0);
        }
    }

    public boolean isInScope(String string) {
        if (this.justScanInScope && !Model.getSingleton().getSession().isInScope(string)) {
            return false;
        }
        if (this.target.getContext() != null && !this.target.getContext().isIncluded(string)) {
            return false;
        }
        if (this.excludeUrls != null) {
            for (Pattern pattern : this.excludeUrls) {
                if (!pattern.matcher(string).matches()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("URL excluded: " + string + " Regex: " + pattern.pattern()));
                }
                return false;
            }
        }
        return true;
    }

    public void setStartNode(SiteNode siteNode) {
        this.target = new Target(siteNode);
    }

    public SiteNode getStartNode() {
        if (this.target != null) {
            return this.target.getStartNode();
        }
        return null;
    }

    public void setJustScanInScope(boolean bl) {
        this.justScanInScope = bl;
    }

    public boolean getJustScanInScope() {
        return this.justScanInScope;
    }

    public void setScanChildren(boolean bl) {
        this.scanChildren = bl;
    }

    public boolean scanChildren() {
        return this.scanChildren;
    }

    public List<HostProcess> getHostProcesses() {
        return this.hostProcesses;
    }

    public void setScannerParam(ScannerParam scannerParam) {
        this.scannerParam = scannerParam;
    }

    public void setScanPolicy(ScanPolicy scanPolicy) {
        this.scanPolicy = scanPolicy;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    public void setTechSet(TechSet techSet) {
        this.techSet = techSet;
    }

    public void addScriptCollection(ScriptCollection scriptCollection) {
        this.scriptCollections.add(scriptCollection);
    }

    public Set<ScriptCollection> getScriptCollections() {
        return this.scriptCollections;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }
}

