/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import scala.tools.jline.TerminalSupport;
import scala.tools.jline.console.Key;
import scala.tools.jline.internal.Configuration;
import scala.tools.jline.internal.Log;
import scala.tools.jline.internal.ReplayPrefixOneCharInputStream;
import scala.tools.jline.internal.TerminalLineSettings;

public class UnixTerminal
extends TerminalSupport {
    private final TerminalLineSettings settings = new TerminalLineSettings();
    private final ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(Configuration.getInputEncoding());
    private final InputStreamReader replayReader = new InputStreamReader((InputStream)this.replayStream, this.replayStream.getEncoding());

    public UnixTerminal() throws Exception {
        super(true);
    }

    protected TerminalLineSettings getSettings() {
        return this.settings;
    }

    public void init() throws Exception {
        super.init();
        this.setAnsiSupported(true);
        this.settings.set("-icanon min 1");
        this.setEchoEnabled(false);
    }

    public void restore() throws Exception {
        this.settings.restore();
        super.restore();
        System.out.println();
    }

    public int getWidth() {
        int n = this.settings.getProperty("columns");
        return n < 1 ? 80 : n;
    }

    public int getHeight() {
        int n = this.settings.getProperty("rows");
        return n < 1 ? 24 : n;
    }

    public synchronized void setEchoEnabled(boolean bl) {
        try {
            if (bl) {
                this.settings.set("echo");
            } else {
                this.settings.set("-echo");
            }
            super.setEchoEnabled(bl);
        }
        catch (Exception exception) {
            Log.error("Failed to ", bl ? "enable" : "disable", " echo: ", exception);
        }
    }

    public int readVirtualKey(InputStream inputStream) throws IOException {
        UnixKey unixKey;
        int n = this.readCharacter(inputStream);
        if (Key.valueOf(n) == Key.DELETE && this.settings.getProperty("erase") == Key.DELETE.code) {
            n = Key.BACKSPACE.code;
        }
        if ((unixKey = UnixKey.valueOf(n)) == UnixKey.ARROW_START) {
            while (unixKey == UnixKey.ARROW_START) {
                n = this.readCharacter(inputStream);
                unixKey = UnixKey.valueOf(n);
            }
            if (unixKey == UnixKey.ARROW_PREFIX || unixKey == UnixKey.O_PREFIX) {
                n = this.readCharacter(inputStream);
                unixKey = UnixKey.valueOf(n);
                if (unixKey == UnixKey.ARROW_UP) {
                    return Key.CTRL_P.code;
                }
                if (unixKey == UnixKey.ARROW_DOWN) {
                    return Key.CTRL_N.code;
                }
                if (unixKey == UnixKey.ARROW_LEFT) {
                    return Key.CTRL_B.code;
                }
                if (unixKey == UnixKey.ARROW_RIGHT) {
                    return Key.CTRL_F.code;
                }
                if (unixKey == UnixKey.HOME_CODE) {
                    return Key.CTRL_A.code;
                }
                if (unixKey == UnixKey.END_CODE) {
                    return Key.CTRL_E.code;
                }
                if (unixKey == UnixKey.DEL_THIRD) {
                    this.readCharacter(inputStream);
                    return Key.DELETE.code;
                }
            } else {
                if (n == 98) {
                    return Key.CTRL_O.code;
                }
                if (n == 102) {
                    return Key.CTRL_T.code;
                }
                if (unixKey == UnixKey.DEL) {
                    return Key.CTRL_W.code;
                }
                if (n == 100) {
                    return Key.CTRL_X.code;
                }
            }
        }
        if (n > 128) {
            this.replayStream.setInput(n, inputStream);
            n = this.replayReader.read();
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnixKey {
        ARROW_START(27),
        ARROW_PREFIX(91),
        ARROW_LEFT(68),
        ARROW_RIGHT(67),
        ARROW_UP(65),
        ARROW_DOWN(66),
        O_PREFIX(79),
        HOME_CODE(72),
        END_CODE(70),
        DEL_THIRD(51),
        DEL_SECOND(126),
        DEL(127);

        public final short code;
        private static final Map<Short, UnixKey> codes;

        private UnixKey(int n2) {
            this.code = (short)n2;
        }

        public static UnixKey valueOf(int n) {
            return codes.get((short)n);
        }

        static {
            HashMap<Short, UnixKey> hashMap = new HashMap<Short, UnixKey>();
            for (UnixKey unixKey : UnixKey.values()) {
                hashMap.put(unixKey.code, unixKey);
            }
            codes = hashMap;
        }
    }
}

