/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class PieceDescriptor {
    short descriptor;
    private static BitField fNoParaLast = new BitField(1);
    private static BitField fPaphNil = new BitField(2);
    private static BitField fCopied = new BitField(4);
    int fc;
    short prm;
    boolean unicode;

    public PieceDescriptor(byte[] byArray, int n) {
        this.descriptor = LittleEndian.getShort(byArray, n);
        this.fc = LittleEndian.getInt(byArray, n += 2);
        this.prm = LittleEndian.getShort(byArray, n += 4);
        if ((this.fc & 0x40000000) == 0) {
            this.unicode = true;
        } else {
            this.unicode = false;
            this.fc &= 0xBFFFFFFF;
            this.fc /= 2;
        }
    }

    public int getFilePosition() {
        return this.fc;
    }

    public void setFilePosition(int n) {
        this.fc = n;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    protected byte[] toByteArray() {
        int n = this.fc;
        if (!this.unicode) {
            n *= 2;
            n |= 0x40000000;
        }
        int n2 = 0;
        byte[] byArray = new byte[8];
        LittleEndian.putShort(byArray, n2, this.descriptor);
        LittleEndian.putInt(byArray, n2 += 2, n);
        LittleEndian.putShort(byArray, n2 += 4, this.prm);
        return byArray;
    }

    public static int getSizeInBytes() {
        return 8;
    }

    public boolean equals(Object object) {
        PieceDescriptor pieceDescriptor = (PieceDescriptor)object;
        return this.descriptor == pieceDescriptor.descriptor && this.prm == pieceDescriptor.prm && this.unicode == pieceDescriptor.unicode;
    }
}

