/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.reader.ProjectReader;
import net.sf.mpxj.reader.ProjectReaderUtility;

public class TaskDateDump {
    private DateFormat m_df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.out.println("Usage: TaskDateDump <input file name>");
            } else {
                TaskDateDump taskDateDump = new TaskDateDump();
                taskDateDump.process(stringArray[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void process(String string) throws Exception {
        ProjectReader projectReader = ProjectReaderUtility.getProjectReader(string);
        ProjectFile projectFile = projectReader.read(string);
        for (Task task : projectFile.getAllTasks()) {
            if (task.getSummary()) continue;
            System.out.print(task.getWBS());
            System.out.print("\t");
            System.out.print(task.getName());
            System.out.print("\t");
            System.out.print(this.format(task.getStart()));
            System.out.print("\t");
            System.out.print(this.format(task.getActualStart()));
            System.out.print("\t");
            System.out.print(this.format(task.getFinish()));
            System.out.print("\t");
            System.out.print(this.format(task.getActualFinish()));
            System.out.println();
        }
    }

    private String format(Date date) {
        return date == null ? "" : this.m_df.format(date);
    }
}

