/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.BookingType;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectEntityWithID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ResourceFieldLists;
import net.sf.mpxj.listener.FieldListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resource
extends ProjectEntity
implements Comparable<Resource>,
ProjectEntityWithID,
FieldContainer {
    private Object[] m_array = new Object[ResourceField.MAX_VALUE];
    private ProjectCalendar m_calendar;
    private List<ResourceAssignment> m_assignments = new LinkedList<ResourceAssignment>();
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private boolean m_generic;
    private boolean m_inactive;
    private String m_activeDirectoryGUID;
    private Duration m_actualOvertimeWorkProtected;
    private Duration m_actualWorkProtected;
    private BookingType m_bookingType;
    private boolean m_enterprise;
    private CostRateTable[] m_costRateTables = new CostRateTable[5];
    private AvailabilityTable m_availability = new AvailabilityTable();
    private List<FieldListener> m_listeners;

    Resource(ProjectFile projectFile) {
        super(projectFile);
        this.setType(ResourceType.WORK);
        ProjectConfig projectConfig = projectFile.getProjectConfig();
        if (projectConfig.getAutoResourceUniqueID()) {
            this.setUniqueID(projectConfig.getNextResourceUniqueID());
        }
        if (projectConfig.getAutoResourceID()) {
            this.setID(projectConfig.getNextResourceID());
        }
    }

    public void setName(String string) {
        this.set((FieldType)ResourceField.NAME, string);
    }

    public String getName() {
        return (String)this.getCachedValue(ResourceField.NAME);
    }

    public void setType(ResourceType resourceType) {
        this.set((FieldType)ResourceField.TYPE, resourceType);
    }

    public ResourceType getType() {
        return (ResourceType)this.getCachedValue(ResourceField.TYPE);
    }

    public void setIsNull(boolean bl) {
        this.m_null = bl;
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setInitials(String string) {
        this.set((FieldType)ResourceField.INITIALS, string);
    }

    public String getInitials() {
        return (String)this.getCachedValue(ResourceField.INITIALS);
    }

    public void setPhonetics(String string) {
        this.set((FieldType)ResourceField.PHONETICS, string);
    }

    public String getPhonetics() {
        return (String)this.getCachedValue(ResourceField.PHONETICS);
    }

    public void setNtAccount(String string) {
        this.set((FieldType)ResourceField.WINDOWS_USER_ACCOUNT, string);
    }

    public String getNtAccount() {
        return (String)this.getCachedValue(ResourceField.WINDOWS_USER_ACCOUNT);
    }

    public void setMaterialLabel(String string) {
        this.set((FieldType)ResourceField.MATERIAL_LABEL, string);
    }

    public String getMaterialLabel() {
        return (String)this.getCachedValue(ResourceField.MATERIAL_LABEL);
    }

    public void setCode(String string) {
        this.set((FieldType)ResourceField.CODE, string);
    }

    public String getCode() {
        return (String)this.getCachedValue(ResourceField.CODE);
    }

    public void setGroup(String string) {
        this.set((FieldType)ResourceField.GROUP, string);
    }

    public String getGroup() {
        return (String)this.getCachedValue(ResourceField.GROUP);
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.set((FieldType)ResourceField.WORKGROUP, workGroup);
    }

    public WorkGroup getWorkGroup() {
        return (WorkGroup)this.getCachedValue(ResourceField.WORKGROUP);
    }

    public void setEmailAddress(String string) {
        this.set((FieldType)ResourceField.EMAIL_ADDRESS, string);
    }

    public String getEmailAddress() {
        return (String)this.getCachedValue(ResourceField.EMAIL_ADDRESS);
    }

    public void setHyperlink(String string) {
        this.set((FieldType)ResourceField.HYPERLINK, string);
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK);
    }

    public void setHyperlinkAddress(String string) {
        this.set((FieldType)ResourceField.HYPERLINK_ADDRESS, string);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK_ADDRESS);
    }

    public void setHyperlinkSubAddress(String string) {
        this.set((FieldType)ResourceField.HYPERLINK_SUBADDRESS, string);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK_SUBADDRESS);
    }

    public void setMaxUnits(Number number) {
        this.set((FieldType)ResourceField.MAX_UNITS, number);
    }

    public Number getMaxUnits() {
        return (Number)this.getCachedValue(ResourceField.MAX_UNITS);
    }

    public void setPeakUnits(Number number) {
        this.set((FieldType)ResourceField.PEAK, number);
    }

    public Number getPeakUnits() {
        return (Number)this.getCachedValue(ResourceField.PEAK);
    }

    public void setOverAllocated(boolean bl) {
        this.set((FieldType)ResourceField.OVERALLOCATED, bl);
    }

    public boolean getOverAllocated() {
        Boolean bl = (Boolean)this.getCachedValue(ResourceField.OVERALLOCATED);
        if (bl == null) {
            Number number = this.getPeakUnits();
            Number number2 = this.getMaxUnits();
            bl = NumberHelper.getDouble(number) > NumberHelper.getDouble(number2);
            this.set((FieldType)ResourceField.OVERALLOCATED, bl);
        }
        return bl;
    }

    public Date getAvailableFrom() {
        return (Date)this.getCachedValue(ResourceField.AVAILABLE_FROM);
    }

    public void setAvailableFrom(Date date) {
        this.set((FieldType)ResourceField.AVAILABLE_FROM, date);
    }

    public Date getAvailableTo() {
        return (Date)this.getCachedValue(ResourceField.AVAILABLE_TO);
    }

    public void setAvailableTo(Date date) {
        this.set((FieldType)ResourceField.AVAILABLE_TO, date);
    }

    public Date getStart() {
        Date date = null;
        for (ResourceAssignment resourceAssignment : this.m_assignments) {
            if (date != null && DateHelper.compare(date, resourceAssignment.getStart()) <= 0) continue;
            date = resourceAssignment.getStart();
        }
        return date;
    }

    public Date getFinish() {
        Date date = null;
        for (ResourceAssignment resourceAssignment : this.m_assignments) {
            if (date != null && DateHelper.compare(date, resourceAssignment.getFinish()) >= 0) continue;
            date = resourceAssignment.getFinish();
        }
        return date;
    }

    public void setCanLevel(boolean bl) {
        this.set((FieldType)ResourceField.CAN_LEVEL, bl);
    }

    public boolean getCanLevel() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ResourceField.CAN_LEVEL));
    }

    public void setAccrueAt(AccrueType accrueType) {
        this.set((FieldType)ResourceField.ACCRUE_AT, accrueType);
    }

    public AccrueType getAccrueAt() {
        return (AccrueType)this.getCachedValue(ResourceField.ACCRUE_AT);
    }

    public void setWork(Duration duration) {
        this.set((FieldType)ResourceField.WORK, duration);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(ResourceField.WORK);
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(ResourceField.REGULAR_WORK);
    }

    public void setRegularWork(Duration duration) {
        this.set((FieldType)ResourceField.REGULAR_WORK, duration);
    }

    public void setActualWork(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_WORK, duration);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(ResourceField.ACTUAL_WORK);
    }

    public void setOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.OVERTIME_WORK, duration);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.OVERTIME_WORK);
    }

    public void setRemainingWork(Duration duration) {
        this.set((FieldType)ResourceField.REMAINING_WORK, duration);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(ResourceField.REMAINING_WORK);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_WORK, duration);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_WORK, duration);
    }

    public void setPercentWorkComplete(Number number) {
        this.set((FieldType)ResourceField.PERCENT_WORK_COMPLETE, number);
    }

    public Number getPercentWorkComplete() {
        return (Number)this.getCachedValue(ResourceField.PERCENT_WORK_COMPLETE);
    }

    public void setStandardRate(Rate rate) {
        this.set((FieldType)ResourceField.STANDARD_RATE, rate);
    }

    public Rate getStandardRate() {
        return (Rate)this.getCachedValue(ResourceField.STANDARD_RATE);
    }

    public void setStandardRateUnits(TimeUnit timeUnit) {
        this.set((FieldType)ResourceField.STANDARD_RATE_UNITS, timeUnit);
    }

    public TimeUnit getStandardRateUnits() {
        return (TimeUnit)this.getCachedValue(ResourceField.STANDARD_RATE_UNITS);
    }

    public void setCost(Number number) {
        this.set((FieldType)ResourceField.COST, number);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(ResourceField.COST);
    }

    public void setOvertimeRate(Rate rate) {
        this.set((FieldType)ResourceField.OVERTIME_RATE, rate);
    }

    public Rate getOvertimeRate() {
        return (Rate)this.getCachedValue(ResourceField.OVERTIME_RATE);
    }

    public void setOvertimeRateUnits(TimeUnit timeUnit) {
        this.set((FieldType)ResourceField.OVERTIME_RATE_UNITS, timeUnit);
    }

    public TimeUnit getOvertimeRateUnits() {
        return (TimeUnit)this.getCachedValue(ResourceField.OVERTIME_RATE_UNITS);
    }

    public Number getOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)ResourceField.OVERTIME_COST, number);
    }

    public void setCostPerUse(Number number) {
        this.set((FieldType)ResourceField.COST_PER_USE, number);
    }

    public Number getCostPerUse() {
        return (Number)this.getCachedValue(ResourceField.COST_PER_USE);
    }

    public void setActualCost(Number number) {
        this.set((FieldType)ResourceField.ACTUAL_COST, number);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(ResourceField.ACTUAL_COST);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number number) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_COST, number);
    }

    public void setRemainingCost(Number number) {
        this.set((FieldType)ResourceField.REMAINING_COST, number);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(ResourceField.REMAINING_COST);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number number) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_COST, number);
    }

    public void setWorkVariance(Duration duration) {
        this.set((FieldType)ResourceField.WORK_VARIANCE, duration);
    }

    public Duration getWorkVariance() {
        Duration duration = (Duration)this.getCachedValue(ResourceField.WORK_VARIANCE);
        if (duration == null) {
            Duration duration2 = this.getWork();
            Duration duration3 = this.getBaselineWork();
            if (duration2 != null && duration3 != null) {
                duration = Duration.getInstance(duration2.getDuration() - duration3.convertUnits(duration2.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), duration2.getUnits());
                this.set((FieldType)ResourceField.WORK_VARIANCE, duration);
            }
        }
        return duration;
    }

    public void setCostVariance(Number number) {
        this.set((FieldType)ResourceField.COST_VARIANCE, number);
    }

    public Number getCostVariance() {
        Number number = (Number)this.getCachedValue(ResourceField.COST_VARIANCE);
        if (number == null) {
            Number number2 = this.getCost();
            Number number3 = this.getBaselineCost();
            if (number2 != null && number3 != null) {
                number = NumberHelper.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)ResourceField.COST_VARIANCE, number);
            }
        }
        return number;
    }

    public void setSV(Number number) {
        this.set((FieldType)ResourceField.SV, number);
    }

    public Number getSV() {
        Number number = (Number)this.getCachedValue(ResourceField.SV);
        if (number == null) {
            Number number2 = this.getBCWP();
            Number number3 = this.getBCWS();
            if (number2 != null && number3 != null) {
                number = NumberHelper.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)ResourceField.SV, number);
            }
        }
        return number;
    }

    public void setCV(Number number) {
        this.set((FieldType)ResourceField.CV, number);
    }

    public Number getCV() {
        Number number = (Number)this.getCachedValue(ResourceField.CV);
        if (number == null) {
            number = NumberHelper.getDouble(this.getBCWP()) - NumberHelper.getDouble(this.getACWP());
            this.set((FieldType)ResourceField.CV, number);
        }
        return number;
    }

    public void setACWP(Number number) {
        this.set((FieldType)ResourceField.ACWP, number);
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(ResourceField.ACWP);
    }

    public void setNotes(String string) {
        this.set((FieldType)ResourceField.NOTES, string);
    }

    public String getNotes() {
        String string = (String)this.getCachedValue(ResourceField.NOTES);
        return string == null ? "" : string;
    }

    public void setBCWS(Number number) {
        this.set((FieldType)ResourceField.BCWS, number);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(ResourceField.BCWS);
    }

    public void setBCWP(Number number) {
        this.set((FieldType)ResourceField.BCWP, number);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(ResourceField.BCWP);
    }

    public void setIsGeneric(boolean bl) {
        this.m_generic = bl;
    }

    public boolean getGeneric() {
        return this.m_generic;
    }

    public void setIsInactive(boolean bl) {
        this.m_inactive = bl;
    }

    public boolean getInactive() {
        return this.m_inactive;
    }

    public void setActveDirectoryGUID(String string) {
        this.m_activeDirectoryGUID = string;
    }

    public String getActiveDirectoryGUID() {
        return this.m_activeDirectoryGUID;
    }

    public void setActualOvertimeWorkProtected(Duration duration) {
        this.m_actualOvertimeWorkProtected = duration;
    }

    public Duration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualWorkProtected(Duration duration) {
        this.m_actualWorkProtected = duration;
    }

    public Duration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setBookingType(BookingType bookingType) {
        this.m_bookingType = bookingType;
    }

    public BookingType getBookingType() {
        return this.m_bookingType;
    }

    public void setCreationDate(Date date) {
        this.set((FieldType)ResourceField.CREATED, date);
    }

    public Date getCreationDate() {
        return (Date)this.getCachedValue(ResourceField.CREATED);
    }

    public void setIsEnterprise(boolean bl) {
        this.m_enterprise = bl;
    }

    public boolean getEnterprise() {
        return this.m_enterprise;
    }

    public ProjectCalendar getResourceCalendar() {
        return this.m_calendar;
    }

    public void setResourceCalendar(ProjectCalendar projectCalendar) {
        this.m_calendar = projectCalendar;
        if (projectCalendar != null) {
            projectCalendar.setResource(this);
        }
    }

    public ProjectCalendar addResourceCalendar() throws MPXJException {
        if (this.m_calendar != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        this.m_calendar = new ProjectCalendar(this.getParentFile());
        this.m_calendar.setResource(this);
        return this.m_calendar;
    }

    public void setBaseCalendar(String string) {
        this.set((FieldType)ResourceField.BASE_CALENDAR, string == null || string.length() == 0 ? "Standard" : string);
    }

    public void setBaselineCost(Number number) {
        this.set((FieldType)ResourceField.BASELINE_COST, number);
    }

    public void setBaselineWork(Duration duration) {
        this.set((FieldType)ResourceField.BASELINE_WORK, duration);
    }

    @Override
    public void setID(Integer n) {
        ProjectFile projectFile = this.getParentFile();
        Integer n2 = this.getID();
        if (n2 != null) {
            projectFile.getAllResources().unmapID(n2);
        }
        projectFile.getAllResources().mapID(n, this);
        this.set((FieldType)ResourceField.ID, n);
    }

    public void setLinkedFields(boolean bl) {
        this.set((FieldType)ResourceField.LINKED_FIELDS, bl);
    }

    public void setObjects(Integer n) {
        this.set((FieldType)ResourceField.OBJECTS, n);
    }

    public void setText(int n, String string) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_TEXT, n), string);
    }

    public String getText(int n) {
        return (String)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_TEXT, n));
    }

    @Override
    public void setUniqueID(Integer n) {
        this.set((FieldType)ResourceField.UNIQUE_ID, n);
    }

    public String getBaseCalendar() {
        return (String)this.getCachedValue(ResourceField.BASE_CALENDAR);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(ResourceField.BASELINE_COST);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(ResourceField.BASELINE_WORK);
    }

    @Override
    public Integer getID() {
        return (Integer)this.getCachedValue(ResourceField.ID);
    }

    public boolean getLinkedFields() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ResourceField.LINKED_FIELDS));
    }

    public Integer getObjects() {
        return (Integer)this.getCachedValue(ResourceField.OBJECTS);
    }

    @Override
    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(ResourceField.UNIQUE_ID);
    }

    public void setStart(int n, Date date) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_START, n), date);
    }

    public Date getStart(int n) {
        return (Date)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_START, n));
    }

    public void setFinish(int n, Date date) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_FINISH, n), date);
    }

    public Date getFinish(int n) {
        return (Date)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_FINISH, n));
    }

    public void setNumber(int n, Number number) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_NUMBER, n), number);
    }

    public Number getNumber(int n) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_NUMBER, n));
    }

    public void setDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_DURATION, n), duration);
    }

    public Duration getDuration(int n) {
        return (Duration)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_DURATION, n));
    }

    public void setDate(int n, Date date) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_DATE, n), date);
    }

    public Date getDate(int n) {
        return (Date)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_DATE, n));
    }

    public void setCost(int n, Number number) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_COST, n), number);
    }

    public Number getCost(int n) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_COST, n));
    }

    public void setFlag(int n, boolean bl) {
        this.set((FieldType)this.selectField(ResourceFieldLists.CUSTOM_FLAG, n), bl);
    }

    public boolean getFlag(int n) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(ResourceFieldLists.CUSTOM_FLAG, n)));
    }

    public void setOutlineCode1(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE1, string);
    }

    public String getOutlineCode1() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE1);
    }

    public void setOutlineCode2(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE2, string);
    }

    public String getOutlineCode2() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE2);
    }

    public void setOutlineCode3(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE3, string);
    }

    public String getOutlineCode3() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE3);
    }

    public void setOutlineCode4(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE4, string);
    }

    public String getOutlineCode4() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE4);
    }

    public void setOutlineCode5(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE5, string);
    }

    public String getOutlineCode5() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE5);
    }

    public void setOutlineCode6(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE6, string);
    }

    public String getOutlineCode6() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE6);
    }

    public void setOutlineCode7(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE7, string);
    }

    public String getOutlineCode7() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE7);
    }

    public void setOutlineCode8(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE8, string);
    }

    public String getOutlineCode8() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE8);
    }

    public void setOutlineCode9(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE9, string);
    }

    public String getOutlineCode9() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE9);
    }

    public void setOutlineCode10(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE10, string);
    }

    public String getOutlineCode10() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE10);
    }

    public void remove() {
        this.getParentFile().removeResource(this);
    }

    public Object getFieldByAlias(String string) {
        return this.getCachedValue(this.getParentFile().getCustomFields().getFieldByAlias(FieldTypeClass.RESOURCE, string));
    }

    public void setFieldByAlias(String string, Object object) {
        this.set(this.getParentFile().getCustomFields().getFieldByAlias(FieldTypeClass.RESOURCE, string), object);
    }

    public void addResourceAssignment(ResourceAssignment resourceAssignment) {
        this.m_assignments.add(resourceAssignment);
    }

    void removeResourceAssignment(ResourceAssignment resourceAssignment) {
        this.m_assignments.remove(resourceAssignment);
    }

    public List<ResourceAssignment> getTaskAssignments() {
        return this.m_assignments;
    }

    public Integer getSubprojectResourceUniqueID() {
        return (Integer)this.getCachedValue(ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID);
    }

    public void setSubprojectResourceUniqueID(Integer n) {
        this.set((FieldType)ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID, n);
    }

    public Number getEnterpriseCost(int n) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_COST, n));
    }

    public void setEnterpriseCost(int n, Number number) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_COST, n), number);
    }

    public Date getEnterpriseDate(int n) {
        return (Date)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_DATE, n));
    }

    public void setEnterpriseDate(int n, Date date) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_DATE, n), date);
    }

    public Duration getEnterpriseDuration(int n) {
        return (Duration)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_DURATION, n));
    }

    public void setEnterpriseDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_DURATION, n), duration);
    }

    public boolean getEnterpriseFlag(int n) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_FLAG, n)));
    }

    public void setEnterpriseFlag(int n, boolean bl) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_FLAG, n), bl);
    }

    public Number getEnterpriseNumber(int n) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_NUMBER, n));
    }

    public void setEnterpriseNumber(int n, Number number) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_NUMBER, n), number);
    }

    public String getEnterpriseText(int n) {
        return (String)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_TEXT, n));
    }

    public void setEnterpriseText(int n, String string) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_TEXT, n), string);
    }

    public String getEnterpriseCustomField(int n) {
        return (String)this.getCachedValue(this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_FIELD, n));
    }

    public void setEnterpriseCustomField(int n, String string) {
        this.set((FieldType)this.selectField(ResourceFieldLists.ENTERPRISE_CUSTOM_FIELD, n), string);
    }

    public void setBaselineCost(int n, Number number) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_COSTS, n), number);
    }

    public void setBaselineWork(int n, Duration duration) {
        this.set((FieldType)this.selectField(ResourceFieldLists.BASELINE_WORKS, n), duration);
    }

    public Number getBaselineCost(int n) {
        return (Number)this.getCachedValue(this.selectField(ResourceFieldLists.BASELINE_COSTS, n));
    }

    public Duration getBaselineWork(int n) {
        return (Duration)this.getCachedValue(this.selectField(ResourceFieldLists.BASELINE_WORKS, n));
    }

    public boolean getBudget() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(ResourceField.BUDGET));
    }

    public void setBudget(boolean bl) {
        this.set((FieldType)ResourceField.BUDGET, bl);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(ResourceField.GUID);
    }

    public void setGUID(UUID uUID) {
        this.set((FieldType)ResourceField.GUID, uUID);
    }

    public void setCostRateTable(int n, CostRateTable costRateTable) {
        this.m_costRateTables[n] = costRateTable;
    }

    public CostRateTable getCostRateTable(int n) {
        return this.m_costRateTables[n];
    }

    public AvailabilityTable getAvailability() {
        return this.m_availability;
    }

    private ResourceField selectField(ResourceField[] resourceFieldArray, int n) {
        if (n < 1 || n > resourceFieldArray.length) {
            throw new IllegalArgumentException(n + " is not a valid field index");
        }
        return resourceFieldArray[n - 1];
    }

    @Override
    public Object getCachedValue(FieldType fieldType) {
        return fieldType == null ? null : this.m_array[fieldType.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType fieldType) {
        Object object = null;
        if (fieldType != null) {
            ResourceField resourceField = (ResourceField)fieldType;
            switch (resourceField) {
                case COST_VARIANCE: {
                    object = this.getCostVariance();
                    break;
                }
                case WORK_VARIANCE: {
                    object = this.getWorkVariance();
                    break;
                }
                case CV: {
                    object = this.getCV();
                    break;
                }
                case SV: {
                    object = this.getSV();
                    break;
                }
                case OVERALLOCATED: {
                    object = this.getOverAllocated();
                    break;
                }
                default: {
                    object = this.m_array[fieldType.getValue()];
                }
            }
        }
        return object;
    }

    @Override
    public void set(FieldType fieldType, Object object) {
        if (fieldType != null) {
            int n = fieldType.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((ResourceField)fieldType, this.m_array[n], object);
            }
            this.m_array[n] = object;
        }
    }

    private void fireFieldChangeEvent(ResourceField resourceField, Object object, Object object2) {
        switch (resourceField) {
            case UNIQUE_ID: {
                ProjectFile projectFile = this.getParentFile();
                if (object != null) {
                    projectFile.getAllResources().unmapUniqueID((Integer)object);
                }
                projectFile.getAllResources().mapUniqueID((Integer)object2, this);
                if (this.m_assignments.isEmpty()) break;
                for (ResourceAssignment resourceAssignment : this.m_assignments) {
                    resourceAssignment.setResourceUniqueID((Integer)object2);
                }
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.m_array[ResourceField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[ResourceField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[ResourceField.CV.getValue()] = null;
                this.m_array[ResourceField.SV.getValue()] = null;
                break;
            }
            case BCWS: {
                this.m_array[ResourceField.SV.getValue()] = null;
                break;
            }
            case PEAK: 
            case MAX_UNITS: {
                this.m_array[ResourceField.OVERALLOCATED.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener fieldListener : this.m_listeners) {
                fieldListener.fieldChange(this, resourceField, object, object2);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener fieldListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(fieldListener);
    }

    @Override
    public void removeFieldListener(FieldListener fieldListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(fieldListener);
        }
    }

    private void set(FieldType fieldType, boolean bl) {
        this.set(fieldType, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }

    @Override
    public int compareTo(Resource resource) {
        int n;
        int n2 = NumberHelper.getInt(this.getID());
        return n2 < (n = NumberHelper.getInt(resource.getID())) ? -1 : (n2 == n ? 0 : 1);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Resource) {
            bl = this.compareTo((Resource)object) == 0;
        }
        return bl;
    }

    public int hashCode() {
        return NumberHelper.getInt(this.getID());
    }

    public String toString() {
        return "[Resource id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + "]";
    }
}

