/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import org.jruby.Ruby;
import org.jruby.RubyLocalJumpError;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.Node;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class CallManyArgsBlockNode
extends CallNode {
    public CallManyArgsBlockNode(ISourcePosition position, Node receiverNode, String name2, Node args2, IterNode iter2) {
        super(position, receiverNode, name2, args2, iter2);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject receiver2 = this.getReceiverNode().interpret(runtime, context, self2, aBlock);
        IRubyObject[] args2 = ((ArrayNode)this.getArgsNode()).interpretPrimitive(runtime, context, self2, aBlock);
        Block block = Helpers.getBlock(context, self2, this.iterNode);
        try {
            IRubyObject iRubyObject = this.callAdapter.callIter(context, self2, receiver2, args2, block);
            return iRubyObject;
        }
        catch (JumpException.RetryJump rj) {
            throw runtime.newLocalJumpError(RubyLocalJumpError.Reason.RETRY, self2, "retry is not supported outside rescue");
        }
        finally {
            block.escape();
        }
    }
}

