/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.percentages.line;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.line.LineHeight;
import org.jfree.layouting.input.style.keys.line.LineStyleKeys;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class LineHeightResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_SIZE_ADJUST};
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        double d;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (LineHeight.NONE.equals(cSSValue)) {
            this.handleNone(layoutElement);
            return;
        }
        if (LineHeight.NORMAL.equals(cSSValue)) {
            this.handleNormal(layoutElement);
            return;
        }
        if (!(cSSValue instanceof CSSNumericValue)) {
            this.handleNormal(layoutElement);
            return;
        }
        CSSNumericValue cSSNumericValue = (CSSNumericValue)cSSValue;
        if (CSSValueResolverUtility.isLengthValue(cSSNumericValue)) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, cSSNumericValue);
            return;
        }
        if (cSSNumericValue.getType().equals(CSSNumericType.PERCENTAGE)) {
            d = cSSNumericValue.getValue() / 100.0;
        } else if (cSSNumericValue.getType().equals(CSSNumericType.NUMBER)) {
            d = cSSNumericValue.getValue();
        } else {
            this.handleNormal(layoutElement);
            return;
        }
        double d2 = layoutContext.getFontSpecification().getFontSize();
        layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, d2 * d));
    }

    private void handleNormal(LayoutElement layoutElement) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        double d = layoutContext.getFontSpecification().getFontSize();
        if (d < 10.0) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, d * 1.2));
        } else if (d < 24.0) {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, d * 1.1));
        } else {
            layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, d * 1.05));
        }
    }

    private void handleNone(LayoutElement layoutElement) {
        LayoutElement layoutElement2 = layoutElement.getParent();
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        double d = layoutElement2 == null ? layoutContext.getFontSpecification().getFontSize() : layoutElement2.getLayoutContext().getFontSpecification().getFontSize();
        layoutContext.setValue(LineStyleKeys.LINE_HEIGHT, CSSNumericValue.createValue(CSSNumericType.PT, d));
    }
}

