/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.box;

import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.stylehandler.OneOfConstantsReadHandler;
import org.jfree.layouting.input.style.values.CSSAutoValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class FitPositionReadHandler
extends OneOfConstantsReadHandler {
    public static final CSSNumericValue CENTER = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 50.0);
    public static final CSSNumericValue TOP = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    public static final CSSNumericValue LEFT = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 0.0);
    public static final CSSNumericValue BOTTOM = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);
    public static final CSSNumericValue RIGHT = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, 100.0);

    public FitPositionReadHandler() {
        super(false);
    }

    public CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        Object object;
        if (lexicalUnit.getLexicalUnitType() == 35 && "auto".equalsIgnoreCase((String)(object = lexicalUnit.getStringValue()))) {
            return CSSAutoValue.getInstance();
        }
        object = this.parseFirstPosition(lexicalUnit);
        if (object == null) {
            return null;
        }
        CSSValue cSSValue = this.parseSecondPosition(lexicalUnit = lexicalUnit.getNextLexicalUnit(), (CSSValue)object);
        if (cSSValue == null) {
            return null;
        }
        return this.createResultList((CSSValue)object, cSSValue);
    }

    protected CSSValue parseFirstPosition(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 35) {
            if ("left".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return LEFT;
            }
            if ("center".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return CENTER;
            }
            if ("right".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return RIGHT;
            }
            if ("top".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return TOP;
            }
            if ("bottom".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return BOTTOM;
            }
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
        }
        if (CSSValueFactory.isLengthValue(lexicalUnit)) {
            return CSSValueFactory.createLengthValue(lexicalUnit);
        }
        return null;
    }

    protected CSSValuePair createResultList(CSSValue cSSValue, CSSValue cSSValue2) {
        if (cSSValue == TOP || cSSValue == BOTTOM) {
            return new CSSValuePair(cSSValue2, cSSValue);
        }
        if (cSSValue2 == LEFT || cSSValue2 == RIGHT) {
            return new CSSValuePair(cSSValue2, cSSValue);
        }
        return new CSSValuePair(cSSValue, cSSValue2);
    }

    protected CSSValue parseSecondPosition(LexicalUnit lexicalUnit, CSSValue cSSValue) {
        if (lexicalUnit == null) {
            return CENTER;
        }
        if (lexicalUnit.getLexicalUnitType() == 35) {
            if ("left".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return LEFT;
            }
            if ("center".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return CENTER;
            }
            if ("right".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return RIGHT;
            }
            if ("top".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return TOP;
            }
            if ("bottom".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return BOTTOM;
            }
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
        }
        if (CSSValueFactory.isLengthValue(lexicalUnit)) {
            return CSSValueFactory.createLengthValue(lexicalUnit);
        }
        return CENTER;
    }
}

