/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.EditPageParser;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiEditSettingDialog;
import com.sun.star.wiki.WikiPropDialog;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import javax.swing.text.html.HTMLEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiArticle {
    private final XComponentContext m_xContext;
    private String m_sEditTime = "";
    private String m_sEditToken = "";
    private String m_sHTMLCode;
    private boolean m_bNoArticle = true;
    private String m_sWikiUser;
    private String m_sWikiPass;
    private final String m_sTitle;
    private final URI m_aMainURI;
    private boolean m_isLoggedIn = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiArticle(XComponentContext xComponentContext, String string, Map<String, String> map, boolean bl, WikiPropDialog wikiPropDialog) throws URISyntaxException, IOException, WikiCancelException {
        this.m_xContext = xComponentContext;
        String string2 = map.get("Url");
        this.m_sWikiUser = map.get("Username");
        this.m_sWikiPass = map.get("Password");
        this.m_sTitle = string;
        this.m_aMainURI = new URI(string2);
        if (bl) {
            WikiEditSettingDialog wikiEditSettingDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application", map, false);
            try {
                while (!this.Login()) {
                    if (wikiPropDialog != null) {
                        wikiPropDialog.SetThrobberActive(false);
                    }
                    if (!MainThreadDialogExecutor.Show(xComponentContext, wikiEditSettingDialog)) {
                        throw new WikiCancelException();
                    }
                    this.m_sWikiUser = map.get("Username");
                    this.m_sWikiPass = map.get("Password");
                    if (wikiPropDialog == null) continue;
                    wikiPropDialog.SetThrobberActive(true);
                    Thread.yield();
                }
            }
            finally {
                wikiEditSettingDialog.DisposeDialog();
            }
        }
        this.InitArticleHTML();
    }

    public String GetMainURL() {
        return this.m_aMainURI.toString();
    }

    public String GetTitle() {
        return this.m_sTitle;
    }

    private String getArticleWiki() throws URISyntaxException, IOException, WikiCancelException {
        String string = null;
        if (this.m_isLoggedIn) {
            URI uRI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle + "&action=edit");
            HttpURLConnection httpURLConnection = Helper.PrepareMethod("GET", uRI, this.m_xContext);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            String string2 = null;
            if (n == 200) {
                string2 = Helper.ReadResponseBody(httpURLConnection);
            }
            if (string2 != null) {
                StringReader stringReader = new StringReader(string2);
                HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
                EditPageParser editPageParser = new EditPageParser();
                parser.parse(stringReader, editPageParser, true);
                this.m_sEditTime = editPageParser.m_sEditTime;
                this.m_sEditToken = editPageParser.m_sEditToken;
                int n2 = editPageParser.m_nWikiArticleStart;
                int n3 = editPageParser.m_nWikiArticleEnd;
                if (n2 >= 0 && n3 > 0) {
                    String string3 = string2.substring(n2, n3);
                    n2 = string3.indexOf(62) + 1;
                    string = string3.substring(n2, string3.length());
                }
            }
        }
        return string;
    }

    private void InitArticleHTML() throws URISyntaxException, IOException, WikiCancelException {
        if (this.m_isLoggedIn) {
            URI uRI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle);
            HttpURLConnection httpURLConnection = Helper.PrepareMethod("GET", uRI, this.m_xContext);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            String string = null;
            if (n == 200) {
                string = Helper.ReadResponseBody(httpURLConnection);
            }
            if (string != null) {
                StringReader stringReader = new StringReader(string);
                HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
                EditPageParser editPageParser = new EditPageParser();
                parser.parse(stringReader, editPageParser, true);
                int n2 = editPageParser.m_nHTMLArticleStart;
                int n3 = editPageParser.m_nHTMLArticleEnd;
                int n4 = editPageParser.m_nNoArticleInd;
                if (n2 >= 0 && n3 > 0) {
                    this.m_sHTMLCode = string.substring(n2, n3);
                    this.m_bNoArticle = n4 >= 0 && n4 >= n2 && n4 <= n3;
                }
            }
        }
    }

    protected boolean setArticle(String string, String string2, boolean bl) throws URISyntaxException, IOException, WikiCancelException {
        boolean bl2 = false;
        if (this.m_isLoggedIn && string != null && string2 != null) {
            this.getArticleWiki();
            URI uRI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle + "&action=submit");
            HttpURLConnection httpURLConnection = Helper.PrepareMethod("POST", uRI, this.m_xContext);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.connect();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
            outputStreamWriter.write("wpTextbox1=");
            outputStreamWriter.write(URLEncoder.encode(string, "UTF-8"));
            outputStreamWriter.write("&wpSummary=");
            outputStreamWriter.write(URLEncoder.encode(string2, "UTF-8"));
            outputStreamWriter.write("&wpSection=");
            outputStreamWriter.write("&wpEdittime=");
            outputStreamWriter.write(URLEncoder.encode(this.m_sEditTime, "UTF-8"));
            outputStreamWriter.write("&wpSave=Save%20page");
            outputStreamWriter.write("&wpEditToken=");
            outputStreamWriter.write(URLEncoder.encode(this.m_sEditToken, "UTF-8"));
            if (bl) {
                outputStreamWriter.write("&wpMinoredit=1");
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
            int n = httpURLConnection.getResponseCode();
            if (n < 400) {
                bl2 = true;
            }
            String string3 = Helper.ReadResponseBody(httpURLConnection);
            System.out.print("nSubmitCode = " + n + "\n===\n" + string3);
        }
        return bl2;
    }

    private boolean Login() throws URISyntaxException, IOException, WikiCancelException {
        this.m_isLoggedIn = Helper.Login(this.m_aMainURI, this.m_sWikiUser, this.m_sWikiPass, this.m_xContext);
        return this.m_isLoggedIn;
    }

    protected boolean NotExist() {
        boolean bl = true;
        if (this.m_sHTMLCode != null) {
            bl = this.m_bNoArticle;
        }
        return bl;
    }
}

