/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import org.jcodings.Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.parser.ParserContext;
import org.jruby.truffle.language.parser.jruby.TranslatorDriver;

public class CodeLoader {
    private final RubyContext context;

    public CodeLoader(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyRootNode parse(Source source, Encoding defaultEncoding, ParserContext parserContext, FrameDescriptor frameDescriptor, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode) {
        TranslatorDriver translator = new TranslatorDriver(this.context);
        return translator.parse(this.context, source, defaultEncoding, parserContext, null, frameDescriptor, parentFrame, ownScopeForAssignments, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyRootNode parse(Source source, Encoding defaultEncoding, ParserContext parserContext, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode) {
        return this.parse(source, defaultEncoding, parserContext, null, parentFrame, ownScopeForAssignments, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DeferredCall prepareExecute(ParserContext parserContext, DeclarationContext declarationContext, RubyRootNode rootNode, MaterializedFrame parentFrame, Object self) {
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
        DynamicObject declaringModule = parserContext == ParserContext.EVAL && parentFrame != null ? RubyArguments.getMethod(parentFrame).getDeclaringModule() : (parserContext == ParserContext.MODULE ? (DynamicObject)self : this.context.getCoreLibrary().getObjectClass());
        InternalMethod method = new InternalMethod(rootNode.getSharedMethodInfo(), rootNode.getSharedMethodInfo().getName(), declaringModule, Visibility.PUBLIC, callTarget);
        return new DeferredCall(callTarget, RubyArguments.pack(parentFrame, null, method, declarationContext, null, self, null, new Object[0]));
    }

    public static class DeferredCall {
        private final CallTarget callTarget;
        private final Object[] arguments;

        public DeferredCall(CallTarget callTarget, Object[] arguments) {
            this.callTarget = callTarget;
            this.arguments = arguments;
        }

        public Object call(VirtualFrame frame, IndirectCallNode callNode) {
            return callNode.call(frame, this.callTarget, this.arguments);
        }

        public Object callWithoutCallNode() {
            return this.callTarget.call(this.arguments);
        }
    }
}

