/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.xml.bind.DatatypeConverter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.GuiSizesHelper;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImageProvider {
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String WIKI_PROTOCOL = "wiki://";
    public static final String PROP_TRANSPARENCY_FORCED = "josm.transparency.forced";
    public static final String PROP_TRANSPARENCY_COLOR = "josm.transparency.color";
    protected Collection<String> dirs;
    protected String id;
    protected String subdir;
    protected String name;
    protected File archive;
    protected String inArchiveDir;
    protected int virtualWidth = -1;
    protected int virtualHeight = -1;
    protected int virtualMaxWidth = -1;
    protected int virtualMaxHeight = -1;
    protected boolean optional;
    protected boolean suppressWarnings;
    protected Collection<ClassLoader> additionalClassLoaders;
    protected List<ImageOverlay> overlayInfo;
    protected boolean isDisabled = false;
    private static SVGUniverse svgUniverse;
    private static final Map<String, ImageResource> cache;
    private static final Map<Image, Map<Long, ImageResource>> ROTATE_CACHE;
    private static final ExecutorService IMAGE_FETCHER;
    private static final Pattern dataUrlPattern;
    private static final double DEGREE_90 = 1.5707963267948966;

    public ImageProvider(String string, String string2) {
        this.subdir = string;
        this.name = string2;
    }

    public ImageProvider(String string) {
        this.name = string;
    }

    public ImageProvider(ImageProvider imageProvider) {
        this.dirs = imageProvider.dirs;
        this.id = imageProvider.id;
        this.subdir = imageProvider.subdir;
        this.name = imageProvider.name;
        this.archive = imageProvider.archive;
        this.inArchiveDir = imageProvider.inArchiveDir;
        this.virtualWidth = imageProvider.virtualWidth;
        this.virtualHeight = imageProvider.virtualHeight;
        this.virtualMaxWidth = imageProvider.virtualMaxWidth;
        this.virtualMaxHeight = imageProvider.virtualMaxHeight;
        this.optional = imageProvider.optional;
        this.suppressWarnings = imageProvider.suppressWarnings;
        this.additionalClassLoaders = imageProvider.additionalClassLoaders;
        this.overlayInfo = imageProvider.overlayInfo;
        this.isDisabled = imageProvider.isDisabled;
    }

    public ImageProvider setDirs(Collection<String> collection) {
        this.dirs = collection;
        return this;
    }

    public ImageProvider setId(String string) {
        this.id = string;
        return this;
    }

    public ImageProvider setArchive(File file) {
        this.archive = file;
        return this;
    }

    public ImageProvider setInArchiveDir(String string) {
        this.inArchiveDir = string;
        return this;
    }

    public ImageProvider addOverlay(ImageOverlay imageOverlay) {
        if (this.overlayInfo == null) {
            this.overlayInfo = new LinkedList<ImageOverlay>();
        }
        this.overlayInfo.add(imageOverlay);
        return this;
    }

    public ImageProvider setSize(Dimension dimension) {
        this.virtualWidth = dimension.width;
        this.virtualHeight = dimension.height;
        return this;
    }

    public ImageProvider setSize(ImageSizes imageSizes) {
        return this.setSize(imageSizes.getImageDimension());
    }

    public ImageProvider setSize(int n, int n2) {
        this.virtualWidth = n;
        this.virtualHeight = n2;
        return this;
    }

    public ImageProvider setWidth(int n) {
        this.virtualWidth = n;
        return this;
    }

    public ImageProvider setHeight(int n) {
        this.virtualHeight = n;
        return this;
    }

    public ImageProvider setMaxSize(Dimension dimension) {
        this.virtualMaxWidth = dimension.width;
        this.virtualMaxHeight = dimension.height;
        return this;
    }

    public ImageProvider resetMaxSize(Dimension dimension) {
        if (this.virtualMaxWidth == -1 || dimension.width < this.virtualMaxWidth) {
            this.virtualMaxWidth = dimension.width;
        }
        if (this.virtualMaxHeight == -1 || dimension.height < this.virtualMaxHeight) {
            this.virtualMaxHeight = dimension.height;
        }
        return this;
    }

    public ImageProvider setMaxSize(ImageSizes imageSizes) {
        return this.setMaxSize(imageSizes.getImageDimension());
    }

    public ImageProvider setMaxSize(int n) {
        return this.setMaxSize(new Dimension(n, n));
    }

    public ImageProvider setMaxWidth(int n) {
        this.virtualMaxWidth = n;
        return this;
    }

    public ImageProvider setMaxHeight(int n) {
        this.virtualMaxHeight = n;
        return this;
    }

    public ImageProvider setOptional(boolean bl) {
        this.optional = bl;
        return this;
    }

    public ImageProvider setSuppressWarnings(boolean bl) {
        this.suppressWarnings = bl;
        return this;
    }

    public ImageProvider setAdditionalClassLoaders(Collection<ClassLoader> collection) {
        this.additionalClassLoaders = collection;
        return this;
    }

    public ImageProvider setDisabled(boolean bl) {
        this.isDisabled = bl;
        return this;
    }

    public ImageIcon get() {
        ImageResource imageResource = this.getResource();
        if (imageResource == null) {
            return null;
        }
        if (this.virtualMaxWidth != -1 || this.virtualMaxHeight != -1) {
            return imageResource.getImageIconBounded(new Dimension(this.virtualMaxWidth, this.virtualMaxHeight));
        }
        return imageResource.getImageIcon(new Dimension(this.virtualWidth, this.virtualHeight));
    }

    public ImageResource getResource() {
        ImageResource imageResource = this.getIfAvailableImpl(this.additionalClassLoaders);
        if (imageResource == null) {
            if (!this.optional) {
                String string = this.name.indexOf(46) != -1 ? "" : ".???";
                throw new RuntimeException(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", this.name + string));
            }
            if (!this.suppressWarnings) {
                Main.error(I18n.tr("Failed to locate image ''{0}''", this.name));
            }
            return null;
        }
        if (this.overlayInfo != null) {
            imageResource = new ImageResource(imageResource, this.overlayInfo);
        }
        if (this.isDisabled) {
            imageResource.setDisabled(true);
        }
        return imageResource;
    }

    public void getInBackground(final ImageCallback imageCallback) {
        if (this.name.startsWith(HTTP_PROTOCOL) || this.name.startsWith(WIKI_PROTOCOL)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ImageIcon imageIcon = ImageProvider.this.get();
                    imageCallback.finished(imageIcon);
                }
            };
            IMAGE_FETCHER.submit(runnable);
        } else {
            ImageIcon imageIcon = this.get();
            imageCallback.finished(imageIcon);
        }
    }

    public void getInBackground(final ImageResourceCallback imageResourceCallback) {
        if (this.name.startsWith(HTTP_PROTOCOL) || this.name.startsWith(WIKI_PROTOCOL)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    imageResourceCallback.finished(ImageProvider.this.getResource());
                }
            };
            IMAGE_FETCHER.submit(runnable);
        } else {
            imageResourceCallback.finished(this.getResource());
        }
    }

    public static ImageIcon get(String string, String string2) {
        return new ImageProvider(string, string2).get();
    }

    public static ImageIcon get(String string) {
        return new ImageProvider(string).get();
    }

    public static ImageIcon get(String string, String string2, ImageSizes imageSizes) {
        return new ImageProvider(string, string2).setSize(imageSizes).get();
    }

    public static ImageIcon getEmpty(ImageSizes imageSizes) {
        Dimension dimension = GuiSizesHelper.getDimensionDpiAdjusted(imageSizes.getImageDimension());
        return new ImageIcon(new BufferedImage(dimension.width, dimension.height, 2));
    }

    public static ImageIcon getIfAvailable(String string, String string2) {
        return new ImageProvider(string, string2).setOptional(true).get();
    }

    public static ImageIcon get(String string, ImageSizes imageSizes) {
        return new ImageProvider(string).setSize(imageSizes).get();
    }

    public static ImageIcon getIfAvailable(String string) {
        return new ImageProvider(string).setOptional(true).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageResource getIfAvailableImpl(Collection<ClassLoader> collection) {
        Map<String, ImageResource> map = cache;
        synchronized (map) {
            ImageType imageType;
            if (this.name == null) {
                return null;
            }
            String string = "";
            if (this.isDisabled) {
                string = "dis:" + string;
            }
            if (this.name.startsWith("data:")) {
                String string2 = this.name;
                ImageResource imageResource = cache.get(string + string2);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableDataUrl(string2);
                if (imageResource != null) {
                    cache.put(string + string2, imageResource);
                }
                return imageResource;
            }
            ImageType imageType2 = imageType = Utils.hasExtension(this.name, "svg") ? ImageType.SVG : ImageType.OTHER;
            if (this.name.startsWith(HTTP_PROTOCOL) || this.name.startsWith(HTTPS_PROTOCOL)) {
                String string3 = this.name;
                ImageResource imageResource = cache.get(string + string3);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableHttp(string3, imageType);
                if (imageResource != null) {
                    cache.put(string + string3, imageResource);
                }
                return imageResource;
            }
            if (this.name.startsWith(WIKI_PROTOCOL)) {
                ImageResource imageResource = cache.get(string + this.name);
                if (imageResource != null) {
                    return imageResource;
                }
                imageResource = ImageProvider.getIfAvailableWiki(this.name, imageType);
                if (imageResource != null) {
                    cache.put(string + this.name, imageResource);
                }
                return imageResource;
            }
            if (this.subdir == null) {
                this.subdir = "";
            } else if (!this.subdir.isEmpty() && !this.subdir.endsWith("/")) {
                this.subdir = this.subdir + '/';
            }
            String[] stringArray = this.name.indexOf(46) != -1 ? new String[]{""} : new String[]{".png", ".svg"};
            Integer[] integerArray = new Integer[]{0, 1};
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray[i];
                block8: for (String string4 : stringArray) {
                    if (".svg".equals(string4)) {
                        imageType = ImageType.SVG;
                    } else if (".png".equals(string4)) {
                        imageType = ImageType.OTHER;
                    }
                    String string5 = this.subdir + this.name + string4;
                    String string6 = string + string5;
                    if (this.dirs != null && !this.dirs.isEmpty()) {
                        string6 = "id:" + this.id + ':' + string5;
                        if (this.archive != null) {
                            string6 = string6 + ':' + this.archive.getName();
                        }
                    }
                    switch (n2) {
                        case 0: {
                            if (this.archive == null) continue block8;
                            string6 = "zip:" + this.archive.hashCode() + ":" + string6;
                            ImageResource imageResource = cache.get(string6);
                            if (imageResource != null) {
                                return imageResource;
                            }
                            imageResource = ImageProvider.getIfAvailableZip(string5, this.archive, this.inArchiveDir, imageType);
                            if (imageResource == null) continue block8;
                            cache.put(string6, imageResource);
                            return imageResource;
                        }
                        case 1: {
                            ImageResource imageResource = cache.get(string6);
                            if (imageResource != null) {
                                return imageResource;
                            }
                            URL uRL = ImageProvider.getImageUrl(string5, this.dirs, collection);
                            if (uRL == null || (imageResource = ImageProvider.getIfAvailableLocalURL(uRL, imageType)) == null) continue block8;
                            cache.put(string6, imageResource);
                            return imageResource;
                        }
                    }
                }
            }
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private static ImageResource getIfAvailableHttp(String var0, ImageType var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getIfAvailableDataUrl(String string) {
        Matcher matcher = dataUrlPattern.matcher(string);
        if (matcher.matches()) {
            byte[] byArray;
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            if (";base64".equals(string2)) {
                byArray = DatatypeConverter.parseBase64Binary((String)string3);
            } else {
                try {
                    byArray = Utils.decodeUrl(string3).getBytes(StandardCharsets.UTF_8);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.warn("Unable to decode URL data part: " + illegalArgumentException.getMessage() + " (" + string3 + ')');
                    return null;
                }
            }
            String string4 = matcher.group(1);
            if ("image/svg+xml".equals(string4)) {
                SVGDiagram sVGDiagram;
                String string5 = new String(byArray, StandardCharsets.UTF_8);
                SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                synchronized (sVGUniverse) {
                    URI uRI = ImageProvider.getSvgUniverse().loadSVG(new StringReader(string5), Utils.encodeUrl(string5));
                    sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                }
                if (sVGDiagram == null) {
                    Main.warn("Unable to process svg: " + string5);
                    return null;
                }
                return new ImageResource(sVGDiagram);
            }
            try {
                BufferedImage bufferedImage = ImageProvider.read(new ByteArrayInputStream(byArray), false, true);
                return bufferedImage == null ? null : new ImageResource(bufferedImage);
            }
            catch (IOException iOException) {
                Main.warn("IOException while reading image: " + iOException.getMessage());
            }
        }
        return null;
    }

    private static ImageResource getIfAvailableWiki(String string, ImageType imageType) {
        List<String> list = Arrays.asList("https://wiki.openstreetmap.org/w/images/", "https://upload.wikimedia.org/wikipedia/commons/", "https://wiki.openstreetmap.org/wiki/File:");
        Collection<String> collection = Main.pref.getCollection("image-provider.wiki.urls", list);
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        ImageResource imageResource = null;
        for (String string3 : collection) {
            String string4;
            if (string3.endsWith(":")) {
                string4 = ImageProvider.getImgUrlFromWikiInfoPage(string3, string2);
                if (string4 == null) {
                    continue;
                }
            } else {
                String string5 = Utils.md5Hex(string2);
                string4 = string3 + string5.substring(0, 1) + '/' + string5.substring(0, 2) + '/' + string2;
            }
            if ((imageResource = ImageProvider.getIfAvailableHttp(string4, imageType)) == null) continue;
            break;
        }
        return imageResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageResource getIfAvailableZip(String string, File file, String string2, ImageType imageType) {
        try (ZipFile zipFile = new ZipFile(file, StandardCharsets.UTF_8);){
            int n;
            if (string2 == null || ".".equals(string2)) {
                string2 = "";
            } else if (!string2.isEmpty()) {
                string2 = string2 + '/';
            }
            String string3 = string2 + string;
            ZipEntry zipEntry = zipFile.getEntry(string3);
            if (zipEntry == null) return null;
            int n2 = 0;
            byte[] byArray = new byte[n];
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                switch (imageType) {
                    case SVG: {
                        SVGDiagram sVGDiagram = null;
                        Object object = ImageProvider.getSvgUniverse();
                        synchronized (object) {
                            URI uRI = ImageProvider.getSvgUniverse().loadSVG(inputStream, string3);
                            sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                        }
                        object = sVGDiagram == null ? null : new ImageResource(sVGDiagram);
                        return object;
                    }
                    case OTHER: {
                        int n3;
                        for (n = (int)zipEntry.getSize(); n > 0; n2 += n3, n -= n3) {
                            n3 = inputStream.read(byArray, n2, n);
                        }
                        BufferedImage bufferedImage = null;
                        try {
                            bufferedImage = ImageProvider.read(new ByteArrayInputStream(byArray), false, false);
                        }
                        catch (IOException iOException) {
                            Main.warn(iOException);
                        }
                        ImageResource imageResource = bufferedImage == null ? null : new ImageResource(bufferedImage);
                        return imageResource;
                    }
                }
                throw new AssertionError((Object)("Unknown ImageType: " + (Object)((Object)imageType)));
            }
        }
        catch (IOException iOException) {
            Main.warn(I18n.tr("Failed to handle zip file ''{0}''. Exception was: {1}", file.getName(), iOException.toString()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getIfAvailableLocalURL(URL uRL, ImageType imageType) {
        switch (imageType) {
            case SVG: {
                SVGDiagram sVGDiagram;
                SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
                synchronized (sVGUniverse) {
                    URI uRI = ImageProvider.getSvgUniverse().loadSVG(uRL);
                    sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                }
                return sVGDiagram == null ? null : new ImageResource(sVGDiagram);
            }
            case OTHER: {
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImageProvider.read(uRL, false, true);
                    if (Main.isDebugEnabled() && ImageProvider.isTransparencyForced(bufferedImage)) {
                        Main.debug("Transparency has been forced for image " + uRL.toExternalForm());
                    }
                }
                catch (IOException iOException) {
                    Main.warn(iOException);
                }
                return bufferedImage == null ? null : new ImageResource(bufferedImage);
            }
        }
        throw new AssertionError();
    }

    private static URL getImageUrl(String string, String string2, Collection<ClassLoader> collection) {
        if (string != null && string.startsWith("resource://")) {
            String string3 = string.substring("resource://".length());
            ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(PluginHandler.getResourceClassLoaders());
            if (collection != null) {
                arrayList.addAll(collection);
            }
            for (ClassLoader classLoader : arrayList) {
                URL uRL = classLoader.getResource(string3 + string2);
                if (uRL == null) continue;
                return uRL;
            }
        } else {
            File file = new File(string, string2);
            if ((string != null || file.isAbsolute()) && file.exists()) {
                return Utils.fileToURL(file);
            }
        }
        return null;
    }

    private static URL getImageUrl(String string, Collection<String> collection, Collection<ClassLoader> collection2) {
        URL uRL;
        if (collection != null) {
            for (String string2 : collection) {
                try {
                    uRL = ImageProvider.getImageUrl(string2, string, collection2);
                    if (uRL == null) continue;
                    return uRL;
                }
                catch (SecurityException securityException) {
                    Main.warn(I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", string2, securityException.toString()));
                }
            }
        }
        if (Main.pref != null) {
            Iterator<String> iterator = new File(Main.pref.getUserDataDirectory(), "images").getAbsolutePath();
            try {
                uRL = ImageProvider.getImageUrl((String)((Object)iterator), string, collection2);
                if (uRL != null) {
                    return uRL;
                }
            }
            catch (SecurityException securityException) {
                Main.warn(I18n.tr("Failed to access directory ''{0}'' for security reasons. Exception was: {1}", iterator, securityException.toString()));
            }
        }
        if ((uRL = ImageProvider.getImageUrl(null, string, collection2)) != null) {
            return uRL;
        }
        uRL = ImageProvider.getImageUrl("resource://images/", string, collection2);
        if (uRL != null) {
            return uRL;
        }
        if (Main.pref != null) {
            for (String string2 : Main.pref.getAllPossiblePreferenceDirs()) {
                uRL = ImageProvider.getImageUrl(string2 + "images", string, collection2);
                if (uRL != null) {
                    return uRL;
                }
                uRL = ImageProvider.getImageUrl(string2, string, collection2);
                if (uRL == null) continue;
                return uRL;
            }
        }
        return null;
    }

    private static String getImgUrlFromWikiInfoPage(String string, final String string2) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){

                @Override
                public void startElement(String string, String string22, String string3, Attributes attributes) throws SAXException {
                    String string4;
                    if ("img".equalsIgnoreCase(string22) && (string4 = attributes.getValue("src")).endsWith(string2)) {
                        throw new SAXReturnException(string4);
                    }
                }
            });
            xMLReader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            CachedFile cachedFile = new CachedFile(string + string2).setDestDir(new File(Main.pref.getUserDataDirectory(), "images").getPath());
            try (InputStream inputStream = cachedFile.getInputStream();){
                xMLReader.parse(new InputSource(inputStream));
            }
            cachedFile.close();
        }
        catch (SAXReturnException sAXReturnException) {
            return sAXReturnException.getResult();
        }
        catch (IOException | SAXException exception) {
            Main.warn("Parsing " + string + string2 + " failed:\n" + exception);
            return null;
        }
        Main.warn("Parsing " + string + string2 + " failed: Unexpected content.");
        return null;
    }

    public static Cursor getCursor(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.get("cursor", string);
        if (string2 != null) {
            imageIcon = new ImageProvider("cursor", string).setMaxSize(ImageSizes.CURSOR).addOverlay(new ImageOverlay(new ImageProvider("cursor/modifier/" + string2).setMaxSize(ImageSizes.CURSOROVERLAY))).get();
        }
        if (GraphicsEnvironment.isHeadless()) {
            if (Main.isDebugEnabled()) {
                Main.debug("Cursors are not available in headless mode. Returning null for '" + string + '\'');
            }
            return null;
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), "crosshair".equals(string) ? new Point(10, 10) : new Point(3, 2), "Cursor");
    }

    public static Image createRotatedImage(Image image, double d) {
        return ImageProvider.createRotatedImage(image, d, ImageResource.DEFAULT_DIMENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image createRotatedImage(Image image, double d, Dimension dimension) {
        CheckParameterUtil.ensureParameterNotNull(image, "img");
        Long l = Math.round(d % 360.0);
        if (d != 0.0 && l == 0L) {
            l = 360L;
        }
        Map<Image, Map<Long, ImageResource>> map = ROTATE_CACHE;
        synchronized (map) {
            ImageResource imageResource;
            Map<Long, ImageResource> map2 = ROTATE_CACHE.get(image);
            if (map2 == null) {
                map2 = new HashMap<Long, ImageResource>();
                ROTATE_CACHE.put(image, map2);
            }
            if ((imageResource = map2.get(l)) == null) {
                int n;
                int n2;
                double d2 = l % 90L;
                if (l != 0L && d2 == 0.0) {
                    d2 = 90.0;
                }
                double d3 = Math.toRadians(d2);
                new ImageIcon(image);
                int n3 = image.getWidth(null);
                int n4 = image.getHeight(null);
                if (l >= 0L && l <= 90L || l > 180L && l <= 270L) {
                    n2 = (int)((double)n3 * Math.sin(1.5707963267948966 - d3) + (double)n4 * Math.sin(d3));
                    n = (int)((double)n3 * Math.sin(d3) + (double)n4 * Math.sin(1.5707963267948966 - d3));
                } else {
                    n2 = (int)((double)n4 * Math.sin(1.5707963267948966 - d3) + (double)n3 * Math.sin(d3));
                    n = (int)((double)n4 * Math.sin(d3) + (double)n3 * Math.sin(1.5707963267948966 - d3));
                }
                BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
                imageResource = new ImageResource(bufferedImage);
                map2.put(l, imageResource);
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                int n5 = n3 / 2;
                int n6 = n4 / 2;
                graphics2D.translate(n2 / 2, n / 2);
                graphics2D.rotate(Math.toRadians(l.longValue()));
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics2D.drawImage(image, -n5, -n6, null);
                graphics2D.dispose();
                new ImageIcon(bufferedImage);
            }
            return imageResource.getImageIcon(dimension).getImage();
        }
    }

    public static Image createBoundedImage(Image image, int n) {
        return new ImageResource(image).getImageIconBounded(new Dimension(n, n)).getImage();
    }

    public static ImageIcon get(OsmPrimitiveType osmPrimitiveType) {
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        return ImageProvider.get("data", osmPrimitiveType.getAPIName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getPadded(OsmPrimitive osmPrimitive, Dimension dimension) {
        Object object;
        Object object2;
        if (osmPrimitive instanceof Node) {
            object2 = osmPrimitive.getDataSet();
            if (object2 != null) {
                ((DataSet)object2).getReadLock().lock();
            }
            try {
                object = MapPaintStyles.getStyles().generateStyles(osmPrimitive, 100.0, false);
            }
            finally {
                if (object2 != null) {
                    ((DataSet)object2).getReadLock().unlock();
                }
            }
            for (StyleElement styleElement : (StyleElementList)((Pair)object).a) {
                Image image;
                int n;
                int n2;
                if (!(styleElement instanceof NodeElement)) continue;
                NodeElement nodeElement = (NodeElement)styleElement;
                MapImage mapImage = nodeElement.mapImage;
                if (mapImage == null) continue;
                int n3 = GuiSizesHelper.getSizeDpiAdjusted(dimension.width);
                int n4 = GuiSizesHelper.getSizeDpiAdjusted(dimension.height);
                int n5 = mapImage.getWidth();
                int n6 = mapImage.getHeight();
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
                double d = Math.min((double)n3 / (double)n5, (double)n4 / (double)n6);
                BufferedImage bufferedImage2 = mapImage.getImage(false);
                if (d < 1.0) {
                    n2 = (int)((double)n5 * d);
                    n = (int)((double)n6 * d);
                    image = bufferedImage2.getScaledInstance(n2, n, 4);
                } else {
                    n2 = n5;
                    n = n6;
                    image = bufferedImage2;
                }
                bufferedImage.getGraphics().drawImage(image, (n3 - n2) / 2, (n4 - n) / 2, null);
                return new ImageIcon(bufferedImage);
            }
        }
        if (!OsmPrimitiveType.WAY.equals((Object)osmPrimitive.getType())) {
            object = new TreeSet<TaggingPreset>(new Comparator<TaggingPreset>(){

                @Override
                public int compare(TaggingPreset taggingPreset, TaggingPreset taggingPreset2) {
                    int n = taggingPreset.types == null || taggingPreset.types.isEmpty() ? Integer.MAX_VALUE : taggingPreset.types.size();
                    int n2 = taggingPreset2.types == null || taggingPreset2.types.isEmpty() ? Integer.MAX_VALUE : taggingPreset2.types.size();
                    return Integer.compare(n, n2);
                }
            });
            object.addAll(TaggingPresets.getMatchingPresets(osmPrimitive));
            object2 = object.iterator();
            while (object2.hasNext()) {
                TaggingPreset taggingPreset = (TaggingPreset)object2.next();
                if (taggingPreset.getIcon() == null) continue;
                return taggingPreset.getIcon();
            }
        }
        return ImageProvider.get(osmPrimitive.getDisplayType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createImageFromSvg(SVGDiagram sVGDiagram, Dimension dimension) {
        Double d;
        Double d2;
        float f = sVGDiagram.getWidth();
        float f2 = sVGDiagram.getHeight();
        int n = Math.round(GuiSizesHelper.getSizeDpiAdjusted(f));
        int n2 = Math.round(GuiSizesHelper.getSizeDpiAdjusted(f2));
        if (dimension.width != -1) {
            n = dimension.width;
            d2 = (double)n / (double)f;
            if (dimension.height == -1) {
                d = d2;
                n2 = (int)Math.round((double)f2 * d);
            } else {
                n2 = dimension.height;
                d = (double)n2 / (double)f2;
            }
        } else if (dimension.height != -1) {
            n2 = dimension.height;
            d2 = d = Double.valueOf((double)n2 / (double)f2);
            n = (int)Math.round((double)f * d2);
        } else {
            d2 = d = Double.valueOf((double)n2 / (double)f2);
        }
        if (n == 0 || n2 == 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.scale(d2, d);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            SVGUniverse sVGUniverse = ImageProvider.getSvgUniverse();
            synchronized (sVGUniverse) {
                sVGDiagram.render(graphics2D);
            }
        }
        catch (SVGException sVGException) {
            Main.error("Unable to load svg: {0}", sVGException.getMessage());
            return null;
        }
        return bufferedImage;
    }

    private static synchronized SVGUniverse getSvgUniverse() {
        if (svgUniverse == null) {
            svgUniverse = new SVGUniverse();
        }
        return svgUniverse;
    }

    public static BufferedImage read(File file, boolean bl, boolean bl2) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(file, "input");
        if (!file.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
        if (imageInputStream == null) {
            throw new IIOException("Can't create an ImageInputStream!");
        }
        BufferedImage bufferedImage = ImageProvider.read(imageInputStream, bl, bl2);
        if (bufferedImage == null) {
            imageInputStream.close();
        }
        return bufferedImage;
    }

    public static BufferedImage read(InputStream inputStream, boolean bl, boolean bl2) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(inputStream, "input");
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        BufferedImage bufferedImage = ImageProvider.read(imageInputStream, bl, bl2);
        if (bufferedImage == null) {
            imageInputStream.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(URL uRL, boolean bl, boolean bl2) throws IOException {
        BufferedImage bufferedImage;
        CheckParameterUtil.ensureParameterNotNull(uRL, "input");
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            throw new IIOException("Can't get input stream from URL!", iOException);
        }
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        try {
            bufferedImage = ImageProvider.read(imageInputStream, bl, bl2);
            if (bufferedImage == null) {
                imageInputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(ImageInputStream imageInputStream, boolean bl, boolean bl2) throws IOException {
        BufferedImage bufferedImage;
        CheckParameterUtil.ensureParameterNotNull(imageInputStream, "stream");
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        ImageReader imageReader = iterator.next();
        ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
        imageReader.setInput(imageInputStream, true, !bl && !bl2);
        try {
            Color color;
            bufferedImage = imageReader.read(0, imageReadParam);
            if (bufferedImage.getTransparency() != 3 && (bl || bl2) && (color = ImageProvider.getTransparentColor(bufferedImage.getColorModel(), imageReader)) != null) {
                Hashtable<String, Color> hashtable = new Hashtable<String, Color>(1);
                hashtable.put(PROP_TRANSPARENCY_COLOR, color);
                bufferedImage = new BufferedImage(bufferedImage.getColorModel(), bufferedImage.getRaster(), bufferedImage.isAlphaPremultiplied(), hashtable);
                if (bl2) {
                    if (Main.isTraceEnabled()) {
                        Main.trace("Enforcing image transparency of " + imageInputStream + " for " + color);
                    }
                    bufferedImage = ImageProvider.makeImageTransparent(bufferedImage, color);
                }
            }
        }
        finally {
            imageReader.dispose();
            imageInputStream.close();
        }
        return bufferedImage;
    }

    public static Color getTransparentColor(ColorModel colorModel, ImageReader imageReader) throws IOException {
        block6: {
            try {
                String[] stringArray;
                IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
                if (iIOMetadata == null || (stringArray = iIOMetadata.getMetadataFormatNames()) == null) break block6;
                for (String string : stringArray) {
                    String string2;
                    org.w3c.dom.Node node;
                    NodeList nodeList;
                    if (!"javax_imageio_1.0".equals(string)) continue;
                    org.w3c.dom.Node node2 = iIOMetadata.getAsTree(string);
                    if (node2 instanceof Element && (nodeList = ((Element)node2).getElementsByTagName("TransparentColor")).getLength() > 0 && (node = nodeList.item(0)) instanceof Element && !(string2 = ((Element)node).getAttribute("value")).isEmpty()) {
                        String[] stringArray2 = string2.split(" ");
                        if (stringArray2.length == 3) {
                            return ImageProvider.parseRGB(stringArray2);
                        }
                        if (stringArray2.length == 1) {
                            int n = Integer.parseInt(stringArray2[0]);
                            int n2 = colorModel.getRed(n);
                            int n3 = colorModel.getGreen(n);
                            int n4 = colorModel.getBlue(n);
                            return new Color(n2, n3, n4);
                        }
                        Main.warn("Unable to translate TransparentColor '" + string2 + "' with color model " + colorModel);
                    }
                    break;
                }
            }
            catch (NumberFormatException | IIOException exception) {
                Main.warn(exception);
            }
        }
        return null;
    }

    private static Color parseRGB(String[] stringArray) {
        int[] nArray = new int[3];
        try {
            for (int i = 0; i < 3; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
            return new Color(nArray[0], nArray[1], nArray[2]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.error(illegalArgumentException);
            return null;
        }
    }

    public static BufferedImage makeImageTransparent(BufferedImage bufferedImage, Color color) {
        final int n = color.getRGB() | 0xFF000000;
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){

            @Override
            public int filterRGB(int n4, int n2, int n3) {
                if ((n3 | 0xFF000000) == n) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
        Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        ColorModel colorModel = ColorModel.getRGBdefault();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(image.getWidth(null), image.getHeight(null));
        String[] stringArray = bufferedImage.getPropertyNames();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(1 + (stringArray != null ? stringArray.length : 0));
        if (stringArray != null) {
            for (String string : stringArray) {
                hashtable.put(string, bufferedImage.getProperty(string));
            }
        }
        hashtable.put(PROP_TRANSPARENCY_FORCED, Boolean.TRUE);
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, false, hashtable);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static boolean isTransparencyForced(BufferedImage bufferedImage) {
        return bufferedImage != null && !bufferedImage.getProperty(PROP_TRANSPARENCY_FORCED).equals(Image.UndefinedProperty);
    }

    public static boolean hasTransparentColor(BufferedImage bufferedImage) {
        return bufferedImage != null && !bufferedImage.getProperty(PROP_TRANSPARENCY_COLOR).equals(Image.UndefinedProperty);
    }

    public static void shutdown(boolean bl) {
        if (bl) {
            IMAGE_FETCHER.shutdownNow();
        } else {
            IMAGE_FETCHER.shutdown();
        }
    }

    static {
        cache = new HashMap<String, ImageResource>();
        ROTATE_CACHE = new HashMap<Image, Map<Long, ImageResource>>();
        IMAGE_FETCHER = Executors.newSingleThreadExecutor(Utils.newThreadFactory("image-fetcher-%d", 5));
        dataUrlPattern = Pattern.compile("^data:([a-zA-Z]+/[a-zA-Z+]+)?(;base64)?,(.+)$");
    }

    private static class SAXReturnException
    extends SAXException {
        private final String result;

        SAXReturnException(String string) {
            this.result = string;
        }

        public String getResult() {
            return this.result;
        }
    }

    public static interface ImageResourceCallback {
        public void finished(ImageResource var1);
    }

    public static interface ImageCallback {
        public void finished(ImageIcon var1);
    }

    public static enum ImageSizes {
        SMALLICON(Main.pref.getInteger("iconsize.smallicon", 16)),
        LARGEICON(Main.pref.getInteger("iconsize.largeicon", 24)),
        MAP(Main.pref.getInteger("iconsize.map", 16)),
        MAPMAX(Main.pref.getInteger("iconsize.mapmax", 48)),
        CURSOR(Main.pref.getInteger("iconsize.cursor", 32)),
        CURSOROVERLAY(CURSOR),
        MENU(SMALLICON),
        POPUPMENU(LARGEICON),
        LAYER(Main.pref.getInteger("iconsize.layer", 16)),
        TOOLBAR(LARGEICON),
        SIDEBUTTON(Main.pref.getInteger("iconsize.sidebutton", 20)),
        SETTINGS_TAB(Main.pref.getInteger("iconsize.settingstab", 48)),
        DEFAULT(Main.pref.getInteger("iconsize.default", 24)),
        SPLASH_LOGO(128, 129),
        ABOUT_LOGO(256, 258);

        private final int virtualWidth;
        private final int virtualHeight;

        private ImageSizes(int n2) {
            this.virtualWidth = n2;
            this.virtualHeight = n2;
        }

        private ImageSizes(int n2, int n3) {
            this.virtualWidth = n2;
            this.virtualHeight = n3;
        }

        private ImageSizes(ImageSizes imageSizes) {
            this.virtualWidth = imageSizes.virtualWidth;
            this.virtualHeight = imageSizes.virtualHeight;
        }

        public int getVirtualWidth() {
            return this.virtualWidth;
        }

        public int getVirtualHeight() {
            return this.virtualHeight;
        }

        public Dimension getImageDimension() {
            return new Dimension(this.virtualWidth, this.virtualHeight);
        }
    }

    public static enum ImageType {
        SVG,
        OTHER;

    }

    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

