/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginPreferenceFactory;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class PluginHandler {
    static final Collection<DeprecatedPlugin> DEPRECATED_PLUGINS;
    static final List<String> UNMAINTAINED_PLUGINS;
    public static final int DEFAULT_TIME_BASED_UPDATE_INTERVAL = 30;
    public static final Collection<PluginProxy> pluginList;
    public static final Map<String, Exception> pluginLoadingExceptions;
    private static DynamicURLClassLoader pluginClassLoader;
    private static final List<ClassLoader> sources;
    private static PluginDownloadTask pluginDownloadTask;

    private PluginHandler() {
    }

    public static Collection<ClassLoader> getResourceClassLoaders() {
        return Collections.unmodifiableCollection(sources);
    }

    static void filterDeprecatedPlugins(Component component, Collection<String> collection) {
        TreeSet<DeprecatedPlugin> treeSet = new TreeSet<DeprecatedPlugin>();
        for (DeprecatedPlugin object : DEPRECATED_PLUGINS) {
            if (!collection.contains(object.name)) continue;
            collection.remove(object.name);
            Main.pref.removeFromCollection("plugins", object.name);
            treeSet.add(object);
        }
        if (treeSet.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("<html>").append(I18n.trn("The following plugin is no longer necessary and has been deactivated:", "The following plugins are no longer necessary and have been deactivated:", treeSet.size(), new Object[0])).append("<ul>");
        for (DeprecatedPlugin deprecatedPlugin : treeSet) {
            stringBuilder.append("<li>").append(deprecatedPlugin.name);
            if (deprecatedPlugin.reason != null) {
                stringBuilder.append(" (").append(deprecatedPlugin.reason).append(')');
            }
            stringBuilder.append("</li>");
        }
        stringBuilder.append("</ul></html>");
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(component, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2);
        }
    }

    static void filterUnmaintainedPlugins(Component component, Collection<String> collection) {
        for (String string : UNMAINTAINED_PLUGINS) {
            if (!collection.contains(string)) continue;
            String string2 = I18n.tr("<html>Loading of the plugin \"{0}\" was requested.<br>This plugin is no longer developed and very likely will produce errors.<br>It should be disabled.<br>Delete from preferences?</html>", string);
            if (!PluginHandler.confirmDisablePlugin(component, string2, string)) continue;
            Main.pref.removeFromCollection("plugins", string);
            collection.remove(string);
        }
    }

    public static boolean checkAndConfirmPluginUpdate(Component component) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray;
        if (!PluginHandler.checkOfflineAccess()) {
            Main.info(I18n.tr("{0} not available (offline mode)", I18n.tr("Plugin update", new Object[0])));
            return false;
        }
        String string = null;
        String string2 = null;
        int n = Version.getInstance().getVersion();
        if (Main.pref.getInteger("pluginmanager.version", 0) < n) {
            string = "<html>" + I18n.tr("You updated your JOSM software.<br>To prevent problems the plugins should be updated as well.<br><br>Update plugins now?", new Object[0]) + "</html>";
            string2 = "pluginmanager.version-based-update.policy";
        } else {
            long l = System.currentTimeMillis();
            long l2 = Main.pref.getLong("pluginmanager.lastupdate", 0L);
            Integer n2 = Main.pref.getInteger("pluginmanager.time-based-update.interval", 30);
            long l3 = (l - l2) / 86400000L;
            if (l2 <= 0L || n2 <= 0) {
                Main.pref.put("pluginmanager.lastupdate", Long.toString(l));
            } else if (l3 > (long)n2.intValue()) {
                string = "<html>" + I18n.tr("Last plugin update more than {0} days ago.", l3) + "</html>";
                string2 = "pluginmanager.time-based-update.policy";
            }
        }
        if (string == null) {
            return false;
        }
        UpdatePluginsMessagePanel updatePluginsMessagePanel = new UpdatePluginsMessagePanel();
        updatePluginsMessagePanel.setMessage(string);
        updatePluginsMessagePanel.initDontShowAgain(string2);
        switch (buttonSpecArray = Main.pref.get(string2, "ask").trim().toLowerCase(Locale.ENGLISH)) {
            case "never": {
                if ("pluginmanager.version-based-update.policy".equals(string2)) {
                    Main.info(I18n.tr("Skipping plugin update after JOSM upgrade. Automatic update at startup is disabled.", new Object[0]));
                } else if ("pluginmanager.time-based-update.policy".equals(string2)) {
                    Main.info(I18n.tr("Skipping plugin update after elapsed update interval. Automatic update at startup is disabled.", new Object[0]));
                }
                return false;
            }
            case "always": {
                if ("pluginmanager.version-based-update.policy".equals(string2)) {
                    Main.info(I18n.tr("Running plugin update after JOSM upgrade. Automatic update at startup is enabled.", new Object[0]));
                } else if ("pluginmanager.time-based-update.policy".equals(string2)) {
                    Main.info(I18n.tr("Running plugin update after elapsed update interval. Automatic update at startup is disabled.", new Object[0]));
                }
                return true;
            }
            case "ask": {
                break;
            }
            default: {
                Main.warn(I18n.tr("Unexpected value ''{0}'' for preference ''{1}''. Assuming value ''ask''.", buttonSpecArray, string2));
            }
        }
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray2 = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugins", new Object[0]), ImageProvider.get("dialogs", "refresh"), I18n.tr("Click to update the activated plugins", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Skip update", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to skip updating the activated plugins", new Object[0]), null)};
        int n3 = HelpAwareOptionPane.showOptionDialog(component, updatePluginsMessagePanel, I18n.tr("Update plugins", new Object[0]), 2, null, buttonSpecArray2, buttonSpecArray2[0], HelpUtil.ht("/Preferences/Plugins#AutomaticUpdate"));
        if (updatePluginsMessagePanel.isRememberDecision()) {
            switch (n3) {
                case 0: {
                    Main.pref.put(string2, "always");
                    break;
                }
                case -1: 
                case 1: {
                    Main.pref.put(string2, "never");
                    break;
                }
            }
        } else {
            Main.pref.put(string2, "ask");
        }
        return n3 == 0;
    }

    private static boolean checkOfflineAccess() {
        if (Main.isOffline(OnlineResource.ALL)) {
            return false;
        }
        if (Main.isOffline(OnlineResource.JOSM_WEBSITE)) {
            for (String string : Main.pref.getPluginSites()) {
                try {
                    OnlineResource.JOSM_WEBSITE.checkOfflineAccess(string, Main.getJOSMWebsite());
                }
                catch (OfflineAccessException offlineAccessException) {
                    if (Main.isTraceEnabled()) {
                        Main.trace(offlineAccessException.getMessage());
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private static void alertMissingRequiredPlugin(Component component, String string, Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder(48);
        stringBuilder.append("<html>").append(I18n.trn("Plugin {0} requires a plugin which was not found. The missing plugin is:", "Plugin {0} requires {1} plugins which were not found. The missing plugins are:", set.size(), string, set.size())).append(Utils.joinAsHtmlUnorderedList(set)).append("</html>");
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Download and restart", new Object[0]), ImageProvider.get("restart"), I18n.trn("Click to download missing plugin and restart JOSM", "Click to download missing plugins and restart JOSM", set.size(), new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), ImageProvider.get("ok"), I18n.trn("Click to continue without this plugin", "Click to continue without these plugins", set.size(), new Object[0]), null)};
        if (0 == HelpAwareOptionPane.showOptionDialog(component, stringBuilder.toString(), I18n.tr("Error", new Object[0]), 0, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Plugin/Loading#MissingRequiredPlugin"))) {
            PluginHandler.downloadRequiredPluginsAndRestart(component, set);
        }
    }

    private static void downloadRequiredPluginsAndRestart(final Component component, final Set<String> set) {
        final ReadRemotePluginInformationTask readRemotePluginInformationTask = new ReadRemotePluginInformationTask(Main.pref.getOnlinePluginSites());
        Main.worker.submit(readRemotePluginInformationTask);
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>(readRemotePluginInformationTask.getAvailablePlugins());
                Object object = hashSet.iterator();
                while (object.hasNext()) {
                    PluginInformation pluginInformation = (PluginInformation)object.next();
                    if (set.contains(pluginInformation.getName())) continue;
                    object.remove();
                }
                if (!hashSet.isEmpty()) {
                    object = new PluginDownloadTask(component, hashSet, I18n.tr("Download plugins", new Object[0]));
                    Main.worker.submit((Runnable)object);
                    Main.worker.submit(new Runnable((PluginDownloadTask)object){
                        final /* synthetic */ PluginDownloadTask val$task;
                        {
                            this.val$task = pluginDownloadTask;
                        }

                        @Override
                        public void run() {
                            if (!this.val$task.getDownloadedPlugins().isEmpty()) {
                                HashSet<String> hashSet = new HashSet<String>(Main.pref.getCollection("plugins"));
                                for (PluginInformation pluginInformation : this.val$task.getDownloadedPlugins()) {
                                    hashSet.add(pluginInformation.name);
                                }
                                Main.pref.putCollection("plugins", hashSet);
                                new RestartAction().actionPerformed(null);
                            } else {
                                Main.warn("No plugin downloaded, restart canceled");
                            }
                        }
                    });
                } else {
                    Main.warn("No plugin to download, operation canceled");
                }
            }
        });
    }

    private static void alertJOSMUpdateRequired(Component component, String string, int n) {
        HelpAwareOptionPane.showOptionDialog(component, I18n.tr("<html>Plugin {0} requires JOSM version {1}. The current JOSM version is {2}.<br>You have to update JOSM in order to use this plugin.</html>", string, Integer.toString(n), Version.getInstance().getVersionString()), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Plugin/Loading#JOSMUpdateRequired"));
    }

    public static boolean checkLoadPreconditions(Component component, Collection<PluginInformation> collection, PluginInformation pluginInformation) {
        int n = Version.getInstance().getVersion();
        if (pluginInformation.localmainversion > n && n != 0) {
            PluginHandler.alertJOSMUpdateRequired(component, pluginInformation.name, pluginInformation.localmainversion);
            return false;
        }
        HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>(collection);
        for (PluginProxy pluginProxy : pluginList) {
            hashSet.add(pluginProxy.getPluginInformation());
        }
        return PluginHandler.checkRequiredPluginsPreconditions(component, hashSet, pluginInformation, true);
    }

    public static boolean checkRequiredPluginsPreconditions(Component component, Collection<PluginInformation> collection, PluginInformation pluginInformation, boolean bl) {
        String string;
        String string2 = string = bl ? pluginInformation.localrequires : pluginInformation.requires;
        if (string != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (PluginInformation object2 : collection) {
                hashSet.add(object2.name);
            }
            HashSet hashSet2 = new HashSet();
            List<String> list = bl ? pluginInformation.getLocalRequiredPlugins() : pluginInformation.getRequiredPlugins();
            for (String string3 : list) {
                if (hashSet.contains(string3)) continue;
                hashSet2.add(string3);
            }
            if (!hashSet2.isEmpty()) {
                if (component != null) {
                    PluginHandler.alertMissingRequiredPlugin(component, pluginInformation.name, hashSet2);
                }
                return false;
            }
        }
        return true;
    }

    public static synchronized DynamicURLClassLoader getPluginClassLoader() {
        if (pluginClassLoader == null) {
            pluginClassLoader = AccessController.doPrivileged(new PrivilegedAction<DynamicURLClassLoader>(){

                @Override
                public DynamicURLClassLoader run() {
                    return new DynamicURLClassLoader(new URL[0], Main.class.getClassLoader());
                }
            });
            sources.add(0, pluginClassLoader);
        }
        return pluginClassLoader;
    }

    public static void extendPluginClassLoader(Collection<PluginInformation> collection) {
        File file = Main.pref.getPluginsDirectory();
        DynamicURLClassLoader dynamicURLClassLoader = PluginHandler.getPluginClassLoader();
        for (PluginInformation pluginInformation : collection) {
            URL uRL2;
            if (pluginInformation.libraries == null) continue;
            for (URL uRL2 : pluginInformation.libraries) {
                dynamicURLClassLoader.addURL(uRL2);
            }
            File file2 = new File(file, pluginInformation.name + ".jar");
            I18n.addTexts(file2);
            uRL2 = Utils.fileToURL(file2);
            dynamicURLClassLoader.addURL(uRL2);
        }
    }

    public static void loadPlugin(Component component, PluginInformation pluginInformation, ClassLoader classLoader) {
        String string = I18n.tr("Could not load plugin {0}. Delete from preferences?", pluginInformation.name);
        try {
            Class<?> clazz = pluginInformation.loadClass(classLoader);
            if (clazz != null) {
                Main.info(I18n.tr("loading plugin ''{0}'' (version {1})", pluginInformation.name, pluginInformation.localversion));
                PluginProxy pluginProxy = pluginInformation.load(clazz);
                pluginList.add(pluginProxy);
                Main.addMapFrameListener(pluginProxy, true);
            }
            string = null;
        }
        catch (PluginException pluginException) {
            pluginLoadingExceptions.put(pluginInformation.name, pluginException);
            Main.error(pluginException);
            if (pluginException.getCause() instanceof ClassNotFoundException) {
                string = I18n.tr("<html>Could not load plugin {0} because the plugin<br>main class ''{1}'' was not found.<br>Delete from preferences?</html>", pluginInformation.name, pluginInformation.className);
            }
        }
        catch (RuntimeException runtimeException) {
            pluginLoadingExceptions.put(pluginInformation.name, runtimeException);
            Main.error(runtimeException);
        }
        if (string != null && PluginHandler.confirmDisablePlugin(component, string, pluginInformation.name)) {
            Main.pref.removeFromCollection("plugins", pluginInformation.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins(Component component, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Loading plugins ...", new Object[0]));
            progressMonitor.subTask(I18n.tr("Checking plugin preconditions...", new Object[0]));
            LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
            for (PluginInformation pluginInformation : collection) {
                if (!PluginHandler.checkLoadPreconditions(component, collection, pluginInformation)) continue;
                linkedList.add(pluginInformation);
            }
            Collections.sort(linkedList, new Comparator<PluginInformation>(){

                @Override
                public int compare(PluginInformation pluginInformation, PluginInformation pluginInformation2) {
                    if (pluginInformation.stage < pluginInformation2.stage) {
                        return -1;
                    }
                    if (pluginInformation.stage == pluginInformation2.stage) {
                        return 0;
                    }
                    return 1;
                }
            });
            if (linkedList.isEmpty()) {
                return;
            }
            PluginHandler.extendPluginClassLoader(linkedList);
            progressMonitor.setTicksCount(linkedList.size());
            for (PluginInformation pluginInformation : linkedList) {
                progressMonitor.setExtraText(I18n.tr("Loading plugin ''{0}''...", pluginInformation.name));
                PluginHandler.loadPlugin(component, pluginInformation, PluginHandler.getPluginClassLoader());
                progressMonitor.worked(1);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public static void loadEarlyPlugins(Component component, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(collection.size());
        for (PluginInformation pluginInformation : collection) {
            if (!pluginInformation.early) continue;
            arrayList.add(pluginInformation);
        }
        PluginHandler.loadPlugins(component, arrayList, progressMonitor);
    }

    public static void loadLatePlugins(Component component, Collection<PluginInformation> collection, ProgressMonitor progressMonitor) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(collection.size());
        for (PluginInformation pluginInformation : collection) {
            if (pluginInformation.early) continue;
            arrayList.add(pluginInformation);
        }
        PluginHandler.loadPlugins(component, arrayList, progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, PluginInformation> loadLocallyAvailablePluginInformation(ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            ReadLocalPluginInformationTask readLocalPluginInformationTask = new ReadLocalPluginInformationTask(progressMonitor);
            try {
                readLocalPluginInformationTask.run();
            }
            catch (RuntimeException runtimeException) {
                Main.error(runtimeException);
                Map<String, PluginInformation> map = null;
                progressMonitor.finishTask();
                return map;
            }
            HashMap<String, PluginInformation> hashMap = new HashMap<String, PluginInformation>();
            for (PluginInformation pluginInformation : readLocalPluginInformationTask.getAvailablePlugins()) {
                hashMap.put(pluginInformation.name, pluginInformation);
            }
            HashMap<String, PluginInformation> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static void alertMissingPluginInformation(Component component, Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>").append(I18n.trn("JOSM could not find information about the following plugin:", "JOSM could not find information about the following plugins:", collection.size(), new Object[0])).append(Utils.joinAsHtmlUnorderedList(collection)).append(I18n.trn("The plugin is not going to be loaded.", "The plugins are not going to be loaded.", collection.size(), new Object[0])).append("</html>");
        HelpAwareOptionPane.showOptionDialog(component, stringBuilder.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Plugin/Loading#MissingPluginInfos"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginInformation> buildListOfPluginsToLoad(Component component, ProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            String string;
            progressMonitor.beginTask(I18n.tr("Determine plugins to load...", new Object[0]));
            HashSet<String> hashSet = new HashSet<String>(Main.pref.getCollection("plugins", new LinkedList<String>()));
            if (Main.isDebugEnabled()) {
                Main.debug("Plugins list initialized to " + hashSet);
            }
            if ((string = System.getProperty("josm.plugins")) != null) {
                hashSet.addAll(Arrays.asList(string.split(",")));
                if (Main.isDebugEnabled()) {
                    Main.debug("josm.plugins system property set to '" + string + "'. Plugins list is now " + hashSet);
                }
            }
            progressMonitor.subTask(I18n.tr("Removing deprecated plugins...", new Object[0]));
            PluginHandler.filterDeprecatedPlugins(component, hashSet);
            progressMonitor.subTask(I18n.tr("Removing unmaintained plugins...", new Object[0]));
            PluginHandler.filterUnmaintainedPlugins(component, hashSet);
            if (Main.isDebugEnabled()) {
                Main.debug("Plugins list is finally set to " + hashSet);
            }
            Map<String, PluginInformation> map = PluginHandler.loadLocallyAvailablePluginInformation(progressMonitor.createSubTaskMonitor(1, false));
            LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                if (!map.containsKey(string2)) continue;
                linkedList.add(map.get(string2));
                object.remove();
            }
            if (!hashSet.isEmpty()) {
                PluginHandler.alertMissingPluginInformation(component, hashSet);
            }
            object = linkedList;
            return object;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static void alertFailedPluginUpdate(Component component, Collection<PluginInformation> collection) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("<html>").append(I18n.trn("Updating the following plugin has failed:", "Updating the following plugins has failed:", collection.size(), new Object[0])).append("<ul>");
        for (PluginInformation pluginInformation : collection) {
            stringBuilder.append("<li>").append(pluginInformation.name).append("</li>");
        }
        stringBuilder.append("</ul>").append(I18n.trn("Please open the Preference Dialog after JOSM has started and try to update it manually.", "Please open the Preference Dialog after JOSM has started and try to update them manually.", collection.size(), new Object[0])).append("</html>");
        HelpAwareOptionPane.showOptionDialog(component, stringBuilder.toString(), I18n.tr("Plugin update failed", new Object[0]), 0, HelpUtil.ht("/Plugin/Loading#FailedPluginUpdated"));
    }

    private static Set<PluginInformation> findRequiredPluginsToDownload(Collection<PluginInformation> collection, List<PluginInformation> list, Set<PluginInformation> set) {
        HashSet<PluginInformation> hashSet = new HashSet<PluginInformation>();
        for (PluginInformation pluginInformation : collection) {
            for (String string : pluginInformation.getRequiredPlugins()) {
                try {
                    PluginInformation pluginInformation2 = PluginInformation.findPlugin(string);
                    if (pluginInformation2 != null) continue;
                    PluginInformation pluginInformation3 = null;
                    for (PluginInformation pluginInformation4 : list) {
                        if (!pluginInformation4.getName().equals(string)) continue;
                        pluginInformation3 = pluginInformation4;
                        break;
                    }
                    if (pluginInformation3 == null || set.contains(pluginInformation3)) continue;
                    hashSet.add(pluginInformation3);
                }
                catch (PluginException pluginException) {
                    Main.warn(I18n.tr("Failed to find plugin {0}", string));
                    Main.error(pluginException);
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<PluginInformation> updatePlugins(Component component, Collection<PluginInformation> collection, ProgressMonitor progressMonitor, boolean bl) {
        List<PluginInformation> list;
        block17: {
            list = null;
            pluginDownloadTask = null;
            if (progressMonitor == null) {
                progressMonitor = NullProgressMonitor.INSTANCE;
            }
            try {
                HashSet<PluginInformation> hashSet;
                Object object;
                progressMonitor.beginTask("");
                ReadRemotePluginInformationTask readRemotePluginInformationTask = new ReadRemotePluginInformationTask(progressMonitor.createSubTaskMonitor(1, false), Main.pref.getOnlinePluginSites(), bl);
                readRemotePluginInformationTask.run();
                List<PluginInformation> list2 = null;
                try {
                    list2 = readRemotePluginInformationTask.getAvailablePlugins();
                    list = PluginHandler.buildListOfPluginsToLoad(component, progressMonitor.createSubTaskMonitor(1, false));
                    if (collection != null && !collection.isEmpty()) {
                        object = list.iterator();
                        while (object.hasNext()) {
                            hashSet = (PluginInformation)object.next();
                            boolean bl2 = false;
                            for (PluginInformation pluginInformation : collection) {
                                if (!((PluginInformation)((Object)hashSet)).name.equals(pluginInformation.name)) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            object.remove();
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    Main.warn(I18n.tr("Failed to download plugin information list", new Object[0]));
                    Main.error(runtimeException);
                }
                object = new ArrayList();
                for (PluginInformation pluginInformation : list) {
                    if (!pluginInformation.isUpdateRequired()) continue;
                    object.add(pluginInformation);
                }
                if (object.isEmpty()) break block17;
                hashSet = new HashSet<PluginInformation>((Collection<PluginInformation>)object);
                if (list2 != null) {
                    Set<PluginInformation> set = PluginHandler.findRequiredPluginsToDownload((Collection<PluginInformation>)object, list2, hashSet);
                    hashSet.addAll(set);
                    while (!set.isEmpty()) {
                        list.addAll(set);
                        set = PluginHandler.findRequiredPluginsToDownload(set, list2, hashSet);
                        hashSet.addAll(set);
                    }
                }
                pluginDownloadTask = new PluginDownloadTask(progressMonitor.createSubTaskMonitor(1, false), hashSet, I18n.tr("Update plugins", new Object[0]));
                try {
                    pluginDownloadTask.run();
                }
                catch (RuntimeException runtimeException) {
                    Main.error(runtimeException);
                    PluginHandler.alertFailedPluginUpdate(component, (Collection<PluginInformation>)object);
                    List<PluginInformation> list3 = list;
                    progressMonitor.finishTask();
                    return list3;
                }
                PluginHandler.refreshLocalUpdatedPluginInfo(pluginDownloadTask.getDownloadedPlugins());
                if (!pluginDownloadTask.getFailedPlugins().isEmpty()) {
                    PluginHandler.alertFailedPluginUpdate(component, pluginDownloadTask.getFailedPlugins());
                    List<PluginInformation> list4 = list;
                    return list4;
                }
            }
            finally {
                progressMonitor.finishTask();
            }
        }
        if (collection == null) {
            Main.pref.putInteger("pluginmanager.version", Version.getInstance().getVersion());
            Main.pref.put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        }
        return list;
    }

    public static boolean confirmDisablePlugin(Component component, String string, String string2) {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin", new Object[0]), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to delete the plugin ''{0}''", string2), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", string2), null)};
        return 0 == HelpAwareOptionPane.showOptionDialog(component, string, I18n.tr("Disable plugin", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], null);
    }

    public static Object getPlugin(String string) {
        for (PluginProxy pluginProxy : pluginList) {
            if (!pluginProxy.getPluginInformation().name.equals(string)) continue;
            return pluginProxy.plugin;
        }
        return null;
    }

    public static void addDownloadSelection(List<DownloadSelection> list) {
        for (PluginProxy pluginProxy : pluginList) {
            pluginProxy.addDownloadSelection(list);
        }
    }

    public static Collection<PreferenceSettingFactory> getPreferenceSetting() {
        ArrayList<PreferenceSettingFactory> arrayList = new ArrayList<PreferenceSettingFactory>();
        for (PluginProxy pluginProxy : pluginList) {
            arrayList.add(new PluginPreferenceFactory(pluginProxy));
        }
        return arrayList;
    }

    public static void installDownloadedPlugins(boolean bl) {
        File file = Main.pref.getPluginsDirectory();
        if (!(file.exists() && file.isDirectory() && file.canWrite())) {
            return;
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".jar.new");
            }
        });
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string = file2.getPath();
            File file3 = new File(string.substring(0, string.length() - 4));
            String string2 = file2.getName().substring(0, file2.getName().length() - 8);
            if (file3.exists() && !file3.delete() && bl) {
                Main.warn(I18n.tr("Failed to delete outdated plugin ''{0}''.", file3.toString()));
                Main.warn(I18n.tr("Failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", string2));
                continue;
            }
            try {
                new JarFile(file2).close();
            }
            catch (IOException iOException) {
                if (!bl) continue;
                Main.warn(I18n.tr("Failed to install plugin ''{0}'' from temporary download file ''{1}''. {2}", file3.toString(), file2.toString(), iOException.getLocalizedMessage()));
                continue;
            }
            if (file2.renameTo(file3) || !bl) continue;
            Main.warn(I18n.tr("Failed to install plugin ''{0}'' from temporary download file ''{1}''. Renaming failed.", file3.toString(), file2.toString()));
            Main.warn(I18n.tr("Failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", string2));
        }
    }

    public static boolean isValidJar(File file) {
        if (file != null && file.exists() && file.canRead()) {
            try {
                new JarFile(file).close();
            }
            catch (IOException iOException) {
                Main.warn(iOException);
                return false;
            }
            return true;
        }
        if (file != null) {
            Main.warn("Invalid jar file ''" + file + "'' (exists: " + file.exists() + ", canRead: " + file.canRead() + ')');
        }
        return false;
    }

    public static File findUpdatedJar(String string) {
        File file = Main.pref.getPluginsDirectory();
        File file2 = new File(file, string + ".jar.new");
        if (!PluginHandler.isValidJar(file2) && !PluginHandler.isValidJar(file2 = new File(file, string + ".jar"))) {
            return null;
        }
        return file2;
    }

    public static void refreshLocalUpdatedPluginInfo(Collection<PluginInformation> collection) {
        if (collection == null) {
            return;
        }
        for (PluginInformation pluginInformation : collection) {
            File file = PluginHandler.findUpdatedJar(pluginInformation.name);
            if (file == null) continue;
            try {
                pluginInformation.updateFromJar(new PluginInformation(file, pluginInformation.name));
            }
            catch (PluginException pluginException) {
                Main.error(pluginException);
            }
        }
    }

    private static int askUpdateDisableKeepPluginAfterException(PluginProxy pluginProxy) {
        final HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugin", new Object[0]), ImageProvider.get("dialogs", "refresh"), I18n.tr("Click to update the plugin ''{0}''", pluginProxy.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin", new Object[0]), ImageProvider.get("dialogs", "delete"), I18n.tr("Click to disable the plugin ''{0}''", pluginProxy.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to keep the plugin ''{0}''", pluginProxy.getPluginInformation().name), null)};
        final StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("<html>").append(I18n.tr("An unexpected exception occurred that may have come from the ''{0}'' plugin.", pluginProxy.getPluginInformation().name)).append("<br>");
        if (pluginProxy.getPluginInformation().author != null) {
            stringBuilder.append(I18n.tr("According to the information within the plugin, the author is {0}.", pluginProxy.getPluginInformation().author)).append("<br>");
        }
        stringBuilder.append(I18n.tr("Try updating to the newest version of this plugin before reporting a bug.", new Object[0])).append("</html>");
        try {
            FutureTask<Integer> futureTask = new FutureTask<Integer>(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return HelpAwareOptionPane.showOptionDialog(Main.parent, stringBuilder.toString(), I18n.tr("Update plugins", new Object[0]), 3, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/ErrorMessages#ErrorInPlugin"));
                }
            });
            GuiHelper.runInEDT(futureTask);
            return futureTask.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            Main.warn(exception);
            return -1;
        }
    }

    private static PluginProxy getPluginCausingException(Throwable throwable) {
        PluginProxy pluginProxy = null;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        for (PluginProxy pluginProxy2 : pluginList) {
            String string = pluginProxy2.getPluginInformation().className;
            string = string.substring(0, string.lastIndexOf(46));
            for (int i = 0; i < n; ++i) {
                if (!stackTraceElementArray[i].getClassName().startsWith(string)) continue;
                n = i;
                pluginProxy = pluginProxy2;
            }
        }
        return pluginProxy;
    }

    public static PluginDownloadTask updateOrdisablePluginAfterException(Throwable throwable) {
        PluginProxy pluginProxy = null;
        if (throwable instanceof PluginException) {
            pluginProxy = ((PluginException)throwable).plugin;
        }
        if (pluginProxy == null) {
            pluginProxy = PluginHandler.getPluginCausingException(throwable);
        }
        if (pluginProxy == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(Main.pref.getCollection("plugins", Collections.emptySet()));
        PluginInformation pluginInformation = pluginProxy.getPluginInformation();
        if (!hashSet.contains(pluginInformation.name)) {
            return null;
        }
        switch (PluginHandler.askUpdateDisableKeepPluginAfterException(pluginProxy)) {
            case 0: {
                PluginHandler.updatePlugins(Main.parent, Collections.singleton(pluginInformation), null, true);
                return pluginDownloadTask;
            }
            case 1: {
                hashSet.remove(pluginProxy.getPluginInformation().name);
                Main.pref.putCollection("plugins", hashSet);
                GuiHelper.runInEDTAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("The plugin has been removed from the configuration. Please restart JOSM to unload the plugin.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    }
                });
                return null;
            }
        }
        return null;
    }

    public static String getBugReportText() {
        StringBuilder stringBuilder = new StringBuilder();
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection("plugins", new LinkedList<String>()));
        for (PluginProxy object : pluginList) {
            PluginInformation pluginInformation = object.getPluginInformation();
            linkedList.remove(pluginInformation.name);
            linkedList.add(pluginInformation.name + " (" + (pluginInformation.localversion != null && !pluginInformation.localversion.isEmpty() ? pluginInformation.localversion : "unknown") + ')');
        }
        Collections.sort(linkedList);
        if (!linkedList.isEmpty()) {
            stringBuilder.append("Plugins:\n");
        }
        for (String string : linkedList) {
            stringBuilder.append("- ").append(string).append('\n');
        }
        return stringBuilder.toString();
    }

    public static JPanel getInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (PluginProxy pluginProxy : pluginList) {
            final PluginInformation pluginInformation = pluginProxy.getPluginInformation();
            String string = pluginInformation.name + (pluginInformation.version != null && !pluginInformation.version.isEmpty() ? " Version: " + pluginInformation.version : "");
            jPanel.add((Component)new JLabel(string), GBC.std());
            jPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            jPanel.add((Component)new JButton(new AbstractAction(I18n.tr("Information", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry<String, String> entry : pluginInformation.attr.entrySet()) {
                        stringBuilder.append(entry.getKey());
                        stringBuilder.append(": ");
                        stringBuilder.append(entry.getValue());
                        stringBuilder.append('\n');
                    }
                    JosmTextArea josmTextArea = new JosmTextArea(10, 40);
                    josmTextArea.setEditable(false);
                    josmTextArea.setText(stringBuilder.toString());
                    josmTextArea.setCaretPosition(0);
                    JOptionPane.showMessageDialog(Main.parent, new JScrollPane(josmTextArea), I18n.tr("Plugin information", new Object[0]), 1);
                }
            }), GBC.eol());
            JosmTextArea josmTextArea = new JosmTextArea(pluginInformation.description == null ? I18n.tr("no description available", new Object[0]) : pluginInformation.description);
            josmTextArea.setEditable(false);
            josmTextArea.setFont(new JLabel().getFont().deriveFont(2));
            josmTextArea.setLineWrap(true);
            josmTextArea.setWrapStyleWord(true);
            josmTextArea.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            josmTextArea.setBackground(UIManager.getColor("Panel.background"));
            josmTextArea.setCaretPosition(0);
            jPanel.add((Component)josmTextArea, GBC.eop().fill(2));
        }
        return jPanel;
    }

    public static Set<String> getDeprecatedAndUnmaintainedPlugins() {
        HashSet<String> hashSet = new HashSet<String>(DEPRECATED_PLUGINS.size() + UNMAINTAINED_PLUGINS.size());
        for (DeprecatedPlugin deprecatedPlugin : DEPRECATED_PLUGINS) {
            hashSet.add(deprecatedPlugin.name);
        }
        hashSet.addAll(UNMAINTAINED_PLUGINS);
        return hashSet;
    }

    static {
        String string = I18n.tr("integrated into main program", new Object[0]);
        DEPRECATED_PLUGINS = Arrays.asList(new DeprecatedPlugin("mappaint", string), new DeprecatedPlugin("unglueplugin", string), new DeprecatedPlugin("lang-de", string), new DeprecatedPlugin("lang-en_GB", string), new DeprecatedPlugin("lang-fr", string), new DeprecatedPlugin("lang-it", string), new DeprecatedPlugin("lang-pl", string), new DeprecatedPlugin("lang-ro", string), new DeprecatedPlugin("lang-ru", string), new DeprecatedPlugin("ewmsplugin", string), new DeprecatedPlugin("ywms", string), new DeprecatedPlugin("tways-0.2", string), new DeprecatedPlugin("geotagged", string), new DeprecatedPlugin("landsat", I18n.tr("replaced by new {0} plugin", "lakewalker")), new DeprecatedPlugin("namefinder", string), new DeprecatedPlugin("waypoints", string), new DeprecatedPlugin("slippy_map_chooser", string), new DeprecatedPlugin("tcx-support", I18n.tr("replaced by new {0} plugin", "dataimport")), new DeprecatedPlugin("usertools", string), new DeprecatedPlugin("AgPifoJ", string), new DeprecatedPlugin("utilsplugin", string), new DeprecatedPlugin("ghost", string), new DeprecatedPlugin("validator", string), new DeprecatedPlugin("multipoly", string), new DeprecatedPlugin("multipoly-convert", string), new DeprecatedPlugin("remotecontrol", string), new DeprecatedPlugin("imagery", string), new DeprecatedPlugin("slippymap", string), new DeprecatedPlugin("wmsplugin", string), new DeprecatedPlugin("ParallelWay", string), new DeprecatedPlugin("dumbutils", I18n.tr("replaced by new {0} plugin", "utilsplugin2")), new DeprecatedPlugin("ImproveWayAccuracy", string), new DeprecatedPlugin("Curves", I18n.tr("replaced by new {0} plugin", "utilsplugin2")), new DeprecatedPlugin("epsg31287", I18n.tr("replaced by new {0} plugin", "proj4j")), new DeprecatedPlugin("licensechange", I18n.tr("no longer required", new Object[0])), new DeprecatedPlugin("restart", string), new DeprecatedPlugin("wayselector", string), new DeprecatedPlugin("openstreetbugs", I18n.tr("replaced by new {0} plugin", "notes")), new DeprecatedPlugin("nearclick", I18n.tr("no longer required", new Object[0])), new DeprecatedPlugin("notes", string), new DeprecatedPlugin("mirrored_download", string), new DeprecatedPlugin("ImageryCache", string), new DeprecatedPlugin("commons-imaging", I18n.tr("replaced by new {0} plugin", "apache-commons")), new DeprecatedPlugin("missingRoads", I18n.tr("replaced by new {0} plugin", "ImproveOsm")), new DeprecatedPlugin("trafficFlowDirection", I18n.tr("replaced by new {0} plugin", "ImproveOsm")), new DeprecatedPlugin("kendzi3d-jogl", I18n.tr("replaced by new {0} plugin", "jogl")));
        UNMAINTAINED_PLUGINS = Collections.unmodifiableList(Arrays.asList("gpsbabelgui", "Intersect_way", "ContourOverlappingMerge", "LaneConnector", "Remove.redundant.points"));
        pluginList = new LinkedList<PluginProxy>();
        pluginLoadingExceptions = new HashMap<String, Exception>();
        sources = new LinkedList<ClassLoader>();
        try {
            sources.add(ClassLoader.getSystemClassLoader());
            sources.add(MainApplication.class.getClassLoader());
        }
        catch (SecurityException securityException) {
            sources.add(ImageProvider.class.getClassLoader());
        }
    }

    private static class UpdatePluginsMessagePanel
    extends JPanel {
        private final JMultilineLabel lblMessage = new JMultilineLabel("");
        private final JCheckBox cbDontShowAgain = new JCheckBox(I18n.tr("Do not ask again and remember my decision (go to Preferences->Plugins to change it later)", new Object[0]));

        UpdatePluginsMessagePanel() {
            this.build();
        }

        protected final void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.lblMessage, gridBagConstraints);
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            this.add((Component)this.cbDontShowAgain, gridBagConstraints);
            this.cbDontShowAgain.setFont(this.cbDontShowAgain.getFont().deriveFont(0));
        }

        public void setMessage(String string) {
            this.lblMessage.setText(string);
        }

        public void initDontShowAgain(String string) {
            String string2 = Main.pref.get(string, "ask");
            this.cbDontShowAgain.setSelected(!"ask".equals(string2 = string2.trim().toLowerCase(Locale.ENGLISH)));
        }

        public boolean isRememberDecision() {
            return this.cbDontShowAgain.isSelected();
        }
    }

    public static class DynamicURLClassLoader
    extends URLClassLoader {
        public DynamicURLClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        @Override
        public void addURL(URL uRL) {
            super.addURL(uRL);
        }
    }

    public static class DeprecatedPlugin
    implements Comparable<DeprecatedPlugin> {
        public final String name;
        public final String reason;

        public DeprecatedPlugin(String string, String string2) {
            this.name = string;
            this.reason = string2;
        }

        public int hashCode() {
            int n = 31 + (this.name == null ? 0 : this.name.hashCode());
            return 31 * n + (this.reason == null ? 0 : this.reason.hashCode());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DeprecatedPlugin deprecatedPlugin = (DeprecatedPlugin)object;
            if (this.name == null ? deprecatedPlugin.name != null : !this.name.equals(deprecatedPlugin.name)) {
                return false;
            }
            return !(this.reason == null ? deprecatedPlugin.reason != null : !this.reason.equals(deprecatedPlugin.reason));
        }

        @Override
        public int compareTo(DeprecatedPlugin deprecatedPlugin) {
            int n = this.name.compareTo(deprecatedPlugin.name);
            if (n == 0) {
                n = this.reason.compareTo(deprecatedPlugin.reason);
            }
            return n;
        }
    }
}

