/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddFromSelectionAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public class PasteMembersAction
extends AddFromSelectionAction {
    public PasteMembersAction(MemberTableModel memberTableModel, OsmDataLayer osmDataLayer, IRelationEditor iRelationEditor) {
        super(null, memberTableModel, null, null, null, osmDataLayer, iRelationEditor);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            List<PrimitiveData> list = Main.pasteBuffer.getDirectlyAdded();
            DataSet dataSet = this.layer.data;
            List<OsmPrimitive> list2 = new ArrayList<OsmPrimitive>();
            boolean bl = false;
            for (PrimitiveData primitiveData : list) {
                OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(primitiveData);
                if (osmPrimitive != null) {
                    list2.add(osmPrimitive);
                    continue;
                }
                if (!primitiveData.isNew()) {
                    OsmPrimitive osmPrimitive2 = primitiveData.getType().newInstance(primitiveData.getUniqueId(), true);
                    dataSet.addPrimitive(osmPrimitive2);
                    list2.add(osmPrimitive2);
                    continue;
                }
                bl = true;
                break;
            }
            if (bl) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Members from paste buffer cannot be added because they are not included in current layer", new Object[0]));
                return;
            }
            list2 = this.filterConfirmedPrimitives(list2);
            int n = this.memberTableModel.getSelectionModel().getMaxSelectionIndex();
            if (n == -1) {
                n = this.memberTableModel.getRowCount() - 1;
            }
            this.memberTableModel.addMembersAfterIdx(list2, n);
        }
        catch (GenericRelationEditor.AddAbortException addAbortException) {
            Main.trace(addAbortException);
        }
    }

    @Override
    protected void updateEnabledState() {
    }
}

