/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class ChangesetCacheManagerModel
extends AbstractTableModel
implements ChangesetCacheListener {
    public static final String CHANGESET_IN_DETAIL_VIEW_PROP = ChangesetCacheManagerModel.class.getName() + ".changesetInDetailView";
    private final transient List<Changeset> data = new ArrayList<Changeset>();
    private final DefaultListSelectionModel selectionModel;
    private transient Changeset changesetInDetailView;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public ChangesetCacheManagerModel(DefaultListSelectionModel defaultListSelectionModel) {
        this.selectionModel = defaultListSelectionModel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setChangesetInDetailView(Changeset changeset) {
        Changeset changeset2 = this.changesetInDetailView;
        this.changesetInDetailView = changeset;
        if (changeset2 != changeset) {
            this.support.firePropertyChange(CHANGESET_IN_DETAIL_VIEW_PROP, changeset2, this.changesetInDetailView);
        }
    }

    public boolean hasSelectedChangesets() {
        return this.selectionModel.getMinSelectionIndex() >= 0;
    }

    public List<Changeset> getSelectedChangesets() {
        ArrayList<Changeset> arrayList = new ArrayList<Changeset>();
        for (int i = 0; i < this.data.size(); ++i) {
            Changeset changeset = this.data.get(i);
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            arrayList.add(changeset);
        }
        return arrayList;
    }

    public Set<Integer> getSelectedChangesetIds() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Changeset changeset : this.getSelectedChangesets()) {
            hashSet.add(changeset.getId());
        }
        return hashSet;
    }

    public void setSelectedChangesets(Collection<Changeset> collection) {
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                ChangesetCacheManagerModel.this.selectionModel.clearSelection();
            }
        });
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (Changeset changeset : collection) {
            final int n = this.data.indexOf(changeset);
            if (n < 0) continue;
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    ChangesetCacheManagerModel.this.selectionModel.addSelectionInterval(n, n);
                }
            });
        }
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data.get(n);
    }

    public void init() {
        ChangesetCache changesetCache = ChangesetCache.getInstance();
        List<Changeset> list = this.getSelectedChangesets();
        this.data.clear();
        this.data.addAll(changesetCache.getChangesets());
        this.sort();
        this.fireTableDataChanged();
        this.setSelectedChangesets(list);
        changesetCache.addChangesetCacheListener(this);
    }

    public void tearDown() {
        ChangesetCache.getInstance().removeChangesetCacheListener(this);
    }

    public DefaultListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void sort() {
        Collections.sort(this.data, new Comparator<Changeset>(){

            @Override
            public int compare(Changeset changeset, Changeset changeset2) {
                if (changeset.getId() < changeset2.getId()) {
                    return 1;
                }
                if (changeset.getId() == changeset2.getId()) {
                    return 0;
                }
                return -1;
            }
        });
    }

    @Override
    public void changesetCacheUpdated(ChangesetCacheEvent changesetCacheEvent) {
        List<Changeset> list = this.getSelectedChangesets();
        for (Changeset changeset : changesetCacheEvent.getAddedChangesets()) {
            this.data.add(changeset);
        }
        for (Changeset changeset : changesetCacheEvent.getRemovedChangesets()) {
            this.data.remove(changeset);
        }
        for (Changeset changeset : changesetCacheEvent.getUpdatedChangesets()) {
            Changeset changeset2;
            int n = this.data.indexOf(changeset);
            if (n < 0 || (changeset2 = this.data.get(n)) == changeset) continue;
            changeset2.mergeFrom(changeset);
        }
        this.sort();
        this.fireTableDataChanged();
        this.setSelectedChangesets(list);
    }
}

