/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class DownloadSelectedIncompleteMembersAction
extends AbstractRelationAction {
    private transient Collection<OsmPrimitive> incompleteMembers;

    public DownloadSelectedIncompleteMembersAction() {
        this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
        this.putValue("Name", I18n.tr("Download incomplete members", new Object[0]));
    }

    public static Set<OsmPrimitive> buildSetOfIncompleteMembers(Collection<Relation> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Relation relation : collection) {
            hashSet.addAll(Utils.filter(relation.getIncompleteMembers(), new Predicate<OsmPrimitive>(){

                @Override
                public boolean evaluate(OsmPrimitive osmPrimitive) {
                    return !osmPrimitive.isNew();
                }
            }));
        }
        return hashSet;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || this.relations.isEmpty() || !Main.isDisplayingMapView()) {
            return;
        }
        Main.worker.submit(new DownloadRelationMemberTask(this.relations, this.incompleteMembers, Main.getLayerManager().getEditLayer()));
    }

    @Override
    public void setPrimitives(Collection<? extends OsmPrimitive> collection) {
        this.relations = Utils.filter(DownloadSelectedIncompleteMembersAction.getRelations(collection), new Predicate<Relation>(){

            @Override
            public boolean evaluate(Relation relation) {
                return relation.hasIncompleteMembers();
            }
        });
        this.incompleteMembers = DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(this.relations);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.relations.isEmpty() && !this.incompleteMembers.isEmpty() && !Main.isOffline(OnlineResource.OSM_API));
    }
}

