/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;

public class TagDescriptor<T extends Directory> {
    @NotNull
    protected final T _directory;

    public TagDescriptor(@NotNull T t) {
        this._directory = t;
    }

    @Nullable
    public String getDescription(int n) {
        int n2;
        Object object = ((Directory)this._directory).getObject(n);
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray() && (n2 = Array.getLength(object)) > 16) {
            String string = object.getClass().getComponentType().getName();
            return String.format("[%d %s%s]", n2, string, n2 == 1 ? "" : "s");
        }
        return ((Directory)this._directory).getString(n);
    }

    @Nullable
    public static String convertBytesToVersionString(@Nullable int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4 && i < nArray.length; ++i) {
            char c;
            if (i == n) {
                stringBuilder.append('.');
            }
            if ((c = (char)nArray[i]) < '0') {
                c = (char)(c + 48);
            }
            if (i == 0 && c == '0') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Nullable
    protected String getVersionBytesDescription(int n, int n2) {
        int[] nArray = ((Directory)this._directory).getIntArray(n);
        return nArray == null ? null : TagDescriptor.convertBytesToVersionString(nArray, n2);
    }

    @Nullable
    protected String getIndexedDescription(int n, String ... stringArray) {
        return this.getIndexedDescription(n, 0, stringArray);
    }

    @Nullable
    protected String getIndexedDescription(int n, int n2, String ... stringArray) {
        String string;
        Integer n3 = ((Directory)this._directory).getInteger(n);
        if (n3 == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 >= 0 && n4 < stringArray.length && (string = stringArray[n4]) != null) {
            return string;
        }
        return "Unknown (" + n3 + ")";
    }

    @Nullable
    protected String getByteLengthDescription(int n) {
        byte[] byArray = ((Directory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        return String.format("(%d byte%s)", byArray.length, byArray.length == 1 ? "" : "s");
    }

    @Nullable
    protected String getSimpleRational(int n) {
        Rational rational = ((Directory)this._directory).getRational(n);
        if (rational == null) {
            return null;
        }
        return rational.toSimpleString(true);
    }

    @Nullable
    protected String getDecimalRational(int n, int n2) {
        Rational rational = ((Directory)this._directory).getRational(n);
        if (rational == null) {
            return null;
        }
        return String.format("%." + n2 + "f", rational.doubleValue());
    }

    @Nullable
    protected String getFormattedInt(int n, @NotNull String string) {
        Integer n2 = ((Directory)this._directory).getInteger(n);
        if (n2 == null) {
            return null;
        }
        return String.format(string, n2);
    }

    @Nullable
    protected String getFormattedFloat(int n, @NotNull String string) {
        Float f = ((Directory)this._directory).getFloatObject(n);
        if (f == null) {
            return null;
        }
        return String.format(string, f);
    }

    @Nullable
    protected String getFormattedString(int n, @NotNull String string) {
        String string2 = ((Directory)this._directory).getString(n);
        if (string2 == null) {
            return null;
        }
        return String.format(string, string2);
    }

    @Nullable
    protected String getEpochTimeDescription(int n) {
        Long l = ((Directory)this._directory).getLongObject(n);
        if (l == null) {
            return null;
        }
        return new Date(l).toString();
    }

    @Nullable
    protected String getBitFlagDescription(int n, Object ... objectArray) {
        Integer n2 = ((Directory)this._directory).getInteger(n);
        if (n2 == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; objectArray.length > i; ++i) {
            Object object = objectArray[i];
            if (object != null) {
                boolean bl;
                boolean bl2 = bl = (n2 & 1) == 1;
                if (object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    assert (stringArray.length == 2);
                    arrayList.add(stringArray[bl ? 1 : 0]);
                } else if (bl && object instanceof String) {
                    arrayList.add((String)object);
                }
            }
            n2 = n2 >> 1;
        }
        return StringUtil.join(arrayList, ", ");
    }

    @Nullable
    protected String get7BitStringFromBytes(int n) {
        byte[] byArray = ((Directory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = byArray[i] & 0xFF;
            if (n3 != 0 && n3 <= 127) continue;
            n2 = i;
            break;
        }
        return new String(byArray, 0, n2);
    }

    @Nullable
    protected String getAsciiStringFromBytes(int n) {
        byte[] byArray = ((Directory)this._directory).getByteArray(n);
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "ASCII").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

