/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicReference<V>
implements Serializable {
    private static final long serialVersionUID = -1848883965231344442L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final long valueOffset;
    private volatile V value;

    public AtomicReference(V v) {
        this.value = v;
    }

    public AtomicReference() {
    }

    public final V get() {
        return this.value;
    }

    public final void set(V v) {
        this.value = v;
    }

    public final void lazySet(V v) {
        unsafe.putOrderedObject(this, valueOffset, v);
    }

    public final boolean compareAndSet(V v, V v2) {
        return unsafe.compareAndSwapObject(this, valueOffset, v, v2);
    }

    public final boolean weakCompareAndSet(V v, V v2) {
        return unsafe.compareAndSwapObject(this, valueOffset, v, v2);
    }

    public final V getAndSet(V v) {
        V v2;
        while (!this.compareAndSet(v2 = this.get(), v)) {
        }
        return v2;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    static {
        try {
            valueOffset = unsafe.objectFieldOffset(AtomicReference.class.getDeclaredField("value"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

