/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLPlainTextImpl
extends YAMLScalarImpl
implements YAMLScalar {
    public YAMLPlainTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        int myStart = this.getTextOffset();
        ASTNode node = this.getNode();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        boolean seenText = false;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == YAMLTokenTypes.TEXT) {
                seenText = true;
                result.add(child.getTextRange().shiftRight(-myStart));
                continue;
            }
            if (child.getElementType() != YAMLTokenTypes.EOL) continue;
            if (!seenText) {
                result.add(child.getTextRange().shiftRight(-myStart));
            }
            seenText = false;
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getContentRanges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence leftString, @NotNull CharSequence rightString) {
        if (leftString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftString", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getRangesJoiner"));
        }
        if (rightString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightString", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getRangesJoiner"));
        }
        if (leftString.equals("\n") || rightString.equals("\n")) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getRangesJoiner"));
            }
            return "";
        }
        if (" " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLPlainTextImpl", "getRangesJoiner"));
        }
        return " ";
    }

    @Override
    public String toString() {
        return "YAML plain scalar text";
    }

    @Override
    public boolean isMultiline() {
        return this.getNode().findChildByType((IElementType)YAMLTokenTypes.EOL) != null;
    }
}

