/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.impl.YAMLCompoundValueImpl;

public abstract class YAMLMappingImpl
extends YAMLCompoundValueImpl
implements YAMLMapping {
    public YAMLMappingImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLMappingImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public Collection<YAMLKeyValue> getKeyValues() {
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, YAMLKeyValue.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLMappingImpl", "getKeyValues"));
        }
        return list;
    }

    @Override
    @Nullable
    public YAMLKeyValue getKeyValueByKey(@NotNull String keyText) {
        if (keyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyText", "org/jetbrains/yaml/psi/impl/YAMLMappingImpl", "getKeyValueByKey"));
        }
        for (YAMLKeyValue keyValue : this.getKeyValues()) {
            if (!keyText.equals(keyValue.getKeyText())) continue;
            return keyValue;
        }
        return null;
    }

    @Override
    public void putKeyValue(@NotNull YAMLKeyValue keyValueToAdd) {
        if (keyValueToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyValueToAdd", "org/jetbrains/yaml/psi/impl/YAMLMappingImpl", "putKeyValue"));
        }
        YAMLKeyValue existingKey = this.getKeyValueByKey(keyValueToAdd.getKeyText());
        if (existingKey == null) {
            this.addNewKey(keyValueToAdd);
        } else {
            existingKey.replace((PsiElement)keyValueToAdd);
        }
    }

    @Override
    public void deleteKeyValue(@NotNull YAMLKeyValue keyValueToDelete) {
        if (keyValueToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyValueToDelete", "org/jetbrains/yaml/psi/impl/YAMLMappingImpl", "deleteKeyValue"));
        }
        if (keyValueToDelete.getParent() != this) {
            throw new IllegalArgumentException("KeyValue should be the child of this");
        }
        if (keyValueToDelete.getPrevSibling() != null) {
            while (keyValueToDelete.getPrevSibling() != null && !(keyValueToDelete.getPrevSibling() instanceof YAMLKeyValue)) {
                keyValueToDelete.getPrevSibling().delete();
            }
        } else {
            while (keyValueToDelete.getNextSibling() != null && !(keyValueToDelete.getNextSibling() instanceof YAMLKeyValue)) {
                keyValueToDelete.getNextSibling().delete();
            }
        }
        keyValueToDelete.delete();
    }

    protected abstract void addNewKey(@NotNull YAMLKeyValue var1);

    @Override
    public String toString() {
        return "YAML mapping";
    }

    @Override
    @NotNull
    public String getTextValue() {
        String string = "<mapping:" + Integer.toHexString(this.getText().hashCode()) + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLMappingImpl", "getTextValue"));
        }
        return string;
    }
}

