/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.componentTree;

import com.android.tools.idea.rendering.IncludeReference;
import com.android.tools.lint.detector.api.LintUtils;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.designer.componentTree.AttributeWrapper;
import com.intellij.designer.componentTree.TreeComponentDecorator;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.IComponentDecorator;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public final class AndroidTreeDecorator
implements TreeComponentDecorator {
    @Nullable
    private final Project myProject;

    public AndroidTreeDecorator(@Nullable Project project) {
        this.myProject = project;
    }

    public void decorate(RadComponent component, SimpleColoredComponent renderer, AttributeWrapper wrapper, boolean full) {
        ViewsMetaManager metaManager;
        MetaModel classModel;
        String cls;
        RadViewComponent rvc;
        XmlAttribute attribute;
        MetaModel metaModel = component.getMetaModel();
        String tag = metaModel.getTag();
        if ("view".equals(tag) && component instanceof RadViewComponent && (attribute = (rvc = (RadViewComponent)component).getTag().getAttribute("class")) != null && !StringUtil.isEmpty((String)(cls = attribute.getValue())) && this.myProject != null && (classModel = (metaManager = ViewsMetaManager.getInstance(this.myProject)).getModelByTarget(cls)) != null) {
            metaModel = classModel;
        }
        this.decorate(component, metaModel, renderer, wrapper, full);
    }

    private void decorate(RadComponent component, MetaModel metaModel, SimpleColoredComponent renderer, AttributeWrapper wrapper, boolean full) {
        int end;
        int start;
        IncludeReference includeContext;
        String id = component.getPropertyValue("id");
        id = LintUtils.stripIdPrefix((String)id);
        id = StringUtil.nullize((String)id);
        PaletteItem item = metaModel.getPaletteItem();
        String type = null;
        String tagName = metaModel.getTag();
        if (item != null) {
            type = item.getTitle();
            if (tagName.equals("include") || tagName.equals("merge") || tagName.equals("fragment") || tagName.equals("requestFocus")) {
                type = null;
            }
        }
        if (id != null) {
            SimpleTextAttributes idStyle = wrapper.getAttribute(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            renderer.append(id, idStyle);
        }
        if (id == null && type == null) {
            type = tagName;
        }
        if ("<root>".equals(tagName) && (includeContext = (IncludeReference)component.getClientProperty("showIn")) != null && includeContext != IncludeReference.NONE) {
            type = "Shown in " + includeContext.getFromResourceUrl();
        }
        if (!(type == null || id != null && StringUtil.startsWithIgnoreCase((String)id, (String)type))) {
            SimpleTextAttributes typeStyle = wrapper.getAttribute(SimpleTextAttributes.REGULAR_ATTRIBUTES);
            renderer.append(id != null ? String.format(" (%1$s)", type) : type, typeStyle);
        }
        StringBuilder fullTitle = new StringBuilder();
        String title = metaModel.getTitle();
        if (title != null && (start = title.indexOf(37)) != -1 && (end = title.indexOf(37, start + 1)) != -1) {
            String variable = title.substring(start + 1, end);
            Object value = component.getPropertyValue(variable);
            if (!StringUtil.isEmpty((String)value)) {
                value = StringUtil.shortenTextWithEllipsis((String)value, (int)30, (int)5);
            }
            if (!StringUtil.isEmpty((String)value)) {
                String prefix = title.substring(0, start);
                String suffix = title.substring(end + 1);
                if ((((String)value).startsWith("@") || ((String)value).startsWith("?")) && prefix.length() > 0 && suffix.length() > 0 && prefix.charAt(prefix.length() - 1) == '\"' && suffix.charAt(0) == '\"') {
                    prefix = prefix.substring(0, prefix.length() - 1);
                    suffix = suffix.substring(1);
                }
                fullTitle.append(prefix).append((String)value).append(suffix);
            }
        }
        if (fullTitle.length() > 0) {
            SimpleTextAttributes valueStyle = wrapper.getAttribute(SimpleTextAttributes.GRAY_ATTRIBUTES);
            renderer.append(fullTitle.toString(), valueStyle);
        }
        if (full) {
            Icon icon = metaModel.getIcon();
            HighlightDisplayLevel displayLevel = null;
            if (this.myProject != null) {
                LayeredIcon layeredIcon;
                SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar((Project)this.myProject);
                for (ErrorInfo errorInfo : RadComponent.getError((RadComponent)component)) {
                    if (displayLevel != null && severityRegistrar.compare(errorInfo.getLevel().getSeverity(), displayLevel.getSeverity()) <= 0) continue;
                    displayLevel = errorInfo.getLevel();
                }
                if (displayLevel == HighlightDisplayLevel.ERROR) {
                    layeredIcon = new LayeredIcon(2);
                    layeredIcon.setIcon(icon, 0);
                    layeredIcon.setIcon(AndroidIcons.ErrorBadge, 1, 10, 10);
                    icon = layeredIcon;
                } else if (displayLevel == HighlightDisplayLevel.WARNING || displayLevel == HighlightDisplayLevel.WEAK_WARNING) {
                    layeredIcon = new LayeredIcon(2);
                    layeredIcon.setIcon(icon, 0);
                    layeredIcon.setIcon(AndroidIcons.WarningBadge, 1, 10, 10);
                    icon = layeredIcon;
                }
            }
            renderer.setIcon(icon);
            if (component instanceof IComponentDecorator) {
                ((IComponentDecorator)component).decorateTree(renderer, wrapper);
            }
        }
    }
}

