/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.config.JdkDetection;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.wizard.JdkLocationStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class SetupJdkPath
extends DynamicWizardPath {
    private static ScopedStateStore.Key<String> KEY_JDK_LOCATION = ScopedStateStore.createKey("jdk.location", ScopedStateStore.Scope.PATH, String.class);
    @NotNull
    private final FirstRunWizardMode myMode;
    private boolean myHasCompatibleJdk;
    private JdkLocationStep myJdkLocationStep;

    public SetupJdkPath(@NotNull FirstRunWizardMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/wizard/SetupJdkPath", "<init>"));
        }
        this.myMode = mode;
        this.myJdkLocationStep = new JdkLocationStep(KEY_JDK_LOCATION, this.myMode);
    }

    @Override
    public boolean isPathVisible() {
        return !this.myHasCompatibleJdk;
    }

    @Override
    protected void init() {
        Sdk jdk;
        if (this.myHasCompatibleJdk) {
            return;
        }
        String path = null;
        File javaDir = this.myMode.getJavaDir();
        if (javaDir != null) {
            path = javaDir.getAbsolutePath();
        }
        if (StringUtil.isEmpty(path) && (jdk = IdeSdks.getJdk(FirstRunWizardDefaults.MIN_JDK_VERSION)) != null) {
            path = jdk.getHomePath();
        }
        if (StringUtil.isEmpty((String)path)) {
            final StringBuilder result = new StringBuilder();
            JdkDetection.start(new JdkDetection.JdkDetectionResult(){

                @Override
                public void onSuccess(String newJdkPath) {
                    result.append(newJdkPath);
                }

                @Override
                public void onCancel() {
                }
            });
            path = result.toString();
        }
        if (StringUtil.isEmpty((String)path) || JdkDetection.validateJdkLocation(new File(path)) != null) {
            this.addStep(this.myJdkLocationStep);
        } else {
            this.myState.put(KEY_JDK_LOCATION, path);
            this.myHasCompatibleJdk = true;
        }
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Setup JDK" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/SetupJdkPath", "getPathName"));
        }
        return "Setup JDK";
    }

    @Override
    public boolean performFinishingActions() {
        final String path = this.myState.get(KEY_JDK_LOCATION);
        assert (path != null);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                IdeSdks.setJdkPath(new File(path));
            }
        });
        return true;
    }

    public boolean showsStep() {
        return this.isPathVisible() && this.myJdkLocationStep.isStepVisible();
    }
}

