/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.core;

import com.android.tools.idea.ui.properties.ObservableProperty;
import com.google.common.base.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalProperty<T>
extends ObservableProperty<Optional<T>> {
    @NotNull
    private Optional<T> myOptional;

    public static <T> OptionalProperty<T> of(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/core/OptionalProperty", "of"));
        }
        return new OptionalProperty<T>(value);
    }

    public static <T> OptionalProperty<T> absent() {
        return new OptionalProperty<T>();
    }

    public OptionalProperty() {
        this.myOptional = Optional.absent();
    }

    public OptionalProperty(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/core/OptionalProperty", "<init>"));
        }
        this.myOptional = Optional.of(value);
    }

    @Override
    @NotNull
    public Optional<T> get() {
        Optional<T> optional = this.myOptional;
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/core/OptionalProperty", "get"));
        }
        return optional;
    }

    @NotNull
    public T getValue() {
        Object object = this.myOptional.get();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/core/OptionalProperty", "getValue"));
        }
        return (T)object;
    }

    public void setValue(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/core/OptionalProperty", "setValue"));
        }
        if (!this.myOptional.isPresent() || !this.myOptional.get().equals(value)) {
            this.set(Optional.of(value));
        }
    }

    public void clear() {
        if (this.myOptional.isPresent()) {
            this.set(Optional.absent());
        }
    }

    @NotNull
    public T getValueOr(@NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/android/tools/idea/ui/properties/core/OptionalProperty", "getValueOr"));
        }
        Object object = this.myOptional.or(defaultValue);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/core/OptionalProperty", "getValueOr"));
        }
        return (T)object;
    }

    @Nullable
    public T getValueOrNull() {
        return (T)this.myOptional.orNull();
    }

    public boolean isPresent() {
        return this.myOptional.isPresent();
    }

    @Override
    protected void setDirectly(@NotNull Optional<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/core/OptionalProperty", "setDirectly"));
        }
        this.myOptional = value;
    }
}

