/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.FmActivityToLayoutMethod;
import com.android.tools.idea.templates.FmCamelCaseToUnderscoreMethod;
import com.android.tools.idea.templates.FmClassNameToResourceMethod;
import com.android.tools.idea.templates.FmCompareVersionsMethod;
import com.android.tools.idea.templates.FmEscapePropertyValueMethod;
import com.android.tools.idea.templates.FmEscapeXmlAttributeMethod;
import com.android.tools.idea.templates.FmEscapeXmlStringMethod;
import com.android.tools.idea.templates.FmExtractLettersMethod;
import com.android.tools.idea.templates.FmGetAppManifestDirMethod;
import com.android.tools.idea.templates.FmGetApplicationThemeMethod;
import com.android.tools.idea.templates.FmHasDependencyMethod;
import com.android.tools.idea.templates.FmLayoutToActivityMethod;
import com.android.tools.idea.templates.FmSlashedPackageNameMethod;
import com.android.tools.idea.templates.FmTruncateStringMethod;
import com.android.tools.idea.templates.FmUnderscoreToCamelCaseMethod;
import com.android.tools.idea.templates.StudioTemplateLoader;
import com.android.tools.idea.templates.recipe.RenderingContext;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FreemarkerUtils {
    @NotNull
    public static Map<String, Object> createParameterMap(@NotNull Map<String, Object> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/android/tools/idea/templates/FreemarkerUtils", "createParameterMap"));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("slashedPackageName", new FmSlashedPackageNameMethod());
        paramMap.put("camelCaseToUnderscore", new FmCamelCaseToUnderscoreMethod());
        paramMap.put("underscoreToCamelCase", new FmUnderscoreToCamelCaseMethod());
        paramMap.put("activityToLayout", new FmActivityToLayoutMethod());
        paramMap.put("layoutToActivity", new FmLayoutToActivityMethod());
        paramMap.put("classToResource", new FmClassNameToResourceMethod());
        paramMap.put("escapeXmlAttribute", new FmEscapeXmlAttributeMethod());
        paramMap.put("escapeXmlText", new FmEscapeXmlStringMethod());
        paramMap.put("escapeXmlString", new FmEscapeXmlStringMethod());
        paramMap.put("escapePropertyValue", new FmEscapePropertyValueMethod());
        paramMap.put("extractLetters", new FmExtractLettersMethod());
        paramMap.put("hasDependency", new FmHasDependencyMethod(paramMap));
        paramMap.put("truncate", new FmTruncateStringMethod());
        paramMap.put("compareVersions", new FmCompareVersionsMethod());
        paramMap.put("getApplicationTheme", new FmGetApplicationThemeMethod(paramMap));
        paramMap.put("getAppManifestDir", new FmGetAppManifestDirMethod(paramMap));
        paramMap.put("dependencyList", new LinkedList());
        paramMap.putAll(args);
        HashMap<String, Object> hashMap = paramMap;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/FreemarkerUtils", "createParameterMap"));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String processFreemarkerTemplate(@NotNull RenderingContext context, @NotNull File file, @Nullable TemplatePostProcessor processor) throws TemplateProcessingException {
        String string;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/templates/FreemarkerUtils", "processFreemarkerTemplate"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/FreemarkerUtils", "processFreemarkerTemplate"));
        }
        try {
            StudioTemplateLoader loader = context.getLoader();
            String name = loader.findTemplate(file);
            Template template = context.getFreemarkerConfiguration().getTemplate(name);
            StringWriter out = new StringWriter();
            template.process(context.getParamMap(), (Writer)out);
            out.flush();
            String content = out.toString().replace("\r", "");
            if (processor != null) {
                try {
                    loader.pushTemplateFolder(loader.getSourceFile(file).getParentFile());
                    processor.process(content);
                }
                finally {
                    loader.popTemplateFolder();
                }
            }
            string = content;
        }
        catch (TemplateException ex) {
            throw new TemplateProcessingException((Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new TemplateProcessingException(ex);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/FreemarkerUtils", "processFreemarkerTemplate"));
        }
        return string;
    }

    public static class TemplateUserVisibleException
    extends TemplateProcessingException {
        public TemplateUserVisibleException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/templates/FreemarkerUtils$TemplateUserVisibleException", "<init>"));
            }
            super(message, null);
        }
    }

    public static class TemplateProcessingException
    extends Exception {
        public TemplateProcessingException(@NotNull String message, @Nullable Exception inner) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/templates/FreemarkerUtils$TemplateProcessingException", "<init>"));
            }
            super(message, inner);
        }

        public TemplateProcessingException(@NotNull Exception inner) {
            if (inner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inner", "com/android/tools/idea/templates/FreemarkerUtils$TemplateProcessingException", "<init>"));
            }
            super(inner);
        }
    }

    public static interface TemplatePostProcessor {
        public void process(@NotNull String var1) throws TemplateProcessingException;
    }
}

