/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.AdbWrapper;
import com.android.tools.idea.sdk.remote.internal.ITaskMonitor;
import com.android.tools.idea.sdk.remote.internal.archives.Archive;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.io.File;
import java.util.Map;
import org.w3c.dom.Node;

public class PlatformToolRemotePkgInfo
extends RemotePkgInfo {
    public static final String INSTALL_ID = "platform-tools";
    public static final String INSTALL_ID_PREVIEW = "platform-tools-preview";

    public PlatformToolRemotePkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        PkgDesc.Builder pkgDescBuilder = PkgDesc.Builder.newPlatformTool((FullRevision)this.getRevision());
        pkgDescBuilder.setDescriptionShort(PlatformToolRemotePkgInfo.createShortDescription(this.mListDisplay, this.getRevision(), this.isObsolete()));
        pkgDescBuilder.setDescriptionUrl(this.getDescUrl());
        pkgDescBuilder.setListDisplay(PlatformToolRemotePkgInfo.createListDescription(this.mListDisplay, this.isObsolete()));
        pkgDescBuilder.setIsObsolete(this.isObsolete());
        pkgDescBuilder.setLicense(this.getLicense());
        this.mPkgDesc = pkgDescBuilder.create();
    }

    @Override
    public String installId() {
        if (this.getRevision().isPreview()) {
            return INSTALL_ID_PREVIEW;
        }
        return INSTALL_ID;
    }

    private static String createListDescription(String listDisplay, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Platform-tools%1$s", obsolete ? " (Obsolete)" : "");
    }

    private static String createShortDescription(String listDisplay, FullRevision revision, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", listDisplay, revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        return String.format("Android SDK Platform-tools, revision %1$s%2$s", revision.toShortString(), obsolete ? " (Obsolete)" : "");
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        return new File(osSdkRoot, INSTALL_ID);
    }

    @Override
    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        AdbWrapper aw = new AdbWrapper(osSdkRoot, monitor);
        aw.stopAdb();
        return super.preInstallHook(archive, monitor, osSdkRoot, installFolder);
    }
}

