/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceTarget;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeployTarget<S extends DeployTargetState> {
    private static ExtensionPointName<DeployTarget> EP_NAME = ExtensionPointName.create((String)"com.android.run.deployTarget");
    private static List<DeployTarget> ourTargets;

    public static List<DeployTarget> getDeployTargets() {
        if (ourTargets == null) {
            ourTargets = Arrays.asList(EP_NAME.getExtensions());
        }
        return ourTargets;
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract S createState();

    public abstract DeployTargetConfigurable<S> createConfigurable(@NotNull Project var1, @NotNull Disposable var2, @NotNull DeployTargetConfigurableContext var3);

    public boolean showInDevicePicker() {
        return false;
    }

    public boolean isApplicable(boolean isTestConfig) {
        return true;
    }

    public boolean requiresRuntimePrompt(@NotNull S deployTargetState) {
        if (deployTargetState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTargetState", "com/android/tools/idea/run/editor/DeployTarget", "requiresRuntimePrompt"));
        }
        return false;
    }

    public boolean showPrompt(Executor executor, ExecutionEnvironment env, AndroidFacet facet, DeviceCount deviceCount, boolean androidTests, @NotNull Map<String, DeployTargetState> deployTargetStates, int uniqueId, ProcessHandlerConsolePrinter printer) {
        if (deployTargetStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployTargetStates", "com/android/tools/idea/run/editor/DeployTarget", "showPrompt"));
        }
        throw new IllegalStateException();
    }

    public boolean hasCustomRunProfileState(@NotNull Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/DeployTarget", "hasCustomRunProfileState"));
        }
        return false;
    }

    public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull S state) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/idea/run/editor/DeployTarget", "getRunProfileState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/idea/run/editor/DeployTarget", "getRunProfileState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/editor/DeployTarget", "getRunProfileState"));
        }
        throw new IllegalStateException();
    }

    @Nullable
    public abstract DeviceTarget getTarget(@NotNull S var1, @NotNull AndroidFacet var2, @NotNull DeviceCount var3, boolean var4, int var5, @NotNull ConsolePrinter var6);

    public static class Renderer
    extends ColoredListCellRenderer<DeployTarget> {
        protected void customizeCellRenderer(JList list, DeployTarget value, int index, boolean selected, boolean hasFocus) {
            this.append(value.getDisplayName());
        }
    }
}

