/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultActivityLocator
extends ActivityLocator {
    @NotNull
    private final AndroidFacet myFacet;

    public DefaultActivityLocator(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/activity/DefaultActivityLocator", "<init>"));
        }
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) throws ActivityLocator.ActivityLocatorException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getQualifiedActivityName"));
        }
        String activity = DefaultActivityLocator.computeDefaultActivity(this.myFacet, device);
        if (activity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        String string = activity;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getQualifiedActivityName"));
        }
        return string;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        String activity = DefaultActivityLocator.computeDefaultActivity(this.myFacet, null);
        if (activity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
    }

    @Nullable
    static String computeDefaultActivity(@NotNull AndroidFacet facet, final @Nullable IDevice device) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/activity/DefaultActivityLocator", "computeDefaultActivity"));
        }
        assert (!facet.getProperties().USE_CUSTOM_COMPILER_MANIFEST);
        final ManifestInfo manifestInfo = ManifestInfo.get(facet.getModule(), ActivityLocatorUtils.shouldUseMergedManifest(facet));
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return DefaultActivityLocator.computeDefaultActivity(manifestInfo.getActivities(), manifestInfo.getActivityAliases(), device);
            }
        });
    }

    @Nullable
    public static String getDefaultLauncherActivityName(final @NotNull Manifest manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifest", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getDefaultLauncherActivityName"));
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                Application application = manifest.getApplication();
                if (application == null) {
                    return null;
                }
                return DefaultActivityLocator.computeDefaultActivity(application.getActivities(), application.getActivityAliass(), null);
            }
        });
    }

    @Nullable
    private static String computeDefaultActivity(@NotNull List<Activity> activities, @NotNull List<ActivityAlias> activityAliases, @Nullable IDevice device) {
        ActivityWrapper activity;
        if (activities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "computeDefaultActivity"));
        }
        if (activityAliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityAliases", "com/android/tools/idea/run/activity/DefaultActivityLocator", "computeDefaultActivity"));
        }
        List<ActivityWrapper> launchableActivities = DefaultActivityLocator.getLaunchableActivities(DefaultActivityLocator.merge(activities, activityAliases));
        if (launchableActivities.isEmpty()) {
            return null;
        }
        if (launchableActivities.size() == 1) {
            return launchableActivities.get(0).getQualifiedName();
        }
        if (device != null && (activity = DefaultActivityLocator.findLauncherActivityForDevice(launchableActivities, device)) != null) {
            return activity.getQualifiedName();
        }
        ActivityWrapper defaultLauncher = DefaultActivityLocator.findDefaultLauncher(launchableActivities);
        if (defaultLauncher != null) {
            return defaultLauncher.getQualifiedName();
        }
        return launchableActivities.get(0).getQualifiedName();
    }

    @Nullable
    private static ActivityWrapper findLauncherActivityForDevice(@NotNull List<ActivityWrapper> launchableActivities, @NotNull IDevice device) {
        if (launchableActivities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchableActivities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "findLauncherActivityForDevice"));
        }
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/activity/DefaultActivityLocator", "findLauncherActivityForDevice"));
        }
        if (device.supportsFeature(IDevice.HardwareFeature.TV)) {
            return DefaultActivityLocator.findLeanbackLauncher(launchableActivities);
        }
        return null;
    }

    @Nullable
    private static ActivityWrapper findLeanbackLauncher(@NotNull List<ActivityWrapper> launcherActivities) {
        if (launcherActivities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launcherActivities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "findLeanbackLauncher"));
        }
        for (ActivityWrapper activity : launcherActivities) {
            for (IntentFilter filter : activity.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter, "android.intent.category.LEANBACK_LAUNCHER")) continue;
                return activity;
            }
        }
        return null;
    }

    @Nullable
    private static ActivityWrapper findDefaultLauncher(@NotNull List<ActivityWrapper> launcherActivities) {
        if (launcherActivities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launcherActivities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "findDefaultLauncher"));
        }
        for (ActivityWrapper activity : launcherActivities) {
            for (IntentFilter filter : activity.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter, "android.intent.category.DEFAULT")) continue;
                return activity;
            }
        }
        return null;
    }

    @NotNull
    private static List<ActivityWrapper> getLaunchableActivities(@NotNull List<ActivityWrapper> allActivities) {
        if (allActivities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allActivities", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getLaunchableActivities"));
        }
        List list = ContainerUtil.filter(allActivities, (Condition)new Condition<ActivityWrapper>(){

            public boolean value(ActivityWrapper activity) {
                return ActivityLocatorUtils.containsLauncherIntent(activity.getIntentFilters());
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/DefaultActivityLocator", "getLaunchableActivities"));
        }
        return list;
    }

    private static List<ActivityWrapper> merge(List<Activity> activities, List<ActivityAlias> activityAliases) {
        ArrayList activityWrappers = Lists.newArrayListWithExpectedSize((int)(activities.size() + activityAliases.size()));
        for (Activity activity : activities) {
            activityWrappers.add(ActivityWrapper.get(activity));
        }
        for (ActivityAlias activityAlias : activityAliases) {
            activityWrappers.add(ActivityWrapper.get(activityAlias));
        }
        return activityWrappers;
    }

    private static class ActivityAliasWrapper
    extends ActivityWrapper {
        private final ActivityAlias myAlias;

        public ActivityAliasWrapper(ActivityAlias activityAlias) {
            this.myAlias = activityAlias;
        }

        @Override
        @NotNull
        public List<IntentFilter> getIntentFilters() {
            List<IntentFilter> list = this.myAlias.getIntentFilters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityAliasWrapper", "getIntentFilters"));
            }
            return list;
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myAlias);
        }
    }

    private static class RealActivityWrapper
    extends ActivityWrapper {
        private final Activity myActivity;

        public RealActivityWrapper(Activity activity) {
            this.myActivity = activity;
        }

        @Override
        @NotNull
        public List<IntentFilter> getIntentFilters() {
            List<IntentFilter> list = this.myActivity.getIntentFilters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/activity/DefaultActivityLocator$RealActivityWrapper", "getIntentFilters"));
            }
            return list;
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myActivity);
        }
    }

    public static abstract class ActivityWrapper {
        @NotNull
        public abstract List<IntentFilter> getIntentFilters();

        @Nullable
        public abstract String getQualifiedName();

        public static ActivityWrapper get(@NotNull Activity activity) {
            if (activity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activity", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper", "get"));
            }
            return new RealActivityWrapper(activity);
        }

        public static ActivityWrapper get(@NotNull ActivityAlias activityAlias) {
            if (activityAlias == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityAlias", "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper", "get"));
            }
            return new ActivityAliasWrapper(activityAlias);
        }
    }
}

