/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdWizardConstants;
import com.android.tools.idea.run.AndroidDevice;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class LaunchableAndroidDevice
implements AndroidDevice {
    private final AvdInfo myAvdInfo;

    public LaunchableAndroidDevice(@NotNull AvdInfo avdInfo) {
        if (avdInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "avdInfo", "com/android/tools/idea/run/LaunchableAndroidDevice", "<init>"));
        }
        this.myAvdInfo = avdInfo;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        IAndroidTarget target = this.myAvdInfo.getTarget();
        AndroidVersion androidVersion = target == null ? AndroidVersion.DEFAULT : target.getVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getVersion"));
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public String getSerial() {
        String string = this.myAvdInfo.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/LaunchableAndroidDevice", "getSerial"));
        }
        return string;
    }

    @Override
    public boolean supportsFeature(IDevice.HardwareFeature feature) {
        switch (feature) {
            case WATCH: {
                return AvdWizardConstants.WEAR_TAG.equals((Object)this.myAvdInfo.getTag());
            }
            case TV: {
                return AvdWizardConstants.TV_TAG.equals((Object)this.myAvdInfo.getTag());
            }
        }
        return true;
    }

    @Override
    public void renderName(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/run/LaunchableAndroidDevice", "renderName"));
        }
        component.setIcon(AllIcons.Actions.Execute);
        component.append(AvdManagerConnection.getAvdDisplayName(this.myAvdInfo), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public AvdInfo getAvdInfo() {
        return this.myAvdInfo;
    }
}

