/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceTarget {
    @NotNull
    private final Collection<ListenableFuture<IDevice>> myDeviceFutures;

    private DeviceTarget(@NotNull Collection<ListenableFuture<IDevice>> deviceFutures) {
        if (deviceFutures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceFutures", "com/android/tools/idea/run/DeviceTarget", "<init>"));
        }
        this.myDeviceFutures = deviceFutures;
    }

    @NotNull
    public static DeviceTarget forFuture(ListenableFuture<IDevice> deviceFuture) {
        DeviceTarget deviceTarget = DeviceTarget.forFutures((Collection<ListenableFuture<IDevice>>)ImmutableList.of(deviceFuture));
        if (deviceTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceTarget", "forFuture"));
        }
        return deviceTarget;
    }

    @NotNull
    public static DeviceTarget forFutures(Collection<ListenableFuture<IDevice>> deviceFutures) {
        DeviceTarget deviceTarget = new DeviceTarget(deviceFutures);
        if (deviceTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceTarget", "forFutures"));
        }
        return deviceTarget;
    }

    @NotNull
    public static DeviceTarget forDevices(Iterable<IDevice> devices) {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (IDevice device : devices) {
            futures.add((Object)Futures.immediateFuture((Object)device));
        }
        DeviceTarget deviceTarget = new DeviceTarget((Collection<ListenableFuture<IDevice>>)futures.build());
        if (deviceTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceTarget", "forDevices"));
        }
        return deviceTarget;
    }

    @NotNull
    public Collection<ListenableFuture<IDevice>> getDeviceFutures() {
        Collection<ListenableFuture<IDevice>> collection = this.myDeviceFutures;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/DeviceTarget", "getDeviceFutures"));
        }
        return collection;
    }

    @Nullable
    public Collection<IDevice> getDevicesIfReady() {
        for (ListenableFuture<IDevice> deviceFuture : this.myDeviceFutures) {
            if (deviceFuture.isDone() && !deviceFuture.isCancelled()) continue;
            return null;
        }
        try {
            return (Collection)Futures.get((Future)Futures.allAsList(this.myDeviceFutures), ExecutionException.class);
        }
        catch (ExecutionException e) {
            return null;
        }
    }
}

