/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConnectedAndroidDevice
implements AndroidDevice {
    @NotNull
    private final IDevice myDevice;
    private final String myAvdName;

    public ConnectedAndroidDevice(@NotNull IDevice device, List<AvdInfo> avdInfos) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ConnectedAndroidDevice", "<init>"));
        }
        this.myDevice = device;
        AvdInfo avdInfo = ConnectedAndroidDevice.getAvdInfo(device, avdInfos);
        this.myAvdName = avdInfo == null ? null : AvdManagerConnection.getAvdDisplayName(avdInfo);
    }

    private static AvdInfo getAvdInfo(@NotNull IDevice device, List<AvdInfo> avdInfos) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ConnectedAndroidDevice", "getAvdInfo"));
        }
        if (avdInfos != null && device.isEmulator()) {
            for (AvdInfo info : avdInfos) {
                if (!info.getName().equals(device.getAvdName())) continue;
                return info;
            }
        }
        return null;
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return this.myDevice.isEmulator();
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        AndroidVersion androidVersion = DevicePropertyUtil.getDeviceVersion(this.myDevice);
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getVersion"));
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public String getSerial() {
        String string = this.myDevice.getSerialNumber();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getSerial"));
        }
        return string;
    }

    @Override
    public boolean supportsFeature(IDevice.HardwareFeature feature) {
        return this.myDevice.supportsFeature(feature);
    }

    @Override
    public void renderName(@NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/android/tools/idea/run/ConnectedAndroidDevice", "renderName"));
        }
        renderer.setIcon(this.myDevice.isEmulator() ? AndroidIcons.Ddms.Emulator2 : AndroidIcons.Ddms.RealDevice);
        IDevice.DeviceState state = this.myDevice.getState();
        if (state != IDevice.DeviceState.ONLINE) {
            String name = String.format("%1$s [%2$s] ", this.myDevice.getSerialNumber(), this.myDevice.getState());
            renderer.append(name, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            return;
        }
        String name = this.myAvdName == null ? this.getDeviceName() : this.myAvdName;
        renderer.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        String build = DevicePropertyUtil.getBuild(this.myDevice);
        if (!build.isEmpty()) {
            renderer.append(" (" + build + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private String getDeviceName() {
        StringBuilder name = new StringBuilder(20);
        name.append(DevicePropertyUtil.getManufacturer(this.myDevice, ""));
        if (name.length() > 0) {
            name.append(' ');
        }
        name.append(DevicePropertyUtil.getModel(this.myDevice, ""));
        return name.toString();
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getDevice"));
        }
        return iDevice;
    }
}

