/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.rendering.LayoutPullParser;
import com.android.tools.idea.rendering.MenuPsiPullParser;
import com.android.tools.idea.rendering.PaddingLayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.TagSnapshot;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutPsiPullParser
extends LayoutPullParser {
    @NotNull
    private final LayoutLog myLogger;
    @NotNull
    private final List<TagSnapshot> myNodeStack;
    protected final TagSnapshot myRoot;
    private String myToolsPrefix;
    protected String myAndroidPrefix;
    protected boolean myProvideViewCookies;

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull RenderLogger logger) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (ResourceHelper.getFolderType((PsiFile)file) == ResourceFolderType.MENU) {
            MenuPsiPullParser menuPsiPullParser = new MenuPsiPullParser(file, (LayoutLog)logger);
            if (menuPsiPullParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
            }
            return menuPsiPullParser;
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(file, (LayoutLog)logger);
        if (layoutPsiPullParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(@NotNull XmlFile file, @NotNull RenderLogger logger, Set<XmlTag> explodeNodes, @NotNull Density density) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (density == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "density", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (explodeNodes != null && !explodeNodes.isEmpty()) {
            PaddingLayoutPsiPullParser paddingLayoutPsiPullParser = new PaddingLayoutPsiPullParser(file, logger, explodeNodes, density);
            if (paddingLayoutPsiPullParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
            }
            return paddingLayoutPsiPullParser;
        }
        LayoutPsiPullParser layoutPsiPullParser = new LayoutPsiPullParser(file, (LayoutLog)logger);
        if (layoutPsiPullParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        return layoutPsiPullParser;
    }

    @NotNull
    public static LayoutPsiPullParser create(RenderTask.AttributeFilter filter, @NotNull XmlTag root, @NotNull RenderLogger logger) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        AttributeFilteredLayoutParser attributeFilteredLayoutParser = new AttributeFilteredLayoutParser(root, (LayoutLog)logger, filter);
        if (attributeFilteredLayoutParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "create"));
        }
        return attributeFilteredLayoutParser;
    }

    protected LayoutPsiPullParser(@NotNull XmlFile file, @NotNull LayoutLog logger) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/LayoutPsiPullParser", "<init>"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/LayoutPsiPullParser", "<init>"));
        }
        this(AndroidPsiUtils.getRootTagSafely(file), logger);
    }

    protected LayoutPsiPullParser(final XmlTag root, @NotNull LayoutLog logger) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/LayoutPsiPullParser", "<init>"));
        }
        this.myNodeStack = new ArrayList<TagSnapshot>();
        this.myProvideViewCookies = true;
        this.myLogger = logger;
        if (root != null) {
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                if (root.isValid()) {
                    this.myAndroidPrefix = root.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                    this.myToolsPrefix = root.getPrefixByNamespace("http://schemas.android.com/tools");
                    this.myRoot = LayoutPsiPullParser.createSnapshot(root);
                } else {
                    this.myRoot = null;
                }
            } else {
                this.myRoot = (TagSnapshot)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TagSnapshot>(){

                    public TagSnapshot compute() {
                        if (root.isValid()) {
                            LayoutPsiPullParser.this.myAndroidPrefix = root.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                            LayoutPsiPullParser.this.myToolsPrefix = root.getPrefixByNamespace("http://schemas.android.com/tools");
                            return LayoutPsiPullParser.createSnapshot(root);
                        }
                        return null;
                    }
                });
            }
        } else {
            this.myRoot = null;
        }
    }

    protected final TagSnapshot getCurrentNode() {
        if (this.myNodeStack.size() > 0) {
            return this.myNodeStack.get(this.myNodeStack.size() - 1);
        }
        return null;
    }

    protected final TagSnapshot getPreviousNode() {
        if (this.myNodeStack.size() > 1) {
            return this.myNodeStack.get(this.myNodeStack.size() - 2);
        }
        return null;
    }

    protected final AttributeSnapshot getAttribute(int i) {
        if (this.myParsingState != 2) {
            throw new IndexOutOfBoundsException();
        }
        TagSnapshot uiNode = this.getCurrentNode();
        if (uiNode != null) {
            return uiNode.attributes.get(i);
        }
        return null;
    }

    protected void push(@NotNull TagSnapshot node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/rendering/LayoutPsiPullParser", "push"));
        }
        this.myNodeStack.add(node);
    }

    @NotNull
    protected TagSnapshot pop() {
        TagSnapshot tagSnapshot = this.myNodeStack.remove(this.myNodeStack.size() - 1);
        if (tagSnapshot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/rendering/LayoutPsiPullParser", "pop"));
        }
        return tagSnapshot;
    }

    public Object getViewCookie() {
        TagSnapshot element;
        if (this.myProvideViewCookies && (element = this.getCurrentNode()) != null) {
            return element.tag;
        }
        return null;
    }

    public Object getViewKey() {
        return this.getViewCookie();
    }

    public ILayoutPullParser getParser(String layoutName) {
        return null;
    }

    public String getPositionDescription() {
        return "XML DOM element depth:" + this.myNodeStack.size();
    }

    public int getAttributeCount() {
        TagSnapshot node = this.getCurrentNode();
        if (node != null) {
            return node.attributes.size();
        }
        return 0;
    }

    public String getAttributeName(int i) {
        AttributeSnapshot attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.name;
        }
        return null;
    }

    public String getAttributeNamespace(int i) {
        AttributeSnapshot attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.namespace;
        }
        return "";
    }

    public String getAttributePrefix(int i) {
        AttributeSnapshot attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.prefix;
        }
        return null;
    }

    public String getAttributeValue(int i) {
        AttributeSnapshot attribute = this.getAttribute(i);
        if (attribute != null) {
            return attribute.value;
        }
        return null;
    }

    public String getAttributeValue(String namespace, String localName) {
        TagSnapshot tag = this.getCurrentNode();
        if (tag != null) {
            String layout;
            if ("layout".equals(localName) && "fragment".equals(tag.tagName) && (layout = tag.getAttribute("layout", "http://schemas.android.com/tools")) != null) {
                return layout;
            }
            String value = null;
            if (namespace == null) {
                value = tag.getAttribute(localName);
            } else if (namespace.equals("http://schemas.android.com/apk/res/android")) {
                if (this.myAndroidPrefix != null) {
                    if (this.myToolsPrefix != null) {
                        for (AttributeSnapshot attribute : tag.attributes) {
                            if (!localName.equals(attribute.name)) continue;
                            if (this.myToolsPrefix.equals(attribute.prefix)) {
                                value = attribute.value;
                                if (value == null || !value.isEmpty()) break;
                                value = tag.getAttribute(localName, "http://schemas.android.com/apk/res/android") != null ? null : value;
                                break;
                            }
                            if (!this.myAndroidPrefix.equals(attribute.prefix)) continue;
                            value = attribute.value;
                        }
                    } else {
                        value = tag.getAttribute(localName, "http://schemas.android.com/apk/res/android");
                    }
                } else {
                    value = tag.getAttribute(localName, namespace);
                }
            } else {
                for (AttributeSnapshot attribute : tag.attributes) {
                    if (!localName.equals(attribute.name) || !namespace.equals(attribute.namespace) && !"http://schemas.android.com/apk/res-auto".equals(attribute.namespace)) continue;
                    value = attribute.value;
                    break;
                }
            }
            if (value != null) {
                if ("match_parent".equals(value) && ("layout_width".equals(localName) || "layout_height".equals(localName)) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                    return "fill_parent";
                }
                int n = value.length();
                for (int i = 0; i < n; ++i) {
                    char c = value.charAt(i);
                    if (c != '&' && c != '\\') continue;
                    value = ValueXmlHelper.unescapeResourceString((String)value, (boolean)true, (boolean)false);
                    break;
                }
            }
            return value;
        }
        return null;
    }

    public int getDepth() {
        return this.myNodeStack.size();
    }

    public String getName() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            String name = currentNode.tagName;
            if (name.equals("fragment")) {
                String layout = currentNode.getAttribute("layout", "http://schemas.android.com/tools");
                if (layout != null) {
                    return "include";
                }
                String fragmentId = currentNode.getAttribute("class");
                if ((fragmentId == null || fragmentId.isEmpty()) && ((fragmentId = currentNode.getAttribute("name", "http://schemas.android.com/apk/res/android")) == null || fragmentId.isEmpty())) {
                    fragmentId = currentNode.getAttribute("id", "http://schemas.android.com/apk/res/android");
                }
                this.myLogger.warning("missing.fragment", "Missing fragment association", (Object)fragmentId);
            }
            return name;
        }
        return null;
    }

    public String getNamespace() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.namespace;
        }
        return null;
    }

    public String getPrefix() {
        if (this.myParsingState == 2 || this.myParsingState == 3) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.prefix;
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.myParsingState == 2) {
            TagSnapshot currentNode = this.getCurrentNode();
            assert (currentNode != null);
            return currentNode.children.isEmpty();
        }
        throw new XmlPullParserException("Call to isEmptyElementTag while not in START_TAG", (XmlPullParser)this, null);
    }

    @Override
    protected void onNextFromStartDocument() {
        if (this.myRoot != null) {
            this.push(this.myRoot);
            this.myParsingState = 2;
        } else {
            this.myParsingState = 1;
        }
    }

    @Override
    protected void onNextFromStartTag() {
        TagSnapshot node = this.getCurrentNode();
        assert (node != null);
        List<TagSnapshot> children = node.children;
        if (!children.isEmpty()) {
            this.push(children.get(0));
            this.myParsingState = 2;
        } else {
            this.myParsingState = this.myParsingState == 0 ? 1 : 3;
        }
    }

    @Override
    protected void onNextFromEndTag() {
        TagSnapshot node = this.getCurrentNode();
        assert (node != null);
        TagSnapshot sibling = node.getNextSibling();
        if (sibling != null) {
            node = sibling;
            this.pop();
            this.push(node);
            this.myParsingState = 2;
        } else {
            this.pop();
            this.myParsingState = this.myNodeStack.isEmpty() ? 1 : 3;
        }
    }

    public void setProvideViewCookies(boolean provideViewCookies) {
        this.myProvideViewCookies = provideViewCookies;
    }

    private static TagSnapshot createSnapshot(@NotNull XmlTag tag) {
        String prefix;
        XmlAttribute id;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/rendering/LayoutPsiPullParser", "createSnapshot"));
        }
        String rootTag = tag.getName();
        assert (rootTag != null);
        if (rootTag.equals("fragment")) {
            XmlAttribute[] psiAttributes = tag.getAttributes();
            ArrayList attributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
            for (XmlAttribute psiAttribute : psiAttributes) {
                AttributeSnapshot attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute);
                if (attribute == null) continue;
                attributes.add(attribute);
            }
            ArrayList includeAttributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
            for (XmlAttribute psiAttribute : psiAttributes) {
                AttributeSnapshot attribute;
                String localName;
                String name = psiAttribute.getName();
                assert (name != null);
                if (name.startsWith("xmlns:") || (localName = psiAttribute.getLocalName()).startsWith("layout_margin") || localName.startsWith("padding") || localName.equals("id") || (attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute)) == null) continue;
                includeAttributes.add(attribute);
            }
            TagSnapshot include = TagSnapshot.createSyntheticTag(null, "fragment", "", "", includeAttributes, Collections.emptyList());
            return TagSnapshot.createSyntheticTag(tag, "FrameLayout", "", "", attributes, Collections.singletonList(include));
        }
        if (rootTag.equals("FrameLayout")) {
            String visibleChild;
            String prefix2;
            TagSnapshot root = TagSnapshot.createTagSnapshot(tag);
            String layout = tag.getAttributeValue("layout", "http://schemas.android.com/tools");
            if (layout != null && root.children.isEmpty() && (prefix2 = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
                ArrayList children;
                root.children = children = Lists.newArrayList();
                ArrayList attributes = Lists.newArrayListWithExpectedSize((int)3);
                attributes.add(new AttributeSnapshot("", "", "layout", layout));
                attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix2, "layout_width", "fill_parent"));
                attributes.add(new AttributeSnapshot("http://schemas.android.com/apk/res/android", prefix2, "layout_height", "fill_parent"));
                TagSnapshot element = TagSnapshot.createSyntheticTag(null, "include", "", "", attributes, Collections.emptyList());
                children.add(element);
            }
            if ((visibleChild = tag.getAttributeValue("visibleChildren", "http://schemas.android.com/tools")) != null) {
                HashSet indices = Sets.newHashSet();
                for (String s : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)visibleChild)) {
                    try {
                        indices.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException psiAttribute) {}
                }
                String prefix3 = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
                if (prefix3 != null) {
                    int n = root.children.size();
                    for (int i = 0; i < n; ++i) {
                        TagSnapshot child = root.children.get(i);
                        boolean visible = indices.contains(i);
                        child.setAttribute("visibility", "http://schemas.android.com/apk/res/android", prefix3, visible ? "visible" : "gone");
                    }
                }
            }
            return root;
        }
        if (rootTag.equals("layout")) {
            for (XmlTag subTag : tag.getSubTags()) {
                String subTagName = subTag.getName();
                assert (subTagName != null);
                if (subTagName.equals("data")) continue;
                return LayoutPsiPullParser.createSnapshot(subTag);
            }
            return null;
        }
        TagSnapshot root = TagSnapshot.createTagSnapshot(tag);
        if ((rootTag.equals("ListView") || rootTag.equals("ExpandableListView") || rootTag.equals("GridView") || rootTag.equals("Spinner")) && (id = tag.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null && (prefix = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android")) != null) {
            root.setAttribute("id", "http://schemas.android.com/apk/res/android", prefix, "@+id/_dynamic");
        }
        return root;
    }

    static class AttributeFilteredLayoutParser
    extends LayoutPsiPullParser {
        private final RenderTask.AttributeFilter myFilter;

        public AttributeFilteredLayoutParser(@NotNull XmlTag root, @NotNull LayoutLog logger, RenderTask.AttributeFilter filter) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser", "<init>"));
            }
            if (logger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser", "<init>"));
            }
            super(root, logger);
            this.myFilter = filter;
        }

        public AttributeFilteredLayoutParser(@NotNull XmlFile file, @NotNull LayoutLog logger, RenderTask.AttributeFilter filter) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser", "<init>"));
            }
            if (logger == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/rendering/LayoutPsiPullParser$AttributeFilteredLayoutParser", "<init>"));
            }
            super(file, logger);
            this.myFilter = filter;
        }

        @Override
        public String getAttributeValue(final String namespace, final String localName) {
            String value;
            XmlTag tag;
            TagSnapshot element;
            if (this.myFilter != null && (element = this.getCurrentNode()) != null && (tag = element.tag) != null && (value = ApplicationManager.getApplication().isReadAccessAllowed() ? this.myFilter.getAttribute(tag, namespace, localName) : (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return myFilter.getAttribute(tag, namespace, localName);
                }
            })) != null) {
                if (value.isEmpty()) {
                    return null;
                }
                return value;
            }
            return super.getAttributeValue(namespace, localName);
        }
    }
}

