/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidConfiguredLogFilters;
import com.android.tools.idea.logcat.RegexFilterComponent;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfiguredFilter {
    @NotNull
    private final String myName;
    @Nullable
    private final Pattern myMessagePattern;
    @Nullable
    private final Pattern myTagPattern;
    @Nullable
    private final Pattern myPkgNamePattern;
    @Nullable
    private final String myPid;
    @Nullable
    private final Log.LogLevel myLogLevel;

    private ConfiguredFilter(@NotNull String name, @Nullable Pattern messagePattern, @Nullable Pattern tagPattern, @Nullable Pattern pkgNamePattern, @Nullable String pid, @Nullable Log.LogLevel logLevel) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/logcat/ConfiguredFilter", "<init>"));
        }
        this.myName = name;
        this.myMessagePattern = messagePattern;
        this.myTagPattern = tagPattern;
        this.myPkgNamePattern = pkgNamePattern;
        this.myPid = pid;
        this.myLogLevel = logLevel;
    }

    public boolean isApplicable(String message, String tag, String pkg, int pid, Log.LogLevel logLevel) {
        if (!(this.myMessagePattern == null || message != null && this.myMessagePattern.matcher(message).find())) {
            return false;
        }
        if (!(this.myTagPattern == null || tag != null && this.myTagPattern.matcher(tag).find())) {
            return false;
        }
        if (!(this.myPkgNamePattern == null || pkg != null && this.myPkgNamePattern.matcher(pkg).find())) {
            return false;
        }
        if (this.myPid != null && this.myPid.length() > 0 && !this.myPid.equals(Integer.toString(pid))) {
            return false;
        }
        return this.myLogLevel == null || logLevel != null && logLevel.getPriority() >= this.myLogLevel.getPriority();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/ConfiguredFilter", "getName"));
        }
        return string;
    }

    @NotNull
    public static ConfiguredFilter compile(@NotNull AndroidConfiguredLogFilters.FilterEntry entry, @NotNull String name) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/android/tools/idea/logcat/ConfiguredFilter", "compile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/logcat/ConfiguredFilter", "compile"));
        }
        Pattern logMessagePattern = RegexFilterComponent.pattern(entry.getLogMessagePattern(), entry.getLogMessageIsRegex());
        Pattern logTagPattern = RegexFilterComponent.pattern(entry.getLogTagPattern(), entry.getLogTagIsRegex());
        Pattern pkgNamePattern = RegexFilterComponent.pattern(entry.getPackageNamePattern(), entry.getPackageNameIsRegex());
        String pid = entry.getPid();
        Log.LogLevel logLevel = null;
        String logLevelStr = entry.getLogLevel();
        if (logLevelStr != null && logLevelStr.length() > 0) {
            logLevel = Log.LogLevel.getByString((String)logLevelStr);
        }
        ConfiguredFilter configuredFilter = new ConfiguredFilter(name, logMessagePattern, logTagPattern, pkgNamePattern, pid, logLevel);
        if (configuredFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/ConfiguredFilter", "compile"));
        }
        return configuredFilter;
    }
}

