/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.builder.model.AndroidProject;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.quickfix.AbstractGradleDependencyFix;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddGradleProjectDependencyFix
extends AbstractGradleDependencyFix {
    @NotNull
    private final Set<Module> myModules;
    @NotNull
    private final VirtualFile myClassVFile;
    @NotNull
    private final PsiClass[] myClasses;

    public AddGradleProjectDependencyFix(@NotNull Module module, @NotNull VirtualFile classVFile, @NotNull PsiClass[] classes, @NotNull PsiReference reference) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "<init>"));
        }
        if (classVFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classVFile", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "<init>"));
        }
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "<init>"));
        }
        super(module, reference);
        this.myModules = Sets.newHashSet();
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        ModuleType currentModuleType = AddGradleProjectDependencyFix.getModuleType(module);
        PsiElement psiElement = reference.getElement();
        for (PsiClass aClass : classes) {
            Module classModule;
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null || (classModule = fileIndex.getModuleForFile(virtualFile)) == null || classModule == module || ModuleRootManager.getInstance((Module)module).isDependsOn(classModule)) continue;
            ModuleType classModuleType = AddGradleProjectDependencyFix.getModuleType(classModule);
            boolean legalDependency = false;
            switch (currentModuleType) {
                case JAVA: {
                    legalDependency = classModuleType == ModuleType.JAVA;
                    break;
                }
                case ANDROID_LIBRARY: {
                    legalDependency = classModuleType == ModuleType.JAVA || classModuleType == ModuleType.ANDROID_LIBRARY;
                    break;
                }
                case ANDROID_APPLICATION: {
                    boolean bl = legalDependency = classModuleType != ModuleType.ANDROID_APPLICATION;
                }
            }
            if (!legalDependency) continue;
            this.myModules.add(classModule);
        }
        this.myClassVFile = classVFile;
        this.myClasses = classes;
    }

    @NotNull
    public String getText() {
        if (this.myModules.size() == 1) {
            Module module = (Module)ContainerUtil.getFirstItem(this.myModules);
            assert (module != null);
            String string = QuickFixBundle.message((String)"orderEntry.fix.add.dependency.on.module", (Object[])new Object[]{module.getName()});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "getText"));
            }
            return string;
        }
        if ("Add dependency on module..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "getText"));
        }
        return "Add dependency on module...";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"orderEntry.fix.family.add.module.dependency", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "isAvailable"));
        }
        for (Module module : this.myModules) {
            if (!module.isDisposed()) continue;
            return false;
        }
        return !project.isDisposed() && !this.myModules.isEmpty() && !this.myModule.isDisposed();
    }

    public void invoke(final @NotNull Project project, final @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "invoke"));
        }
        if (editor != null && !CodeInsightUtilBase.prepareEditorForWrite((Editor)editor)) {
            return;
        }
        if (this.myModules.size() == 1) {
            Module module = (Module)ContainerUtil.getFirstItem(this.myModules);
            assert (module != null);
            this.addDependencyOnModule(project, editor, module);
        } else {
            final JBList list = new JBList(this.myModules);
            list.setCellRenderer((ListCellRenderer)new ModuleListCellRenderer());
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    Object value = list.getSelectedValue();
                    if (value instanceof Module) {
                        AddGradleProjectDependencyFix.this.addDependencyOnModule(project, editor, (Module)value);
                    }
                }
            };
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Module to Add Dependency on").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(callback).createPopup();
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }
    }

    private void addDependencyOnModule(final @NotNull Project project, final @Nullable Editor editor, final @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "addDependencyOnModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "addDependencyOnModule"));
        }
        Runnable doit = new Runnable(){

            @Override
            public void run() {
                final boolean testScope = ModuleRootManager.getInstance((Module)AddGradleProjectDependencyFix.this.myModule).getFileIndex().isInTestSourceContent(AddGradleProjectDependencyFix.this.myClassVFile);
                AddGradleProjectDependencyFix.this.runWriteCommandActionAndSync(project, new Runnable(){

                    @Override
                    public void run() {
                        AddGradleProjectDependencyFix.this.addDependencyUndoable(AddGradleProjectDependencyFix.this.myModule, module, testScope);
                    }
                }, new Computable<PsiClass[]>(){

                    public PsiClass[] compute() {
                        ArrayList targetClasses = Lists.newArrayList();
                        for (PsiClass psiClass : AddGradleProjectDependencyFix.this.myClasses) {
                            if (ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) != module) continue;
                            targetClasses.add(psiClass);
                        }
                        return targetClasses.toArray(new PsiClass[targetClasses.size()]);
                    }
                }, editor);
            }
        };
        Couple circularModules = ModuleCompilerUtil.addingDependencyFormsCircularity((Module)this.myModule, (Module)module);
        if (circularModules == null) {
            doit.run();
        } else {
            AddGradleProjectDependencyFix.showCircularWarningAndContinue(project, (Pair<Module, Module>)circularModules, module, doit);
        }
    }

    private static void showCircularWarningAndContinue(final @NotNull Project project, @NotNull Pair<Module, Module> circularModules, @NotNull Module classModule, final @NotNull Runnable doit) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "showCircularWarningAndContinue"));
        }
        if (circularModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "circularModules", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "showCircularWarningAndContinue"));
        }
        if (classModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classModule", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "showCircularWarningAndContinue"));
        }
        if (doit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doit", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "showCircularWarningAndContinue"));
        }
        final String message = QuickFixBundle.message((String)"orderEntry.fix.circular.dependency.warning", (Object[])new Object[]{classModule.getName(), ((Module)circularModules.getFirst()).getName(), ((Module)circularModules.getSecond()).getName()});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(message);
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!project.isOpen()) {
                    return;
                }
                String title = QuickFixBundle.message((String)"orderEntry.fix.title.circular.dependency.warning", (Object[])new Object[0]);
                int answer = Messages.showOkCancelDialog((Project)project, (String)message, (String)title, (Icon)Messages.getWarningIcon());
                if (answer == 0) {
                    ApplicationManager.getApplication().runWriteAction(doit);
                }
            }
        });
    }

    private void addDependencyUndoable(@NotNull Module from, @NotNull Module to, boolean test) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "addDependencyUndoable"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "addDependencyUndoable"));
        }
        String gradlePath = GradleUtil.getGradlePath(to);
        if (gradlePath != null) {
            Dependency dependency = new Dependency(AddGradleProjectDependencyFix.getDependencyScope(from, test), Dependency.Type.MODULE, gradlePath);
            this.addDependencyUndoable(from, dependency);
        }
    }

    private void addDependencyUndoable(@NotNull Module module, @NotNull Dependency dependency) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "addDependencyUndoable"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "addDependencyUndoable"));
        }
        GradleBuildFile gradleBuildFile = GradleBuildFile.get(module);
        if (gradleBuildFile == null) {
            return;
        }
        ArrayList dependencies = Lists.newArrayList(gradleBuildFile.getDependencies());
        dependencies.add(dependency);
        gradleBuildFile.setValue(BuildFileKey.DEPENDENCIES, dependencies);
        AddGradleProjectDependencyFix.registerUndoAction(module.getProject());
        this.myAddedDependency = dependency.getValueAsString();
        this.myAddedDependency = dependency.scope.getGroovyMethodCall();
    }

    @NotNull
    private static Dependency.Scope getDependencyScope(@NotNull Module module, boolean test) {
        AndroidGradleModel androidModel;
        AndroidFacet androidFacet;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "getDependencyScope"));
        }
        Dependency.Scope testScope = Dependency.Scope.TEST_COMPILE;
        if (test && (androidFacet = AndroidFacet.getInstance(module)) != null && (androidModel = AndroidGradleModel.get(androidFacet)) != null && "_android_test_".equals(androidModel.getSelectedTestArtifactName())) {
            testScope = Dependency.Scope.ANDROID_TEST_COMPILE;
        }
        Dependency.Scope scope = test ? testScope : Dependency.Scope.COMPILE;
        if (scope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "getDependencyScope"));
        }
        return scope;
    }

    @NotNull
    private static ModuleType getModuleType(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "getModuleType"));
        }
        AndroidProject androidProject = GradleUtil.getAndroidProject(module);
        if (androidProject == null) {
            ModuleType moduleType = ModuleType.JAVA;
            if (moduleType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "getModuleType"));
            }
            return moduleType;
        }
        ModuleType moduleType = androidProject.isLibrary() ? ModuleType.ANDROID_LIBRARY : ModuleType.ANDROID_APPLICATION;
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleProjectDependencyFix", "getModuleType"));
        }
        return moduleType;
    }

    private static enum ModuleType {
        JAVA,
        ANDROID_LIBRARY,
        ANDROID_APPLICATION;

    }
}

