/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.quickfix;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.quickfix.AbstractGradleDependencyFix;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.io.File;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddGradleLibraryDependencyFix
extends AbstractGradleDependencyFix {
    @NotNull
    private final LibraryOrderEntry myLibraryEntry;
    @NotNull
    private final PsiClass myClass;
    @Nullable
    private final ExternalDependencySpec myNewExternalDependency;

    public AddGradleLibraryDependencyFix(@NotNull LibraryOrderEntry libraryEntry, @NotNull PsiClass aCLass, @NotNull Module module, @NotNull PsiReference reference) {
        if (libraryEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryEntry", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "<init>"));
        }
        if (aCLass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aCLass", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "<init>"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "<init>"));
        }
        super(module, reference);
        this.myLibraryEntry = libraryEntry;
        this.myClass = aCLass;
        this.myNewExternalDependency = this.findNewExternalDependency();
    }

    @Nullable
    private ExternalDependencySpec findNewExternalDependency() {
        AndroidFacet androidFacet = AndroidFacet.getInstance(this.myLibraryEntry.getOwnerModule());
        ExternalDependencySpec result = null;
        if (androidFacet != null) {
            result = this.findNewExternalDependency(androidFacet);
        }
        if (result == null) {
            result = this.findNewExternalDependencyByExaminingPath();
        }
        return result;
    }

    @NotNull
    public String getText() {
        assert (this.myNewExternalDependency != null);
        String string = QuickFixBundle.message((String)"orderEntry.fix.add.library.to.classpath", (Object[])new Object[]{this.myNewExternalDependency.compactNotation()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"orderEntry.fix.family.add.library.to.classpath", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "isAvailable"));
        }
        return !project.isDisposed() && !this.myModule.isDisposed() && this.myLibraryEntry.isValid() && this.myNewExternalDependency != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "invoke"));
        }
        if (this.myNewExternalDependency == null) {
            return;
        }
        String configurationName = AddGradleLibraryDependencyFix.getConfigurationName(this.myModule, false);
        this.addDependencyAndSync(configurationName, this.myNewExternalDependency, new Computable<PsiClass[]>(){

            public PsiClass[] compute() {
                return new PsiClass[]{AddGradleLibraryDependencyFix.this.myClass};
            }
        }, editor);
    }

    @Nullable
    private ExternalDependencySpec findNewExternalDependency(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "findNewExternalDependency"));
        }
        AndroidGradleModel androidModel = AndroidGradleModel.get(androidFacet);
        if (androidModel == null) {
            return null;
        }
        BaseArtifact testArtifact = androidModel.findSelectedTestArtifactInSelectedVariant();
        Library matchedLibrary = null;
        if (testArtifact != null) {
            matchedLibrary = this.findMatchedLibrary(testArtifact);
        }
        if (matchedLibrary == null) {
            Variant selectedVariant = androidModel.getSelectedVariant();
            matchedLibrary = this.findMatchedLibrary((BaseArtifact)selectedVariant.getMainArtifact());
        }
        if (matchedLibrary == null) {
            return null;
        }
        MavenCoordinates coordinates = matchedLibrary.getResolvedCoordinates();
        if (coordinates == null) {
            return null;
        }
        return new ExternalDependencySpec(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getVersion());
    }

    @Nullable
    private Library findMatchedLibrary(@NotNull BaseArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/quickfix/AddGradleLibraryDependencyFix", "findMatchedLibrary"));
        }
        for (JavaLibrary library : artifact.getDependencies().getJavaLibraries()) {
            String libraryName = FileUtil.getNameWithoutExtension((File)library.getJarFile());
            if (!libraryName.equals(this.myLibraryEntry.getLibraryName())) continue;
            return library;
        }
        return null;
    }

    @Nullable
    private ExternalDependencySpec findNewExternalDependencyByExaminingPath() {
        VirtualFile[] files = this.myLibraryEntry.getFiles(OrderRootType.CLASSES);
        if (files.length == 0) {
            return null;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)files[0]);
        String libraryName = this.myLibraryEntry.getLibraryName();
        if (libraryName == null) {
            return null;
        }
        List pathSegments = FileUtil.splitPath((String)file.getPath());
        for (int i = 1; i < pathSegments.size() - 2; ++i) {
            if (!libraryName.startsWith((String)pathSegments.get(i))) continue;
            String groupId = (String)pathSegments.get(i - 1);
            String artifactId = (String)pathSegments.get(i);
            String version = (String)pathSegments.get(i + 1);
            if (!libraryName.endsWith(version)) continue;
            return new ExternalDependencySpec(artifactId, groupId, version);
        }
        return null;
    }
}

