/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Variant;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.stats.UsageTracker;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ProjectStructureUsageTracker {
    @NotNull
    private final Project myProject;

    ProjectStructureUsageTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProjectStructureUsageTracker", "<init>"));
        }
        this.myProject = project;
    }

    void trackProjectStructure() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)ProjectStructureUsageTracker.this.myProject);
                ProjectStructureUsageTracker.this.trackProjectStructure(moduleManager.getModules());
            }
        });
    }

    private void trackProjectStructure(@NotNull Module[] modules) {
        AndroidGradleModel target;
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/ProjectStructureUsageTracker", "trackProjectStructure"));
        }
        AndroidGradleModel appModel = null;
        AndroidGradleModel libModel = null;
        for (Module module : modules) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(module);
            if (androidModel == null) continue;
            AndroidProject androidProject = androidModel.getAndroidProject();
            if (androidProject.isLibrary()) {
                libModel = androidModel;
                continue;
            }
            appModel = androidModel;
            ProjectStructureUsageTracker.trackExternalDependenciesInAndroidApp(androidProject);
        }
        AndroidGradleModel androidGradleModel = target = appModel != null ? appModel : libModel;
        if (target != null) {
            AndroidProject androidProject = target.getAndroidProject();
            FullRevision gradleVersion = GradleUtil.getGradleVersion(this.myProject);
            UsageTracker.getInstance().trackGradleArtifactVersions(target.getApplicationId(), androidProject.getModelVersion(), gradleVersion != null ? gradleVersion.toString() : "<Not Found>");
        }
    }

    private static void trackExternalDependenciesInAndroidApp(@NotNull AndroidProject model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/project/ProjectStructureUsageTracker", "trackExternalDependenciesInAndroidApp"));
        }
        Collection variants = model.getVariants();
        if (variants.isEmpty()) {
            return;
        }
        Variant chosen = null;
        for (Variant variant : variants) {
            if (!"release".equals(variant.getBuildType())) continue;
            chosen = variant;
            break;
        }
        if (chosen == null) {
            chosen = (Variant)ContainerUtil.getFirstItem((Collection)variants);
        }
        if (chosen != null) {
            ProjectStructureUsageTracker.trackLibraryCount(chosen);
        }
    }

    private static void trackLibraryCount(@NotNull Variant variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/project/ProjectStructureUsageTracker", "trackLibraryCount"));
        }
        DependencyFiles files = new DependencyFiles();
        AndroidArtifact artifact = variant.getMainArtifact();
        String applicationId = artifact.getApplicationId();
        Dependencies dependencies = artifact.getDependencies();
        for (JavaLibrary javaLibrary : dependencies.getJavaLibraries()) {
            ProjectStructureUsageTracker.addJarLibraryAndDependencies(javaLibrary, files);
        }
        for (AndroidLibrary androidLibrary : dependencies.getLibraries()) {
            ProjectStructureUsageTracker.addAarLibraryAndDependencies(androidLibrary, files);
        }
        UsageTracker.getInstance().trackLibraryCount(applicationId, files.jars.size(), files.aars.size());
    }

    private static void addJarLibraryAndDependencies(@NotNull JavaLibrary javaLibrary, @NotNull DependencyFiles files) {
        if (javaLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaLibrary", "com/android/tools/idea/gradle/project/ProjectStructureUsageTracker", "addJarLibraryAndDependencies"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/gradle/project/ProjectStructureUsageTracker", "addJarLibraryAndDependencies"));
        }
        File jarFile = javaLibrary.getJarFile();
        if (files.jars.contains(jarFile)) {
            return;
        }
        files.jars.add(jarFile);
        for (JavaLibrary dependency : javaLibrary.getDependencies()) {
            ProjectStructureUsageTracker.addJarLibraryAndDependencies(dependency, files);
        }
    }

    private static void addAarLibraryAndDependencies(@NotNull AndroidLibrary androidLibrary, @NotNull DependencyFiles files) {
        if (androidLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidLibrary", "com/android/tools/idea/gradle/project/ProjectStructureUsageTracker", "addAarLibraryAndDependencies"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/gradle/project/ProjectStructureUsageTracker", "addAarLibraryAndDependencies"));
        }
        String gradlePath = androidLibrary.getProject();
        if (StringUtil.isEmpty((String)gradlePath)) {
            File file = androidLibrary.getJarFile();
            if (files.aars.contains(file)) {
                return;
            }
            files.aars.add(file);
            for (AndroidLibrary library : androidLibrary.getLibraryDependencies()) {
                ProjectStructureUsageTracker.addAarLibraryAndDependencies(library, files);
            }
        }
    }

    private static class DependencyFiles {
        final Set<File> aars = Sets.newHashSet();
        final Set<File> jars = Sets.newHashSet();

        private DependencyFiles() {
        }
    }
}

