/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class GradleDslElement {
    @Nullable
    protected final GradleDslElement myParent;
    @NotNull
    protected final String myName;
    @Nullable
    private GroovyPsiElement myPsiElement;
    private volatile boolean myModified;

    protected GradleDslElement(@Nullable GradleDslElement parent, @Nullable GroovyPsiElement psiElement, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElement", "<init>"));
        }
        this.myParent = parent;
        this.myPsiElement = psiElement;
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElement", "getName"));
        }
        return string;
    }

    @Nullable
    public GroovyPsiElement getPsiElement() {
        return this.myPsiElement;
    }

    public void setPsiElement(@Nullable GroovyPsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @Nullable
    public GroovyPsiElement create() {
        String statementText;
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement != null) {
            return psiElement;
        }
        if (this.myParent == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = this.myParent.create();
        if (parentPsiElement == null) {
            return null;
        }
        Project project = parentPsiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GrStatement statement = factory.createStatementFromText((CharSequence)(statementText = this.isBlockElement() ? this.myName + " {\n}\n" : this.myName + " \"abc\", \"xyz\""));
        if (statement instanceof GrApplicationStatement) {
            ((GrApplicationStatement)statement).getArgumentList().delete();
        }
        PsiElement addedElement = parentPsiElement.addBefore((PsiElement)statement, parentPsiElement.getLastChild());
        if (this.isBlockElement()) {
            GrClosableBlock closableBlock = GradleDslElement.getClosableBlock(addedElement);
            if (closableBlock != null) {
                this.setPsiElement((GroovyPsiElement)closableBlock);
            }
        } else if (addedElement instanceof GrApplicationStatement) {
            this.setPsiElement((GroovyPsiElement)((GrApplicationStatement)addedElement));
        }
        PsiElement lineTerminator = factory.createLineTerminator(1);
        parentPsiElement.addAfter(lineTerminator, addedElement);
        return this.getPsiElement();
    }

    protected void delete() {
        for (GradleDslElement element : this.getChildren()) {
            element.delete();
        }
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement != null && psiElement.isValid()) {
            psiElement.delete();
        }
        this.setPsiElement(null);
    }

    protected void setModified(boolean modified) {
        this.myModified = modified;
        if (this.myParent != null && modified) {
            this.myParent.setModified(true);
        }
    }

    public boolean isModified() {
        return this.myModified;
    }

    protected boolean isBlockElement() {
        return false;
    }

    @NotNull
    protected abstract Collection<GradleDslElement> getChildren();

    public final void applyChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.apply();
        this.setModified(false);
    }

    protected abstract void apply();

    public final void resetState() {
        this.reset();
        this.setModified(false);
    }

    protected abstract void reset();

    @Nullable
    private static GrClosableBlock getClosableBlock(PsiElement element) {
        if (!(element instanceof GrMethodCallExpression)) {
            return null;
        }
        GrClosableBlock[] closureArguments = ((GrMethodCallExpression)element).getClosureArguments();
        if (closureArguments.length > 0) {
            return closureArguments[0];
        }
        return null;
    }
}

