/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.android;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.customizer.dependency.LibraryDependency;
import com.android.tools.idea.gradle.customizer.dependency.ModuleDependency;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.messages.ProjectSyncMessages;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.NotNull;

public class DependenciesModuleCustomizer
extends AbstractDependenciesModuleCustomizer<AndroidGradleModel>
implements BuildVariantModuleCustomizer<AndroidGradleModel> {
    @Override
    protected void setUpDependencies(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidGradleModel androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "setUpDependencies"));
        }
        DependencySet dependencies = Dependency.extractFrom(androidProject);
        for (LibraryDependency libraryDependency : dependencies.onLibraries()) {
            DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, libraryDependency, androidProject.getAndroidProject());
        }
        for (ModuleDependency moduleDependency : dependencies.onModules()) {
            this.updateModuleDependency(module, modelsProvider, moduleDependency, androidProject.getAndroidProject());
        }
        DependenciesModuleCustomizer.addExtraSdkLibrariesAsDependencies(modelsProvider, module, androidProject.getAndroidProject());
        ProjectSyncMessages messages = ProjectSyncMessages.getInstance(module.getProject());
        Collection<SyncIssue> collection = androidProject.getSyncIssues();
        if (collection != null) {
            messages.reportSyncIssues(collection, module);
        } else {
            Collection unresolvedDependencies = androidProject.getAndroidProject().getUnresolvedDependencies();
            messages.reportUnresolvedDependencies(unresolvedDependencies, module);
        }
    }

    private void updateModuleDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleDependency dependency, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateModuleDependency"));
        }
        Module moduleDependency = null;
        for (Module m : modelsProvider.getModules()) {
            String gradlePath;
            AndroidGradleFacet androidGradleFacet = AndroidGradleFacet.getInstance(m);
            if (androidGradleFacet == null || !Objects.equal((Object)(gradlePath = ((AndroidGradleFacetConfiguration)androidGradleFacet.getConfiguration()).GRADLE_PROJECT_PATH), (Object)dependency.getGradlePath())) continue;
            moduleDependency = m;
            break;
        }
        LibraryDependency compiledArtifact = dependency.getBackupDependency();
        if (moduleDependency != null) {
            ModuleOrderEntry orderEntry = modelsProvider.getModifiableRootModel(module).addModuleOrderEntry(moduleDependency);
            orderEntry.setExported(true);
            if (compiledArtifact != null) {
                Projects.setModuleCompiledArtifact(moduleDependency, compiledArtifact);
            }
            return;
        }
        String backupName = compiledArtifact != null ? compiledArtifact.getName() : null;
        DependencySetupErrors setupErrors = this.getSetupErrors(module.getProject());
        setupErrors.addMissingModule(dependency.getGradlePath(), module.getName(), backupName);
        if (compiledArtifact != null) {
            DependenciesModuleCustomizer.updateLibraryDependency(module, modelsProvider, compiledArtifact, androidProject);
        }
    }

    public static void updateLibraryDependency(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull LibraryDependency dependency, @NotNull AndroidProject androidProject) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "updateLibraryDependency"));
        }
        Collection<String> binaryPaths = dependency.getPaths(LibraryDependency.PathType.BINARY);
        Collection<String> sourcePaths = dependency.getPaths(LibraryDependency.PathType.SOURCE);
        Collection<String> docPaths = dependency.getPaths(LibraryDependency.PathType.DOC);
        DependenciesModuleCustomizer.setUpLibraryDependency(module, modelsProvider, dependency.getName(), dependency.getScope(), binaryPaths, sourcePaths, docPaths);
        File buildFolder = androidProject.getBuildFolder();
        ContentEntry[] contentEntries = modelsProvider.getModifiableRootModel(module).getContentEntries();
        for (String binaryPath : binaryPaths) {
            ContentEntry parentContentEntry;
            File parent = new File(binaryPath).getParentFile();
            if (parent == null || !"jars".equals(parent.getName()) || !FileUtil.isAncestor((File)buildFolder, (File)parent, (boolean)true) || (parentContentEntry = FilePaths.findParentContentEntry(parent, contentEntries)) == null) continue;
            parentContentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl(parent));
        }
    }

    private static void addExtraSdkLibrariesAsDependencies(@NotNull IdeModifiableModelsProvider moduleModel, Module module, @NotNull AndroidProject androidProject) {
        SdkAdditionalData data;
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "addExtraSdkLibrariesAsDependencies"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "addExtraSdkLibrariesAsDependencies"));
        }
        Sdk sdk = moduleModel.getModifiableRootModel(module).getSdk();
        assert (sdk != null);
        String suffix = null;
        AndroidSdkData sdkData = AndroidSdkData.getSdkData(sdk);
        if (sdkData != null && (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData) {
            VirtualFile[] androidSdkData = (VirtualFile[])data;
            suffix = androidSdkData.getBuildTargetHashString();
        }
        if (suffix == null) {
            suffix = androidProject.getCompileTarget();
        }
        HashSet currentIdeSdkFilePaths = Sets.newHashSetWithExpectedSize((int)5);
        for (VirtualFile sdkFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            File sdkFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)sdkFile);
            currentIdeSdkFilePaths.add(sdkFilePath.getPath());
        }
        Collection bootClasspath = androidProject.getBootClasspath();
        for (String library : bootClasspath) {
            if (!StringUtil.isNotEmpty((String)library) || currentIdeSdkFilePaths.contains(library)) continue;
            File binaryPath = new File(library);
            String name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)library);
            name = name + "-" + suffix;
            DependenciesModuleCustomizer.setUpLibraryDependency(module, moduleModel, name, DependencyScope.COMPILE, Collections.singletonList(library));
        }
    }

    @Override
    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public Class<AndroidGradleModel> getSupportedModelType() {
        if (AndroidGradleModel.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/customizer/android/DependenciesModuleCustomizer", "getSupportedModelType"));
        }
        return AndroidGradleModel.class;
    }
}

