/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    @NotNull
    private final StyleResourceValue myStyleResourceValue;
    @NotNull
    private final Configuration myConfiguration;
    private final Project myProject;
    @Nullable
    private final Module mySourceModule;

    public ThemeEditorStyle(@NotNull Configuration configuration, @NotNull StyleResourceValue styleResourceValue, @Nullable Module sourceModule) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        if (styleResourceValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styleResourceValue", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "<init>"));
        }
        this.myStyleResourceValue = styleResourceValue;
        this.myConfiguration = configuration;
        this.myProject = configuration.getModule().getProject();
        this.mySourceModule = sourceModule;
    }

    @NotNull
    public String getQualifiedName() {
        String string = ResolutionUtils.getQualifiedStyleName(this.myStyleResourceValue);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myStyleResourceValue.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getName"));
        }
        return string;
    }

    @NotNull
    public String getStyleResourceUrl() {
        String string = ResourceUrl.create((ResourceValue)this.myStyleResourceValue).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getStyleResourceUrl"));
        }
        return string;
    }

    public boolean isProjectStyle() {
        if (this.myStyleResourceValue.isFramework()) {
            return false;
        }
        ProjectResourceRepository repository = ProjectResourceRepository.getProjectResources(this.myConfiguration.getModule(), true);
        assert (repository != null) : this.myConfiguration.getModule().getName();
        return repository.hasResourceItem(ResourceType.STYLE, this.myStyleResourceValue.getName());
    }

    @NotNull
    public StyleResourceValue getStyleResourceValue() {
        StyleResourceValue styleResourceValue = this.myStyleResourceValue;
        if (styleResourceValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getStyleResourceValue"));
        }
        return styleResourceValue;
    }

    @NotNull
    private Collection<com.android.ide.common.res2.ResourceItem> getStyleResourceItems() {
        ImmutableList resultItems;
        assert (!this.isFramework());
        if (this.isProjectStyle()) {
            Module module = this.getModuleForAcquiringResources();
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : module.getName() + " module doesn't have AndroidFacet";
            final HashMap resourceItems = Maps.newHashMap();
            ThemeEditorUtils.acceptResourceResolverVisitor(facet, new ThemeEditorUtils.ResourceFolderVisitor(){

                @Override
                public void visitResourceFolder(@NotNull LocalResourceRepository resources, String moduleName, @NotNull String variantName, boolean isSourceSelected) {
                    if (resources == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle$1", "visitResourceFolder"));
                    }
                    if (variantName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle$1", "visitResourceFolder"));
                    }
                    if (!isSourceSelected) {
                        return;
                    }
                    List items = resources.getResourceItem(ResourceType.STYLE, ThemeEditorStyle.this.myStyleResourceValue.getName());
                    if (items == null) {
                        return;
                    }
                    for (com.android.ide.common.res2.ResourceItem item : items) {
                        String key = item.getConfiguration().toShortDisplayString() + "/" + item.getName();
                        resourceItems.put(key, item);
                    }
                }
            });
            resultItems = ImmutableList.copyOf(resourceItems.values());
        } else {
            AppResourceRepository resourceRepository = AppResourceRepository.getAppResources(this.getModuleForAcquiringResources(), true);
            assert (resourceRepository != null);
            ImmutableList items = resourceRepository.getResourceItem(ResourceType.STYLE, this.getName());
            resultItems = items != null ? items : Collections.emptyList();
        }
        ImmutableList immutableList = resultItems;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getStyleResourceItems"));
        }
        return immutableList;
    }

    private Module getModuleForAcquiringResources() {
        return this.mySourceModule != null ? this.mySourceModule : this.myConfiguration.getModule();
    }

    public boolean isReadOnly() {
        return !this.isProjectStyle();
    }

    @NotNull
    public ImmutableCollection<ConfiguredElement<ItemResourceValue>> getConfiguredValues() {
        ImmutableList.Builder itemResourceValues = ImmutableList.builder();
        if (this.isFramework()) {
            assert (this.myConfiguration.getFrameworkResources() != null);
            ResourceItem styleItem = this.myConfiguration.getFrameworkResources().getResourceItem(ResourceType.STYLE, this.myStyleResourceValue.getName());
            for (ResourceFile file : styleItem.getSourceFileList()) {
                ResourceValue styleResourceValue = styleItem.getResourceValue(ResourceType.STYLE, file.getConfiguration(), true);
                FolderConfiguration folderConfiguration = file.getConfiguration();
                if (!(styleResourceValue instanceof StyleResourceValue)) continue;
                for (ItemResourceValue value : ((StyleResourceValue)styleResourceValue).getValues()) {
                    itemResourceValues.add(ConfiguredElement.create(folderConfiguration, value));
                }
            }
        } else {
            AppResourceRepository repository = AppResourceRepository.getAppResources(this.myConfiguration.getModule(), true);
            assert (repository != null);
            List styleDefinitions = repository.getResourceItem(ResourceType.STYLE, this.myStyleResourceValue.getName());
            assert (styleDefinitions != null);
            for (com.android.ide.common.res2.ResourceItem styleDefinition : styleDefinitions) {
                ResourceValue styleResourceValue = styleDefinition.getResourceValue(this.isFramework());
                FolderConfiguration folderConfiguration = styleDefinition.getConfiguration();
                if (!(styleResourceValue instanceof StyleResourceValue)) continue;
                for (ItemResourceValue value : ((StyleResourceValue)styleResourceValue).getValues()) {
                    itemResourceValues.add(ConfiguredElement.create(folderConfiguration, value));
                }
            }
        }
        ImmutableList immutableList = itemResourceValues.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getConfiguredValues"));
        }
        return immutableList;
    }

    public boolean hasItem(@Nullable EditedStyleItem item) {
        return item != null && this.getStyleResourceValue().getItem(item.getName(), item.isFrameworkAttr()) != null;
    }

    public ItemResourceValue getItem(@NotNull String name, boolean isFramework) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getItem"));
        }
        return this.getStyleResourceValue().getItem(name, isFramework);
    }

    public ThemeEditorStyle getParent() {
        return this.getParent(null);
    }

    public Collection<ConfiguredElement<String>> getParentNames() {
        if (this.isFramework()) {
            ThemeEditorStyle parent = this.getParent();
            if (parent != null) {
                return ImmutableList.of(ConfiguredElement.create(this.getConfiguration().getEditedConfig(), parent.getQualifiedName()));
            }
            return Collections.emptyList();
        }
        ImmutableList.Builder parents = ImmutableList.builder();
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            StyleResourceValue style = (StyleResourceValue)styleItem.getResourceValue(false);
            assert (style != null);
            String parentName = ResolutionUtils.getParentQualifiedName(style);
            if (parentName == null) continue;
            parents.add(ConfiguredElement.create(styleItem.getConfiguration(), parentName));
        }
        return parents.build();
    }

    @Nullable(value="if this is a root style")
    public ThemeEditorStyle getParent(@Nullable ThemeResolver themeResolver) {
        ResourceResolver resolver = this.myConfiguration.getResourceResolver();
        assert (resolver != null);
        StyleResourceValue parent = resolver.getParent(this.getStyleResourceValue());
        if (parent == null) {
            return null;
        }
        if (themeResolver == null) {
            return ResolutionUtils.getStyle(this.myConfiguration, ResolutionUtils.getQualifiedStyleName(parent), null);
        }
        return themeResolver.getTheme(ResolutionUtils.getQualifiedStyleName(parent));
    }

    @Nullable(value="if the attribute does not exist in this theme")
    private XmlTag getValueTag(@NotNull XmlTag sourceTag, final @NotNull String attribute) {
        if (sourceTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceTag", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValueTag"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getValueTag"));
        }
        if (!this.isProjectStyle()) {
            return null;
        }
        final Ref resultXmlTag = new Ref();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        sourceTag.acceptChildren(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (!(element instanceof XmlTag)) {
                    return;
                }
                XmlTag tag = (XmlTag)element;
                if ("item".equals(tag.getName()) && attribute.equals(tag.getAttributeValue("name"))) {
                    resultXmlTag.set((Object)tag);
                }
            }
        });
        return (XmlTag)resultXmlTag.get();
    }

    @Nullable(value="if there is no style from this configuration")
    private XmlTag findXmlTagFromConfiguration(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "findXmlTagFromConfiguration"));
        }
        for (com.android.ide.common.res2.ResourceItem item : this.getStyleResourceItems()) {
            if (!item.getConfiguration().equals((Object)configuration)) continue;
            return LocalResourceRepository.getItemTag(this.myProject, item);
        }
        return null;
    }

    @NotNull
    private ImmutableCollection<FolderConfiguration> findToBeCopied(int desiredApi) {
        HashMap bestVersionCopyFrom = Maps.newHashMap();
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            FolderConfiguration configuration = FolderConfiguration.copyOf((FolderConfiguration)styleItem.getConfiguration());
            int styleItemVersion = ThemeEditorUtils.getVersionFromConfiguration(configuration);
            configuration.setVersionQualifier(null);
            if (styleItemVersion > desiredApi || bestVersionCopyFrom.containsKey(configuration) && ((VersionQualifier)bestVersionCopyFrom.get(configuration)).getVersion() >= styleItemVersion) continue;
            bestVersionCopyFrom.put(configuration, new VersionQualifier(styleItemVersion));
        }
        ImmutableList.Builder toBeCopied = ImmutableList.builder();
        for (FolderConfiguration key : bestVersionCopyFrom.keySet()) {
            FolderConfiguration configuration = FolderConfiguration.copyOf((FolderConfiguration)key);
            VersionQualifier version = (VersionQualifier)bestVersionCopyFrom.get(key);
            if (version.getVersion() != -1) {
                configuration.setVersionQualifier(version);
            }
            if (version.getVersion() >= desiredApi) continue;
            toBeCopied.add((Object)configuration);
        }
        ImmutableList immutableList = toBeCopied.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "findToBeCopied"));
        }
        return immutableList;
    }

    private void setValue(@NotNull FolderConfiguration configuration, @NotNull String attribute, @NotNull String value) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag styleTag = this.findXmlTagFromConfiguration(configuration);
        assert (styleTag != null);
        XmlTag tag = this.getValueTag(styleTag, attribute);
        if (tag != null) {
            tag.getValue().setEscapedText(value);
        } else {
            XmlTag child = styleTag.createChildTag("item", styleTag.getNamespace(), value, false);
            child.setAttribute("name", attribute);
            styleTag.addSubTag(child, false);
        }
    }

    public void setValue(final @NotNull String attribute, final @NotNull String value) {
        int minSdk;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setValue"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        int maxApi = Math.max(ResolutionUtils.getOriginalApiLevel(value, this.myProject), ResolutionUtils.getOriginalApiLevel(attribute, this.myProject));
        final int desiredApi = maxApi <= (minSdk = ThemeEditorUtils.getMinApiLevel(this.myConfiguration.getModule())) ? -1 : maxApi;
        new WriteCommandAction.Simple(this.myProject, "Setting value of " + attribute, new PsiFile[0]){

            protected void run() {
                AndroidFacet facet;
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(ThemeEditorStyle.this.myProject);
                ImmutableCollection toBeCopied = ThemeEditorStyle.this.findToBeCopied(desiredApi);
                for (FolderConfiguration configuration : toBeCopied) {
                    XmlTag styleTag = ThemeEditorStyle.this.findXmlTagFromConfiguration(configuration);
                    assert (styleTag != null);
                    ThemeEditorUtils.copyTheme(desiredApi, styleTag);
                }
                if (!toBeCopied.isEmpty() && (facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myConfiguration.getModule())) != null) {
                    facet.refreshResources();
                }
                Collection styleItems = ThemeEditorStyle.this.getStyleResourceItems();
                for (com.android.ide.common.res2.ResourceItem style : styleItems) {
                    FolderConfiguration configuration = style.getConfiguration();
                    int version = ThemeEditorUtils.getVersionFromConfiguration(configuration);
                    if (version < desiredApi) continue;
                    ThemeEditorStyle.this.setValue(configuration, attribute, value);
                }
            }
        }.execute();
    }

    private void setParent(@NotNull FolderConfiguration configuration, @NotNull String newParent) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag styleTag = this.findXmlTagFromConfiguration(configuration);
        assert (styleTag != null);
        styleTag.setAttribute("parent", newParent);
    }

    public void setParent(final @NotNull String qualifiedThemeName) {
        int minSdk;
        if (qualifiedThemeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedThemeName", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "setParent"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        assert (!qualifiedThemeName.startsWith("@android:style/"));
        assert (!qualifiedThemeName.startsWith("@style/"));
        String newParentResourceUrl = ResolutionUtils.getStyleResourceUrl(qualifiedThemeName);
        int parentApi = ResolutionUtils.getOriginalApiLevel(newParentResourceUrl, this.myProject);
        final int desiredApi = parentApi <= (minSdk = ThemeEditorUtils.getMinApiLevel(this.myConfiguration.getModule())) ? -1 : parentApi;
        new WriteCommandAction.Simple(this.myProject, "Updating Parent to " + qualifiedThemeName, null){

            protected void run() {
                AndroidFacet facet;
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(ThemeEditorStyle.this.myProject);
                ImmutableCollection toBeCopied = ThemeEditorStyle.this.findToBeCopied(desiredApi);
                for (FolderConfiguration configuration : toBeCopied) {
                    XmlTag styleTag = ThemeEditorStyle.this.findXmlTagFromConfiguration(configuration);
                    assert (styleTag != null);
                    ThemeEditorUtils.copyTheme(desiredApi, styleTag);
                }
                if (!toBeCopied.isEmpty() && (facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myConfiguration.getModule())) != null) {
                    facet.refreshResources();
                }
                Collection styleItems = ThemeEditorStyle.this.getStyleResourceItems();
                for (com.android.ide.common.res2.ResourceItem style : styleItems) {
                    FolderConfiguration configuration = style.getConfiguration();
                    int version = ThemeEditorUtils.getVersionFromConfiguration(configuration);
                    if (version < desiredApi) continue;
                    ThemeEditorStyle.this.setParent(configuration, qualifiedThemeName);
                }
            }
        }.execute();
    }

    public String toString() {
        if (!this.isReadOnly()) {
            return "[" + this.getName() + "]";
        }
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ThemeEditorStyle)) {
            return false;
        }
        return this.getQualifiedName().equals(((ThemeEditorStyle)obj).getQualifiedName());
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "getConfiguration"));
        }
        return configuration;
    }

    public void removeAttribute(@NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle", "removeAttribute"));
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        HashSet toBeEdited = new HashSet();
        HashSet toBeRemoved = new HashSet();
        for (com.android.ide.common.res2.ResourceItem resourceItem : this.getStyleResourceItems()) {
            XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myProject, resourceItem);
            assert (sourceXml != null);
            XmlTag tag = this.getValueTag(sourceXml, attribute);
            if (tag == null) continue;
            toBeEdited.add(tag.getContainingFile());
            toBeRemoved.add(tag);
        }
        new WriteCommandAction.Simple(this.myProject, "Removing " + attribute, toBeEdited.toArray(new PsiFile[toBeEdited.size()]), (Collection)toBeRemoved){
            final /* synthetic */ Collection val$toBeRemoved;
            {
                this.val$toBeRemoved = collection;
                super(x0, x1, x2);
            }

            protected void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(ThemeEditorStyle.this.myProject);
                for (XmlTag tag : this.val$toBeRemoved) {
                    tag.delete();
                }
            }
        }.execute();
    }

    @Nullable
    public PsiElement getNamePsiElement() {
        Collection<com.android.ide.common.res2.ResourceItem> resources = this.getStyleResourceItems();
        if (resources.isEmpty()) {
            return null;
        }
        XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myProject, resources.iterator().next());
        assert (sourceXml != null);
        XmlAttribute nameAttribute = sourceXml.getAttribute("name");
        if (nameAttribute == null) {
            return null;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return null;
        }
        return new ValueResourceElementWrapper(attributeValue);
    }

    @Nullable
    public Module getSourceModule() {
        return this.mySourceModule;
    }

    public boolean isPublic() {
        if (!this.isFramework()) {
            return true;
        }
        IAndroidTarget target = this.myConfiguration.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myConfiguration.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE.getName(), this.getName());
    }

    public boolean isFramework() {
        return this.myStyleResourceValue.isFramework();
    }
}

