/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceUrl;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.configurations.ThemeSelectionPanel;
import com.android.tools.idea.editors.theme.NewStyleDialog;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditor;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ResourceFolderRegistry;
import com.android.tools.idea.rendering.ResourceFolderRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ChooseResourceDialog;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorUtils {
    private static final Logger LOG = Logger.getInstance(ThemeEditorUtils.class);
    private static final Cache<String, String> ourTooltipCache = CacheBuilder.newBuilder().weakValues().maximumSize(30L).build();
    private static final Set<String> DEFAULT_THEMES = ImmutableSet.of((Object)"Theme.AppCompat.NoActionBar", (Object)"Theme.AppCompat.Light.NoActionBar");
    private static final Set<String> DEFAULT_THEMES_FALLBACK = ImmutableSet.of((Object)"Theme.Material.NoActionBar", (Object)"Theme.Material.Light.NoActionBar");
    private static final String[] CUSTOM_WIDGETS_JAR_PATHS = new String[]{"/plugins/android/lib/androidWidgets/theme-editor-widgets.jar", "/../adt/idea/android/lib/androidWidgets/theme-editor-widgets.jar", "/community/android/android/lib/androidWidgets/theme-editor-widgets.jar"};

    private ThemeEditorUtils() {
    }

    @NotNull
    public static String generateToolTipText(@NotNull ItemResourceValue resValue, @NotNull Module module, @NotNull Configuration configuration) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        AppResourceRepository repository = AppResourceRepository.getAppResources(module, true);
        if (repository == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
            }
            return "";
        }
        String tooltipKey = resValue.toString() + module.toString() + configuration.toString() + ((LocalResourceRepository)repository).getModificationCount();
        String cachedTooltip = (String)ourTooltipCache.getIfPresent((Object)tooltipKey);
        if (cachedTooltip != null) {
            String string = cachedTooltip;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
            }
            return string;
        }
        String tooltipContents = AndroidJavaDocRenderer.renderItemResourceWithDoc(module, configuration, resValue);
        ourTooltipCache.put((Object)tooltipKey, (Object)tooltipContents);
        String string = tooltipContents;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        return string;
    }

    @NotNull
    public static String getDisplayHtml(EditedStyleItem item) {
        String string = item.isDeprecated() ? "<html><body><strike>" + item.getQualifiedName() + "</strike></body></html>" : item.getQualifiedName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDisplayHtml"));
        }
        return string;
    }

    public static boolean isThemeEditorSelected(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "isThemeEditorSelected"));
        }
        for (FileEditor editor : FileEditorManager.getInstance((Project)project).getSelectedEditors()) {
            if (!(editor instanceof ThemeEditor)) continue;
            return true;
        }
        return false;
    }

    public static void openThemeEditor(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "openThemeEditor"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ThemeEditorVirtualFile file = null;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                for (FileEditor editor : fileEditorManager.getAllEditors()) {
                    ThemeEditor themeEditor;
                    if (!(editor instanceof ThemeEditor) || (themeEditor = (ThemeEditor)editor).getVirtualFile().getProject() != project) continue;
                    file = themeEditor.getVirtualFile();
                    break;
                }
                if (file == null) {
                    file = ThemeEditorVirtualFile.getThemeEditorFile(project);
                }
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
                fileEditorManager.openEditor(descriptor, true);
            }
        });
    }

    private static void findAllAttributes(@NotNull ThemeEditorStyle style, @NotNull HashMultimap<String, FolderConfiguration> attributeConfigurations, @NotNull ThemeResolver resolver) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findAllAttributes"));
        }
        if (attributeConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeConfigurations", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findAllAttributes"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findAllAttributes"));
        }
        for (ConfiguredElement<String> parentName : style.getParentNames()) {
            ThemeEditorStyle parent = resolver.getTheme(parentName.getElement());
            if (parent == null) continue;
            ThemeEditorUtils.findAllAttributes(parent, attributeConfigurations, resolver);
        }
        ImmutableCollection<ConfiguredElement<ItemResourceValue>> configuredValues = style.getConfiguredValues();
        for (ConfiguredElement value : configuredValues) {
            attributeConfigurations.put((Object)ResolutionUtils.getQualifiedItemName((ItemResourceValue)value.getElement()), (Object)value.getConfiguration());
        }
    }

    public static List<EditedStyleItem> resolveAllAttributes(@NotNull ThemeEditorStyle style, @NotNull ThemeResolver themeResolver) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "resolveAllAttributes"));
        }
        if (themeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeResolver", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "resolveAllAttributes"));
        }
        HashMultimap attributes = HashMultimap.create();
        ThemeEditorUtils.findAllAttributes(style, (HashMultimap<String, FolderConfiguration>)attributes, themeResolver);
        ImmutableSet allConfigurations = ImmutableSet.copyOf((Collection)attributes.values());
        Configuration configuration = style.getConfiguration();
        ResourceResolverCache resolverCache = new ResourceResolverCache(configuration.getConfigurationManager());
        HashMap configuredAttributes = Maps.newHashMap();
        FolderConfiguration fullBaseConfiguration = themeResolver.getConfiguration().getFullConfig();
        for (FolderConfiguration folderConfiguration : allConfigurations) {
            FolderConfiguration fullFolderConfiguration = FolderConfiguration.copyOf((FolderConfiguration)fullBaseConfiguration);
            fullFolderConfiguration.add(folderConfiguration);
            ResourceResolver resolver = resolverCache.getResourceResolver(configuration.getTarget(), style.getStyleResourceUrl(), fullFolderConfiguration);
            StyleResourceValue resolvedStyle = resolver.getStyle(style.getName(), style.isFramework());
            if (resolvedStyle == null) continue;
            for (String attributeName : attributes.keys()) {
                String noPrefixName;
                ResourceValue value = resolver.findItemInStyle(resolvedStyle, noPrefixName, (noPrefixName = StringUtil.trimStart((String)attributeName, (String)"android:")).length() != attributeName.length());
                if (value == null) continue;
                AttributeInheritanceSet inheritanceSet = (AttributeInheritanceSet)configuredAttributes.get(attributeName);
                if (inheritanceSet == null) {
                    inheritanceSet = new AttributeInheritanceSet();
                    configuredAttributes.put(attributeName, inheritanceSet);
                }
                inheritanceSet.add(ConfiguredElement.create(folderConfiguration, (ItemResourceValue)value));
            }
        }
        ImmutableList.Builder allValues = ImmutableList.builder();
        for (String attributeName : configuredAttributes.keySet()) {
            Iterable configuredValues = (Iterable)configuredAttributes.get(attributeName);
            final ConfiguredElement bestMatch = (ConfiguredElement)style.getConfiguration().getFullConfig().findMatchingConfigurable((List)ImmutableList.copyOf((Iterable)configuredValues));
            if (bestMatch == null) {
                allValues.add((Object)new EditedStyleItem((ConfiguredElement)configuredValues.iterator().next(), style));
                continue;
            }
            allValues.add((Object)new EditedStyleItem(bestMatch, Iterables.filter((Iterable)configuredValues, (Predicate)new Predicate<ConfiguredElement<ItemResourceValue>>(){

                public boolean apply(@Nullable ConfiguredElement<ItemResourceValue> input) {
                    return input != bestMatch;
                }
            }), style));
        }
        return allValues.build();
    }

    @Nullable(value="if there is not an item with that name")
    public static ItemResourceValue resolveItemFromParents(@NotNull ThemeEditorStyle theme, @NotNull String name, boolean isFrameworkAttr) {
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "resolveItemFromParents"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "resolveItemFromParents"));
        }
        ThemeEditorStyle currentTheme = theme;
        for (int i = 0; i < 50 && currentTheme != null; currentTheme = currentTheme.getParent(), ++i) {
            ItemResourceValue item = currentTheme.getItem(name, isFrameworkAttr);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Nullable
    public static Object extractRealValue(@NotNull EditedStyleItem item, @NotNull Class<?> desiredClass) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "extractRealValue"));
        }
        if (desiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desiredClass", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "extractRealValue"));
        }
        String value = item.getValue();
        if (desiredClass == Boolean.class && ("true".equals(value) || "false".equals(value))) {
            return Boolean.valueOf(value);
        }
        if (desiredClass == Integer.class) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    public static boolean acceptsFormat(@Nullable AttributeDefinition attrDefByName, @NotNull AttributeFormat want) {
        if (want == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "want", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "acceptsFormat"));
        }
        if (attrDefByName == null) {
            return false;
        }
        return attrDefByName.getFormats().contains((Object)want);
    }

    @NotNull
    private static ImmutableCollection<ThemeEditorStyle> findThemes(@NotNull Collection<ThemeEditorStyle> themes, final @NotNull Set<String> names) {
        if (themes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themes", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        ImmutableSet immutableSet = ImmutableSet.copyOf((Iterable)Iterables.filter(themes, (Predicate)new Predicate<ThemeEditorStyle>(){

            public boolean apply(@Nullable ThemeEditorStyle theme) {
                return theme != null && names.contains(theme.getName());
            }
        }));
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        return immutableSet;
    }

    @NotNull
    public static ImmutableList<Module> findAndroidModules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findAndroidModules"));
        }
        ModuleManager manager = ModuleManager.getInstance((Project)project);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Module module : manager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) continue;
            builder.add((Object)module);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findAndroidModules"));
        }
        return immutableList;
    }

    @NotNull
    public static ImmutableList<String> getDefaultThemeNames(@NotNull ThemeResolver themeResolver) {
        if (themeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeResolver", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultThemeNames"));
        }
        ImmutableList<ThemeEditorStyle> readOnlyLibThemes = themeResolver.getExternalLibraryThemes();
        HashSet<ThemeEditorStyle> foundThemes = new HashSet<ThemeEditorStyle>();
        foundThemes.addAll((Collection<ThemeEditorStyle>)ThemeEditorUtils.findThemes(readOnlyLibThemes, DEFAULT_THEMES));
        if (foundThemes.isEmpty()) {
            ImmutableList<ThemeEditorStyle> readOnlyFrameworkThemes = themeResolver.getFrameworkThemes();
            foundThemes = new HashSet();
            foundThemes.addAll((Collection<ThemeEditorStyle>)ThemeEditorUtils.findThemes(readOnlyFrameworkThemes, DEFAULT_THEMES_FALLBACK));
            if (foundThemes.isEmpty()) {
                foundThemes.addAll((Collection<ThemeEditorStyle>)readOnlyLibThemes);
                foundThemes.addAll((Collection<ThemeEditorStyle>)readOnlyFrameworkThemes);
            }
        }
        TreeSet temporarySet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (ThemeEditorStyle theme : foundThemes) {
            temporarySet.add(theme.getQualifiedName());
        }
        ImmutableList immutableList = ImmutableList.copyOf((Collection)temporarySet);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultThemeNames"));
        }
        return immutableList;
    }

    public static int getMinApiLevel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getMinApiLevel"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return 1;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        return moduleInfo.getMinSdkVersion().getApiLevel();
    }

    @Nullable
    public static URL getCustomWidgetsJarUrl() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : CUSTOM_WIDGETS_JAR_PATHS) {
            String jarPath = homePath + path;
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (root != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                if (!rootFile.exists()) continue;
                try {
                    LOG.debug("Theme editor custom widgets found at " + jarPath);
                    return rootFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                    continue;
                }
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.error("Unable to find theme-editor-widgets.jar in paths:\n" + notFoundPaths.toString());
        return null;
    }

    public static boolean createNewStyle(final @NotNull Module module, final @NotNull String newStyleName, final @Nullable String parentStyleName, final @NotNull String fileName, final @NotNull List<String> folderNames) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        if (newStyleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStyleName", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        if (folderNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderNames", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createNewStyle"));
        }
        return (Boolean)new WriteCommandAction<Boolean>(module.getProject(), "Create new style " + newStyleName, new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/editors/theme/ThemeEditorUtils$4", "run"));
                }
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(module.getProject());
                result.setResult((Object)AndroidResourceUtil.createValueResource(module, newStyleName, null, ResourceType.STYLE, fileName, folderNames, new Processor<ResourceElement>(){

                    public boolean process(ResourceElement element) {
                        assert (element instanceof Style);
                        Style style = (Style)element;
                        if (parentStyleName != null) {
                            style.getParentStyle().setStringValue(parentStyleName);
                        }
                        return true;
                    }
                }));
            }
        }.execute().getResultObject();
    }

    @Nullable
    public static String showCreateNewStyleDialog(@Nullable ThemeEditorStyle defaultParentStyle, @NotNull ThemeEditorContext themeEditorContext, boolean isTheme, boolean enableParentChoice, @Nullable String message, @Nullable ThemeSelectionPanel.ThemeChangedListener themeChangedListener) {
        boolean createStyle;
        if (themeEditorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeEditorContext", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "showCreateNewStyleDialog"));
        }
        String defaultParentStyleName = null;
        if (isTheme && defaultParentStyle == null) {
            defaultParentStyleName = (String)ThemeEditorUtils.getDefaultThemeNames(themeEditorContext.getThemeResolver()).get(0);
        } else if (defaultParentStyle != null) {
            defaultParentStyleName = defaultParentStyle.getQualifiedName();
        }
        NewStyleDialog dialog = new NewStyleDialog(isTheme, themeEditorContext, defaultParentStyleName, defaultParentStyle == null ? null : defaultParentStyle.getName(), message);
        dialog.enableParentChoice(enableParentChoice);
        if (themeChangedListener != null) {
            dialog.setThemeChangedListener(themeChangedListener);
        }
        if (!(createStyle = dialog.showAndGet())) {
            return null;
        }
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(themeEditorContext.getCurrentContextModule());
        int minAcceptableApi = ResolutionUtils.getOriginalApiLevel(ResolutionUtils.getStyleResourceUrl(dialog.getStyleParentName()), themeEditorContext.getProject());
        String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STYLE);
        FolderConfiguration config = new FolderConfiguration();
        if (minModuleApi < minAcceptableApi) {
            VersionQualifier qualifier = new VersionQualifier(minAcceptableApi);
            config.setVersionQualifier(qualifier);
        }
        List<String> dirNames = Collections.singletonList(config.getFolderName(ResourceFolderType.VALUES));
        if (fileName == null) {
            LOG.error("Couldn't find a default filename for ResourceType.STYLE");
            return null;
        }
        String parentStyleName = dialog.getStyleParentName();
        boolean isCreated = ThemeEditorUtils.createNewStyle(themeEditorContext.getCurrentContextModule(), dialog.getStyleName(), parentStyleName, fileName, dirNames);
        return isCreated ? dialog.getStyleName() : null;
    }

    public static boolean isSelectedAppCompatTheme(@NotNull ThemeEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "isSelectedAppCompatTheme"));
        }
        ThemeEditorStyle currentTheme = context.getCurrentTheme();
        return currentTheme != null && ThemeEditorUtils.isAppCompatTheme(currentTheme);
    }

    public static boolean isAppCompatTheme(@NotNull ThemeEditorStyle themeEditorStyle) {
        if (themeEditorStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeEditorStyle", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "isAppCompatTheme"));
        }
        ThemeEditorStyle currentTheme = themeEditorStyle;
        for (int i = 0; i < 50 && currentTheme != null; currentTheme = currentTheme.getParent(), ++i) {
            if (!currentTheme.getName().startsWith("Theme.AppCompat") || currentTheme.getSourceModule() != null) continue;
            return true;
        }
        return false;
    }

    public static void copyTheme(int apiLevel, @NotNull XmlTag toBeCopied) {
        if (toBeCopied == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toBeCopied", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "copyTheme"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiFile file = toBeCopied.getContainingFile();
        assert (file instanceof XmlFile) : file;
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        assert (folderType != null) : file;
        FolderConfiguration config = ResourceHelper.getFolderConfiguration(file);
        assert (config != null) : file;
        VersionQualifier qualifier = new VersionQualifier(apiLevel);
        config.setVersionQualifier(qualifier);
        String folder = config.getFolderName(folderType);
        if (folderType != ResourceFolderType.VALUES) {
            OverrideResourceAction.forkResourceFile((XmlFile)file, folder, false);
        } else {
            AndroidFacet facet;
            XmlTag tag = OverrideResourceAction.getValueTag((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)toBeCopied, XmlTag.class, (boolean)false));
            if (tag != null && (facet = AndroidFacet.getInstance((PsiElement)toBeCopied)) != null) {
                PsiDirectory dir = null;
                PsiDirectory resFolder = file.getParent();
                if (resFolder != null) {
                    resFolder = resFolder.getParent();
                }
                if (resFolder != null && (dir = resFolder.findSubdirectory(folder)) == null) {
                    dir = resFolder.createSubdirectory(folder);
                }
                OverrideResourceAction.forkResourceValue(toBeCopied.getProject(), tag, file, facet, dir, false);
            }
        }
    }

    public static int getVersionFromConfiguration(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getVersionFromConfiguration"));
        }
        VersionQualifier qualifier = configuration.getVersionQualifier();
        return qualifier != null ? qualifier.getVersion() : -1;
    }

    public static int getMinFolderApi(@NotNull List<String> folderNames, @NotNull Module module) {
        if (folderNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderNames", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getMinFolderApi"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getMinFolderApi"));
        }
        int minFolderApi = Integer.MAX_VALUE;
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(module);
        for (String folderName : folderNames) {
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfig == null) continue;
            VersionQualifier version = folderConfig.getVersionQualifier();
            int folderApi = version != null ? version.getVersion() : minModuleApi;
            minFolderApi = Math.min(minFolderApi, folderApi);
        }
        return minFolderApi;
    }

    @NotNull
    public static Configuration getConfigurationForModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getConfigurationForModule"));
        }
        Project project = module.getProject();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "moduleComboModel must contain only Android modules";
        ConfigurationManager configurationManager = facet.getConfigurationManager();
        VirtualFile projectFile = project.getProjectFile();
        assert (projectFile != null);
        Configuration configuration = configurationManager.getConfiguration(projectFile);
        if (configuration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getConfigurationForModule"));
        }
        return configuration;
    }

    @NotNull
    public static List<ResourceFolderRepository> getResourceFolderRepositoriesFromSourceSet(@NotNull AndroidFacet facet, @Nullable SourceProvider provider) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceFolderRepositoriesFromSourceSet"));
        }
        if (provider == null) {
            List<ResourceFolderRepository> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceFolderRepositoriesFromSourceSet"));
            }
            return list;
        }
        Collection resDirectories = provider.getResDirectories();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        ArrayList folders = Lists.newArrayListWithExpectedSize((int)resDirectories.size());
        for (File dir : resDirectories) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(dir);
            if (virtualFile == null) continue;
            folders.add(ResourceFolderRegistry.get(facet, virtualFile));
        }
        ArrayList arrayList = folders;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceFolderRepositoriesFromSourceSet"));
        }
        return arrayList;
    }

    public static void acceptResourceResolverVisitor(@NotNull AndroidFacet mainFacet, @NotNull ResourceFolderVisitor visitor) {
        if (mainFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainFacet", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "acceptResourceResolverVisitor"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "acceptResourceResolverVisitor"));
        }
        List dependencies = Lists.reverse(AndroidUtils.getAllAndroidDependencies(mainFacet.getModule(), true));
        for (AndroidFacet dependency : Iterables.concat((Iterable)dependencies, (Iterable)ImmutableList.of((Object)((Object)mainFacet)))) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(dependency);
            if (androidModel == null) {
                SourceProvider provider = dependency.getMainSourceProvider();
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, provider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), provider.getName(), true);
                }
                continue;
            }
            List<SourceProvider> activeProviders = androidModel.getActiveSourceProviders();
            for (SourceProvider sourceProvider : activeProviders) {
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, sourceProvider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), sourceProvider.getName(), true);
                }
            }
            ImmutableSet selectedProviders = ImmutableSet.copyOf(activeProviders);
            for (SourceProvider provider : androidModel.getAllSourceProviders()) {
                if (selectedProviders.contains((Object)provider)) continue;
                for (LocalResourceRepository localResourceRepository : ThemeEditorUtils.getResourceFolderRepositoriesFromSourceSet(dependency, provider)) {
                    visitor.visitResourceFolder(localResourceRepository, dependency.getName(), provider.getName(), false);
                }
            }
        }
    }

    @NotNull
    public static ImmutableList<String> getModuleThemeQualifiedNamesList(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getModuleThemeQualifiedNamesList"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        ConfigurationManager manager = facet.getConfigurationManager();
        final ResourceResolverCache resolverCache = new ResourceResolverCache(manager);
        final IAndroidTarget target = manager.getTarget();
        final HashMap cache = new HashMap();
        final TreeSet themeNamesSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        ResourceFolderVisitor visitor = new ResourceFolderVisitor(){

            @Override
            public void visitResourceFolder(@NotNull LocalResourceRepository resources, String moduleName, @NotNull String variantName, boolean isSelected) {
                if (resources == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resources", "com/android/tools/idea/editors/theme/ThemeEditorUtils$5", "visitResourceFolder"));
                }
                if (variantName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/editors/theme/ThemeEditorUtils$5", "visitResourceFolder"));
                }
                if (!isSelected) {
                    return;
                }
                block0: for (String simpleThemeName : resources.getItemsOfType(ResourceType.STYLE)) {
                    String themeStyleResourceUrl = "@style/" + simpleThemeName;
                    List themeItems = resources.getResourceItem(ResourceType.STYLE, simpleThemeName);
                    assert (themeItems != null);
                    for (ResourceItem themeItem : themeItems) {
                        ResourceResolver resolver = resolverCache.getResourceResolver(target, themeStyleResourceUrl, themeItem.getConfiguration());
                        ResourceValue themeItemResourceValue = themeItem.getResourceValue(false);
                        assert (themeItemResourceValue != null);
                        if (!resolver.isTheme(themeItemResourceValue, cache)) continue;
                        themeNamesSet.add(simpleThemeName);
                        continue block0;
                    }
                }
            }
        };
        ThemeEditorUtils.acceptResourceResolverVisitor(facet, visitor);
        ImmutableList immutableList = ImmutableList.copyOf((Collection)themeNamesSet);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getModuleThemeQualifiedNamesList"));
        }
        return immutableList;
    }

    @NotNull
    public static ChooseResourceDialog getResourceDialog(@NotNull EditedStyleItem item, @NotNull ThemeEditorContext context, ResourceType[] allowedTypes) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceDialog"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceDialog"));
        }
        Module module = context.getModuleForResources();
        Configuration configuration = ThemeEditorUtils.getConfigurationForModule(module);
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        assert (resourceResolver != null);
        ItemResourceValue itemSelectedValue = item.getSelectedValue();
        String value = itemSelectedValue.getValue();
        boolean isFrameworkValue = itemSelectedValue.isFramework();
        String nameSuggestion = value;
        ResourceUrl url = ResourceUrl.parse((String)value, (boolean)isFrameworkValue);
        if (url != null) {
            nameSuggestion = url.name;
        }
        nameSuggestion = ThemeEditorUtils.getDefaultResourceName(context, nameSuggestion);
        ChooseResourceDialog chooseResourceDialog = new ChooseResourceDialog(module, configuration, allowedTypes, value, isFrameworkValue, ChooseResourceDialog.ResourceNameVisibility.FORCE, nameSuggestion);
        if (chooseResourceDialog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getResourceDialog"));
        }
        return chooseResourceDialog;
    }

    @NotNull
    private static String getDefaultResourceName(@NotNull ThemeEditorContext context, @NotNull String initialName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
        }
        if (initialName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialName", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
        }
        if (context.getCurrentTheme() == null || !context.getCurrentTheme().isReadOnly()) {
            String string = initialName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
            }
            return string;
        }
        ResourceResolver resolver = context.getResourceResolver();
        assert (resolver != null);
        ResourceValue value = resolver.findResValue("@color/" + initialName, false);
        if (value == null) {
            String string = initialName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
            }
            return string;
        }
        for (int i = 1; i <= 50; ++i) {
            String name = initialName + "_" + i;
            if (resolver.findResValue("@color/" + name, false) != null) continue;
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultResourceName"));
        }
        return "";
    }

    @NotNull
    public static String simplifyThemeName(@NotNull ThemeEditorStyle theme) {
        if (theme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "simplifyThemeName"));
        }
        String name = theme.getQualifiedName();
        String[] pieces = name.split("\\.");
        String result = pieces.length > 1 && !"Light".equals(pieces[1]) ? pieces[1] : "Theme";
        for (ThemeEditorStyle parent = theme; parent != null; parent = parent.getParent()) {
            if (!"Theme.Light".equals(parent.getName())) continue;
            String string = result + " Light";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "simplifyThemeName"));
            }
            return string;
        }
        String string = result + " Dark";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "simplifyThemeName"));
        }
        return string;
    }

    @NotNull
    public static String generateWordEnumeration(@NotNull Collection<String> words) {
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateWordEnumeration"));
        }
        StringBuilder sentenceBuilder = new StringBuilder();
        int nWords = words.size();
        int i = 0;
        for (String word : words) {
            sentenceBuilder.append(word);
            if (i < nWords - 2) {
                sentenceBuilder.append(", ");
            } else if (i == nWords - 2) {
                sentenceBuilder.append(" and ");
            }
            ++i;
        }
        String string = sentenceBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateWordEnumeration"));
        }
        return string;
    }

    public static interface ResourceFolderVisitor {
        public void visitResourceFolder(@NotNull LocalResourceRepository var1, String var2, @NotNull String var3, boolean var4);
    }

    static class AttributeInheritanceSet
    implements Iterable<ConfiguredElement<ItemResourceValue>> {
        private final HashSet<ConfiguredElement<ItemResourceValue>> myAttributes = Sets.newHashSet();
        private final Map<String, ConfiguredElement<ItemResourceValue>> myAttributesIndex = Maps.newHashMap();

        AttributeInheritanceSet() {
        }

        private static String getItemKey(@NotNull ConfiguredElement<ItemResourceValue> item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ThemeEditorUtils$AttributeInheritanceSet", "getItemKey"));
            }
            return String.format("%1$s - %2$s", item.getConfiguration(), ResolutionUtils.getQualifiedItemName(item.getElement()));
        }

        public boolean add(@NotNull ConfiguredElement<ItemResourceValue> value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/ThemeEditorUtils$AttributeInheritanceSet", "add"));
            }
            String key = AttributeInheritanceSet.getItemKey(value);
            ConfiguredElement<ItemResourceValue> existingValue = this.myAttributesIndex.get(key);
            if (existingValue != null) {
                this.myAttributes.remove(existingValue);
            }
            this.myAttributes.add(value);
            this.myAttributesIndex.put(key, value);
            return existingValue != null;
        }

        @Override
        public Iterator<ConfiguredElement<ItemResourceValue>> iterator() {
            return this.myAttributes.iterator();
        }

        public void addAll(@NotNull AttributeInheritanceSet existingAttributes) {
            if (existingAttributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingAttributes", "com/android/tools/idea/editors/theme/ThemeEditorUtils$AttributeInheritanceSet", "addAll"));
            }
            for (ConfiguredElement<ItemResourceValue> value : existingAttributes) {
                this.add(value);
            }
        }
    }
}

